//
//  ChooseCostViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChooseCostViewController.h"
#define TopMargin 50
#define TableHeight 50
@interface ChooseCostViewController ()

@end

@implementation ChooseCostViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.currentPage = 0;
    self.tableStr = GXF_BASECLASS_ACCOUNTTITLE;
    self.title = @"费用类型";
    self.tableView.header.lastUpdatedTimeKey = ChooseAccountTitleUpdateDate;
    [self fetchDataList:@"" tableStr:GXF_BASECLASS_ACCOUNTTITLE];
}
- (void)getBaseDataFromServerWithStartDate:(NSString *)startDate{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        //请求成功之后
        strongSelf.startDate = startDate;
        [strongSelf getLastDateFromServer:data];
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
        [self endRefreshing];
    };
    if (self.currentPage == 0) {
        [IBTLoadingView showProgressLabel:@"正在加载..."];
    }
    [[ICRHTTPController sharedController] getAccounttitleWithStartDate:startDate
     Page_number:self.currentPage page_size:100 success:succ failure:fail];
}
- (void)getLastDateFromServer:(id)data
{
    if (data) {
        NSDictionary *pageDict = data[ @"data" ][ @"paging" ];
        NSInteger pageCount = [pageDict[@"pageCount"] integerValue];
        if (pageCount <= self.currentPage) {
            [self endRefreshing];
            [IBTLoadingView hideHUDWithText:nil];
            [self fetchDataList:@"" tableStr:GXF_BASECLASS_ACCOUNTTITLE];
        }else{
            self.currentPage++;
            [self getBaseDataFromServerWithStartDate:self.startDate];
        }
    }else{
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    }
    
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    if (self.isMoreChose) {
        if ([self isHaveIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
            cell.titleLabel.textColor = BASESELECT_COLOR;
            
        }else{
            cell.Commitbtn.hidden = YES;
            cell.titleLabel.textColor = [UIColor blackColor];
            
        }
    }else{
        if (self.currentIndexPath) {
            if (indexPath.row == self.currentIndexPath.row) {
                cell.Commitbtn.hidden = NO;
                cell.titleLabel.textColor = BASESELECT_COLOR;
                
            }else{
                cell.Commitbtn.hidden = YES;
                cell.titleLabel.textColor = [UIColor blackColor];
                
            }
        }else{
            cell.Commitbtn.hidden = YES;
            cell.titleLabel.textColor = [UIColor blackColor];
            
        }
    }
    if (self.dataArr.count > 0) {
        if (indexPath.row == 0) {
            NSString *dateStr = [self.dataArr[indexPath.row] httpParameterString];
            cell.titleLabel.textColor = GXF_CONTENT_COLOR;
            [cell setTitleStr:[NSString stringWithFormat:@"上次更新时间:%@",dateStr]];
        }else{
            Accounttitle *accounttitle = self.dataArr[indexPath.row];
            NSString *proStr = [NSString stringWithFormat:@"%@",accounttitle.name];
            [cell setTitleStr:proStr];
        }
    }
    return cell;
}
- (void)boxValueChanged:(NSNotification *)fication{
    NSString *tilkeStr = [IBTCommon trimmingCharacters:self.selectTextFiled.text];
    [self fetchDataList:tilkeStr tableStr:GXF_BASECLASS_ACCOUNTTITLE];
}
- (void)tableViewRefresh:(NSString *)titltstr{
    if (titltstr.length > 0) {
        [super tableViewRefresh:titltstr];
    }else{
        if (self.selectStr.length>0) {
            if (!self.isMoreChose) {
                for (NSInteger i = 1;i< self.dataArr.count; i++) {
                    Accounttitle *type = self.dataArr[i];
                    if ([type.name isEqualToString:self.selectStr]) {
                        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:i inSection:0];
                        self.currentIndexPath = indexPath;
                        break;
                    }
                }
                [self.tableView reloadData];
            }
        }else{
            [super tableViewRefresh:titltstr];
        }
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
