//
//  GXFFunctionDBHelper.m
//  XFFruit
//
//  Created by freecui on 15/8/28.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "GXFFunctionDBHelper.h"
#import "GXFFunctionDB.h"

@interface GXFFunctionDBHelper ()
//@property (nonatomic, strong)GXFFunctionDB *functionDb;

@end
@implementation GXFFunctionDBHelper
+ (instancetype)sharedInstance{

    static GXFFunctionDBHelper *dbHelper = nil;
    static  dispatch_once_t once;
    dispatch_once(&once, ^{
        dbHelper = [[GXFFunctionDBHelper alloc]init];
    });
    
    return dbHelper;
}

////开启一次就可以了
//- (void)openDb {
//    self.functionDb = [GXFFunctionDB sharedInstance];
//    [_functionDb functionTableCreate];
//    [_functionDb displayFunctionTableCreate];
//}
- (void)insertAllOriginFunctions{
    NSArray *functionsArr = [NSArray arrayWithArray:[self p_readJsonFile]];
    
    
    for (int count = 0; count < functionsArr.count; count ++) {
        GXFFunction *function = (GXFFunction *)functionsArr[count];
        [[GXFFunctionDB sharedInstance] insertFunction:function];
    }
}


//从读出的json文件返回GXFFunction数组
- (NSArray *)p_readJsonFile {
    
    NSMutableArray *muArr = [NSMutableArray array];
    //添加公告
    GXFFunction *function = [[GXFFunction alloc]init];
    function.Id = 000000;
    function.name = @"announcement";
    function.caption = @"公告";
    function.hasPermission = YES;
    function.isSelected = NO;
    [muArr addObject:function];
    
    NSString *path = [[NSBundle mainBundle] pathForResource:@"PermissionJson" ofType:nil];
    NSData *jsonData = [NSData dataWithContentsOfFile:path options:NSDataReadingMappedIfSafe error:nil];
    NSDictionary *dict = [NSJSONSerialization JSONObjectWithData:jsonData options: NSJSONReadingMutableContainers error:nil];
    NSArray *childrenArr = dict[@"children"];
    for (int i = 0; i < childrenArr.count; i ++) {
        
        NSArray *permissionsArr = [childrenArr[i] objectForKey:@"permissions"];
        for (int j = 0; j < permissionsArr.count; j++) {
            
            NSMutableDictionary *muDict = [NSMutableDictionary dictionaryWithObjects:@[@(0),@(0)] forKeys:@[@"hasPermission",@"isSelected"]];
            [muDict addEntriesFromDictionary:permissionsArr[j]];
            
            GXFFunction *function = [[GXFFunction alloc]initWithDictionary:muDict];
            [muArr addObject:function];
        }
    }
    
    return muArr;
}


- (void)insertAllOriginDisplayFunctions{
    NSArray *arr = [self p_createAllDisplayFunctions];
    for (int count = 0; count < arr.count; count ++) {
        GXFDisplayFunction *displayFunction = (GXFDisplayFunction *)arr[count];
        [[GXFFunctionDB sharedInstance] insertDisplayFunction:displayFunction];
    }
}

- (NSArray *)p_createAllDisplayFunctions{
    NSArray *functionsId = @[@(000000),
                             @(500101),@(500102),@(500103),
                             @(500201),
                             @(500301),@(500302),@(500303),//"采购通知",
                             @(500401),@(500402),@(500403),@(500406),//"采购单"
                             @(500501),@(500502),@(500503),//"发运单"
                             @(500601),@(500602),@(500603),//"转运单"
                             @(500701),@(500702),@(500703),];//加工单
    NSArray *functionsName = @[@"公告",
                               @"新建行情调研",@"查看行情调研",  @"查看行情调研",
                               @"填写行情反馈",
                               @"新建采购通知",@"查看采购通知",  @"查看采购通知",
                               @"新建采购单",@"查看采购单",     @"查看采购单",  @"审核采购单【供应商】",
                               @"新建发运单",@"查看发运单",     @"查看发运单",
                               @"新增加工单",@"查看加工单",     @"查看加工单",
                               @"新建转运单", @"查看转运单",    @"查看转运单"];
    NSArray *functionsImageName = @[@"notice",
                                @"create_surver",@"watch_surver",   @"watch_surver",
                                @"create_surver_result",
                                @"create_needs",@"watch_needs",      @"watch_needs",
                                @"create_purchase",@"watch_purchase",   @"watch_purchase",  @"review_purchase",
                                @"create_transport",@"watch_transort",   @"watch_transort",
                                @"create_process",@"watch_process",      @"watch_process",
                                @"新建转运单", @"查看转运单",           @"查看转运单"];
    
    //NSArray *functionsSmallImgName = @[];
    NSArray *functionItemTag = @[@(0),
                                 @(1),@(2),@(2),
                                 @(3),
                                 @(4),@(5),@(5),//"采购通知",
                                 @(6),@(7),@(7),@(8),//"采购单"
                                 @(9),@(10),@(10),//"发运单"
                                 @(11),@(12),@(12),//"转运单"
                                 @(13),@(14),@(14),];//加工单
    if ((functionsId.count != functionsName.count) ||(functionsId.count != functionsImageName.count)||(functionsName.count != functionsImageName.count)) {
        NSLog(@"展现功能界面：插入的数据不是一一对应的");
        return nil;
    }
    
    NSMutableArray *muarr = [NSMutableArray array];
    for (int count = 0; count < functionsId.count; count ++) {
        GXFDisplayFunction *displayFunction = [[GXFDisplayFunction alloc]init];
        displayFunction.functionId = [functionsId[count] integerValue];
        displayFunction.functionName = functionsName[count];
        displayFunction.functionImgName = functionsImageName[count];
        //displayFunction.functionSmallImgName = fu
        displayFunction.functionItemTag = [functionItemTag[count] integerValue];
        [muarr addObject:displayFunction];
    }

    
    return muarr;
}

- (BOOL)successInsertOriginFunctions{
    return [[GXFFunctionDB sharedInstance] originFunctions].count > 0 ? YES : NO;
}
- (BOOL)sucessInsertOriginDisplayFunctions {
    return [[GXFFunctionDB sharedInstance] originDisplayFunctions].count > 0 ? YES : NO;
}
@end
