//
//  ICRHTTPController.h
//  XFFruit
//
//  Created by Xummer on 3/26/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"
#import "ICRAnnouncement.h"

typedef NS_ENUM(NSUInteger, ICRAttachmentType) {
    kAttachmentBoard = 0,
    kAttachmentAnswer,
    kAttachmentTask,
    
    // Insert enum here
    kAttachmentTypeCount,
};


@interface ICRHTTPController : IBTObject

+ (instancetype)sharedController;

// Restful API

// User
/* 用户登录验证（读）*/
- (void)doLoginWithUserName:(NSString *)userName
                   password:(NSString *)password
               registerCode:(NSString *)registerCode
                    success:(void (^)(id data))succ
                    failure:(void (^)(id data))fail;

/* 密码修改（写）*/
- (void)doChangePassword:(NSString *)nsPassword
             newPassword:(NSString *)nsNewPassword
                 success:(void (^)(id data))succ
                 failure:(void (^)(id data))fail;

// Data
/* 门店基本资料（读）
    返回最后修改日期从某时刻开始的该用户可见的门店 
 */
- (void)doGetStoreListFromUpdateTime:(NSTimeInterval)updateTime
                            position:(NSUInteger)uiPosition
                                size:(NSUInteger)uiSize
                             success:(void (^)(id data))succ
                             failure:(void (^)(id data))fail;

/* 组织架构基本资料（读）
    获得本人所属组织
 */
- (void)doGetCurrentOrgWithSuccess:(void (^)(id data))succ
                           failure:(void (^)(id data))fail;

/* 任务类别基本资料
 获得本人所属组织的工单类别信息，提任务单时需要用
 */
- (void)doGetPersonListFromUpdateTime:(NSString *)updateTime
                           position:(NSUInteger)uiPosition
                               size:(NSUInteger)uiSize
                            success:(void (^)(id data))succ
                            failure:(void (^)(id data))fail;

// Board
/* 公告列表（读）
    获得公告列表
 */
- (void)doGetBoardListFromUpdateTime:(NSString *)updateTime
                            position:(NSUInteger)uiPosition
                                size:(NSUInteger)uiSize
                                type:(ICRAnnouncementType)eType
                         deleteLocal:(BOOL)bDeleteLocal
                             success:(void (^)(id data))succ
                             failure:(void (^)(id data))fail;

/* 读取公告（读）
    读取单个公告
 */
- (void)doGetBoardWithID:(NSNumber *)boardID
                 success:(void (^)(id data))succ
                 failure:(void (^)(id data))fail;

/* 提交公告已读状态（写）*/
- (void)doReadBoardWithID:(NSNumber *)boardID
                  success:(void (^)(id data))succ
                  failure:(void (^)(id data))fail;

// Patrol
/* 巡店计划列表（读）
    获得发布给自己的巡店计划
 */
- (void)doGetMyPatrolFromUpdateTime:(NSString *)updateTime
                           position:(NSUInteger)uiPosition
                               size:(NSUInteger)uiSize
                            success:(void (^)(id data))succ
                            failure:(void (^)(id data))fail;

/* 下载某个门店结果（读）*/
- (void)doGetStoreResultWithPlanID:(NSString *)planID
                           storeID:(NSString *)storeID
                           success:(void (^)(id data))succ
                           failure:(void (^)(id data))fail;

/* 巡店计划处理结果（写）*/
- (void)doAnswerPatrolPlanWithID:(NSNumber *)planID
                        infoData:(id)data
                         success:(void (^)(id data))succ
                         failure:(void (^)(id data))fail;

/* 巡店计划某个问题处理结果
    需要先调用接口|doAnswerPlanWithID:postData:success:failure:|，得到门店报告id
 */
- (void)doAnswerOnePatrolResultWithID:(NSNumber *)resultID
                             infoData:(id)data
                              success:(void (^)(id data))succ
                              failure:(void (^)(id data))fail;

/* 任务列表（读）*/
- (void)doGetTaskListFromUpdateTime:(NSString *)updateTime
                           position:(NSUInteger)uiPosition
                               size:(NSUInteger)uiSize
                            success:(void (^)(id data))succ
                            failure:(void (^)(id data))fail;

/* 新增任务（写）*/
- (void)doCreateNewTaskWithInfo:(id)data
                        success:(void (^)(id data))succ
                        failure:(void (^)(id data))fail;

/* 任务处理结果（写）*/
- (void)doUpdateTaskResultID:(NSString *)resultID
                  resultText:(NSString *)resultStr
               processDate:(NSTimeInterval)processDate
                   success:(void (^)(id data))succ
                   failure:(void (^)(id data))fail;

// Signup
/* 签到信息提交（写）*/
- (void)doSignupWithInfo:(id)data
                 success:(void (^)(id data))succ
                 failure:(void (^)(id data))fail;

// Attachment
/* 添加附件（读）*/
- (void)doAddAttachment:(id)data
                success:(void (^)(id data))succ
                failure:(void (^)(id data))fail;

/* 返回附件列表 */
- (void)doGetAttachmentListWithType:(ICRAttachmentType)eType
                              objID:(NSString *)objID
                            success:(void (^)(id data))succ
                            failure:(void (^)(id data))fail;

/* 下载附件 */
- (void)doDownloadAttachmentWithID:(NSNumber *)attachmentID
                           success:(void (^)(id data))succ
                           failure:(void (^)(id data))fail;

/* 添加附件（读）直接上传方式 */
- (void)doAddDirectAttachment:(id)data
                      success:(void (^)(id))succ
                      failure:(void (^)(id))fail;

+ (NSString *)AttachmentUrlWithID:(id)attachmentID;

/* 下载附件，直接下载方式 */
- (void)doDownloadDirectAttachment:(NSString *)attachmentId
                           success:(void (^)(id))succ
                           failure:(void (^)(id))fail;

// Version
/* 查询版本（读）*/
- (void)doFetchVersionWithCurrent:(NSString *)currentVersion
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;

//添加行情调研单
- (void)saveSurveyWithAuthenticode:(id)data
                           success:(void (^)(id))succ
                           failure:(void (^)(id))fail;

//获取行情调研单列表
- (void)querySurveyWithBillData:(id)data
                               success:(void (^)(id))succ
                               failure:(void (^)(id))fail;
//获取行情调研单详情
- (void)getResultWithSurveyUuid:(NSString *)surveyUuid
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;

//下载商品信息
- (void)getProductWithPage_number:(NSUInteger)page_number
                        page_size:(NSUInteger)page_size
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;
//下载用户信息
- (void)getUserWithPage_number:(NSUInteger)page_number
                        page_size:(NSUInteger)page_size
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;
//生成行情反馈图片
- (void)resultChartWithResultUuid:(NSString *)uuid
                            width:(NSNumber *)width
                           height:(NSNumber *)height
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;

//结束行情反馈(写)
- (void)surveyFinishWithUuid:(NSString *)uuid
                     version:(NSNumber *)version
                     success:(void (^)(id))succ
                     failure:(void (^)(id))fail;

//获取行情调研单反馈列表
- (void)getResultsWithUuid:(NSString *)uuid
                     success:(void (^)(id))succ
                     failure:(void (^)(id))fail;

//供应商
- (void)getVendorWithPage_number:(NSUInteger)page_number
                        page_size:(NSUInteger)page_size
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;
//仓库
- (void)getWarehouseWithPage_number:(NSUInteger)page_number
                       page_size:(NSUInteger)page_size
                         success:(void (^)(id))succ
                         failure:(void (^)(id))fail;

//添加采购单
- (void)savePurchaseWithData:(id)data
                           success:(void (^)(id))succ
                           failure:(void (^)(id))fail;


@end


