//
//  ICRFunctionBaseView.m
//  XFFruit
//
//  Created by Lili Wang on 15/4/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#define FUNCTION_COUNT_EACH_ROW (3)
#define MODULE_VIEW_WIDTH  IBT_MAIN_SCREEN_WIDTH/FUNCTION_COUNT_EACH_ROW
#define HEIGHT_WIDTH_PROPORTION 112.0/105.0
#define MODULE_VIEW_HEIGHT MODULE_VIEW_WIDTH * HEIGHT_WIDTH_PROPORTION


#import "ICRFunctionBaseView.h"
#import "ICRFunctionEntity.h"

@interface ICRFunctionBaseView()

@property (nonatomic, assign) NSUInteger m_rows;
@property (nonatomic, assign) NSUInteger m_imageCountsOfLastRow;
@property (nonatomic, strong)  NSArray  *m_arrFunctions;

@end

@implementation ICRFunctionBaseView

#pragma mark - life Cycle
- (id) initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        // code
        
    }
    return self;
}

#pragma mark - Public Method

+ (ICRFunctionBaseView *)initWithFunctionData:(NSArray *)arrFunctions {
    ICRFunctionBaseView *baseView = [[ICRFunctionBaseView alloc] init];
    
    baseView.m_rows = [baseView calculateShowRows:arrFunctions];
    baseView.m_imageCountsOfLastRow = [baseView calculateRemainderLastRow:arrFunctions];
    
    NSUInteger count = FUNCTION_COUNT_EACH_ROW;
    for (int i = 0; i < baseView.m_rows; i ++) {
        if (i == baseView.m_rows - 1 && baseView.m_imageCountsOfLastRow > 0) {
            count = baseView.m_imageCountsOfLastRow;
        }
        for (int j = 0; j < count; j ++) {
            
            int indexValue = FUNCTION_COUNT_EACH_ROW * i + j;
            
            ICRFunctionEntity *functionEntity = [arrFunctions objectAtIndex:indexValue];
            
            UIImage *functionImage = [UIImage imageNamed:functionEntity.iconName];
            NSString *functionLabelTitle = functionEntity.functionName;
            
            ICRFunctionItemControl *fControl = [ICRFunctionItemControl highLightControl];
            fControl.frame = (CGRect){
                .origin.x = MODULE_VIEW_WIDTH * j,
                .origin.y = MODULE_VIEW_HEIGHT * i,
                .size.width = MODULE_VIEW_WIDTH,
                .size.height = MODULE_VIEW_HEIGHT
            };
            fControl.functinNameLabel.text = functionLabelTitle;
            fControl.functionImage.image = functionImage;
            fControl.tag = functionEntity.functionItemTag;
            [fControl addTarget:baseView action:@selector(singleImageClike:) forControlEvents:UIControlEventTouchUpInside];
            [baseView addSubview:fControl];
        }
    }
    baseView.height = MODULE_VIEW_HEIGHT * baseView.m_rows;
    return baseView;
}

#pragma mark - Private Method
- (NSUInteger)calculateShowRows:(NSArray *)arrImages {
    
    NSUInteger remainder = arrImages.count % FUNCTION_COUNT_EACH_ROW;
    NSUInteger rows = arrImages.count / FUNCTION_COUNT_EACH_ROW;
    
    rows = remainder > 0 ? rows + 1 : rows;
    
    return rows;
}
- (NSUInteger)calculateRemainderLastRow:(NSArray *)arrImages {
    return arrImages.count % FUNCTION_COUNT_EACH_ROW;
}

#pragma mark - ICRFuctionItemControlDelegate 
- (void)singleImageClike:(ICRFunctionItemControl *)imageView {
    if ([self.m_delegate respondsToSelector:@selector(ICRFunctionBaseView:)]) {
        [self.m_delegate ICRFunctionBaseView:imageView];
    }
}

@end
