//
//  ICRAnnocementContentView.m
//  XFFruit
//
//  Created by Lili Wang on 15/4/14.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#define PRIORITY_LABEL_HEIGHT       30
#define PRIORITY_LABEL_LEFT_PANDING 15
#define PRIORITY_IMAGE_TOP_PANDING  20
#define TITLE_LABEL_TOP_PANDING     15
#define TITLE_LABEL_HEIGHT          15
#define CREAT_BY_LABEL_HEIGHT       14
#define CREAT_BY_LABEL_TOP_PANDING  6
#define CREAT_BY_TEXT_COLOR [UIColor colorWithRed:0.749f green:0.749f blue:0.749f alpha:1.00f]

#import "ICRAnnocementContentView.h"
#import "ICRAnnouncement.h"

@interface ICRAnnocementContentView  ()

@property (strong, nonatomic) UILabel *m_priorityLabel;
@property (strong, nonatomic) UILabel *m_titleLabel;
@property (strong, nonatomic) UILabel *m_creatByLabel;
@property (strong, nonatomic) UILabel *m_creatTimeLabel;
@property (strong, nonatomic) UILabel *m_creatByValueLabel;
@property (strong, nonatomic) UILabel *m_creatTimeValueLabel;

@end

@implementation ICRAnnocementContentView

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        // code
        [self _init];
    }
    return self;
}

- (void)layoutSubviews {
    
    _m_priorityLabel.frame = (CGRect){
        .origin.x = PRIORITY_LABEL_LEFT_PANDING,
        .origin.y = (self.height - PRIORITY_LABEL_HEIGHT)/2,
        .size.width = PRIORITY_LABEL_HEIGHT,
        .size.height = PRIORITY_LABEL_HEIGHT
    };
    
    CGFloat fMaxW = self.width - PRIORITY_LABEL_LEFT_PANDING;
    
    CGSize size = CGSizeMake( fMaxW - _m_priorityLabel.right , TITLE_LABEL_HEIGHT);
    size = [_m_titleLabel widthLimitedSizeThatFits:size];
    _m_titleLabel.frame = (CGRect){
        .origin.x = _m_priorityLabel.right + CREAT_BY_LABEL_TOP_PANDING,
        .origin.y = _m_priorityLabel.top,
        .size = size
    };
    
    size = CGSizeMake( fMaxW - _m_priorityLabel.right , TITLE_LABEL_HEIGHT);
    size = [_m_creatByLabel widthLimitedSizeThatFits:size];
    _m_creatByLabel.frame = (CGRect){
        .origin.x = _m_priorityLabel.right + CREAT_BY_LABEL_TOP_PANDING,
        .origin.y = CREAT_BY_LABEL_TOP_PANDING + _m_titleLabel.bottom,
        .size = size
    };
    
    size = CGSizeMake( fMaxW - _m_creatByLabel.right,CREAT_BY_LABEL_HEIGHT );
    size = [_m_creatByValueLabel widthLimitedSizeThatFits:size];
    _m_creatByValueLabel.frame = (CGRect){
        .origin.x = _m_creatByLabel.right,
        .origin.y = _m_creatByLabel.top,
        .size.width = size.width,
        .size.height = _m_creatByLabel.height
    };
    
    size = CGSizeMake( fMaxW - _m_creatByValueLabel.right , _m_creatByLabel.height );
    size = [_m_creatTimeLabel widthLimitedSizeThatFits:size];
    _m_creatTimeLabel.frame = (CGRect){
        .origin.x = _m_creatByValueLabel.right + CREAT_BY_LABEL_TOP_PANDING,
        .origin.y = _m_creatByValueLabel.top,
        .size.width = size.width,
        .size.height = _m_creatByValueLabel.height
    };
    
    size = CGSizeMake( fMaxW - _m_creatTimeLabel.right, _m_creatTimeLabel.height);
    size = [_m_creatTimeValueLabel widthLimitedSizeThatFits:size];
    _m_creatTimeValueLabel.frame = (CGRect){
        .origin.x = _m_creatTimeLabel.right,
        .origin.y = _m_creatTimeLabel.top,
        .size.width = size.width,
        .size.height = _m_creatTimeLabel.height
    };
    
}

#pragma mark - Private Method
- (void)_init {
    
    self.m_priorityLabel = [[self class ]creatLabelWithTextColor:[UIColor whiteColor]
                                                textFont:[UIFont systemFontOfSize:14]
                                           textAlignment:NSTextAlignmentCenter];
    _m_priorityLabel.backgroundColor = [UIColor colorWithPatternImage:
                                        [UIImage imageNamed:@"PriorityTagGrey"]];
    _m_priorityLabel.layer.masksToBounds = YES;
    _m_priorityLabel.layer.cornerRadius = PRIORITY_LABEL_HEIGHT * 0.5;
    [self addSubview:_m_priorityLabel];
    
    self.m_titleLabel = [[self class ] creatLabelWithTextColor:[UIColor colorWithRed:0.165f green:0.165f blue:0.165f alpha:1.00f]
                                             textFont:[UIFont systemFontOfSize:15]
                                        textAlignment:NSTextAlignmentLeft];
    [self addSubview:_m_titleLabel];
    
    self.m_creatByLabel = [[self class ] creatLabelWithTextColor:CREAT_BY_TEXT_COLOR
                                               textFont:[UIFont systemFontOfSize:13]
                                          textAlignment:NSTextAlignmentLeft];
    _m_creatByLabel.text = [IBTCommon localizableString:@"Publisher:"];
    [self addSubview:_m_creatByLabel];
    
    self.m_creatTimeLabel = [[self class ] creatLabelWithTextColor:CREAT_BY_TEXT_COLOR
                                                 textFont:[UIFont systemFontOfSize:13]
                                            textAlignment:NSTextAlignmentLeft];
    _m_creatTimeLabel.text = [IBTCommon localizableString:@"Publish Time:"];
    [self addSubview:_m_creatTimeLabel];
    
    self.m_creatByValueLabel = [[self class ] creatLabelWithTextColor:CREAT_BY_TEXT_COLOR
                                                    textFont:[UIFont systemFontOfSize:13]
                                               textAlignment:NSTextAlignmentLeft];;
    [self addSubview:_m_creatByValueLabel];
    
    self.m_creatTimeValueLabel = [[self class ] creatLabelWithTextColor:CREAT_BY_TEXT_COLOR
                                                      textFont:[UIFont systemFontOfSize:13]
                                                 textAlignment:NSTextAlignmentLeft];;
    [self addSubview:_m_creatTimeValueLabel];
    
}

#pragma mark - Private Method

+ (UILabel *)creatLabelWithTextColor:(UIColor *)textColor
                            textFont:(UIFont *)textFont
                       textAlignment:(NSTextAlignment)textAlignment {
    UILabel *label = [[UILabel alloc] init];
    label.backgroundColor = [UIColor clearColor];
    label.textColor = textColor;
    label.font = textFont;
    label.textAlignment = textAlignment;
    return label;
}

#pragma mark - Public Method
- (void)updateContentWithData:(id)aAnnouncement {
    
    /*
     kICRAnnouncementStatusHigh = 0,
     kICRAnnouncementStatusLow,
     kICRAnnouncementStatusNormal
     */
    /*
     kICRAnnouncementTypeReaded = 0,
     kICRAnnouncementTypeUnread
     */
    /*
     "Low"                                    = "低";
     "Normal"                                 = "中";
     "High"                                   = "高";
     */
    
    if ([aAnnouncement isKindOfClass:[ICRAnnouncement class]]) {
        ICRAnnouncement *announcement = aAnnouncement;
        
        switch (announcement.state) {
            case kICRAnnouncementTypeUnread:
            {
                switch (announcement.priority) {
                    case kICRAnnouncementStatusLow:
                    {
                        self.m_priorityLabel.text = [IBTCommon localizableString:@"Low"];
                        self.m_priorityLabel.backgroundColor = [UIColor colorWithPatternImage:
                                                                [UIImage imageNamed:@"PriorityTagGreen"]];
                    }
                        break;
                    case kICRAnnouncementStatusNormal:
                    {
                        self.m_priorityLabel.text = [IBTCommon localizableString:@"Normal"];
                        self.m_priorityLabel.backgroundColor = [UIColor colorWithPatternImage:
                                                                [UIImage imageNamed:@"PriorityTagOrange"]];
                    }
                        break;
                    case kICRAnnouncementStatusHigh:
                    {
                        self.m_priorityLabel.text = [IBTCommon localizableString:@"High"];
                        self.m_priorityLabel.backgroundColor = [UIColor colorWithPatternImage:
                                                                [UIImage imageNamed:@"PriorityTagRed"]];
                    }
                        break;
                    default:
                        break;
                }
            }
                break;
            case kICRAnnouncementTypeReaded:
            {
                switch (announcement.priority) {
                    case kICRAnnouncementStatusLow:
                    {
                        self.m_priorityLabel.text = [IBTCommon localizableString:@"Low"];
                    }
                        break;
                    case kICRAnnouncementStatusNormal:
                    {
                        self.m_priorityLabel.text = [IBTCommon localizableString:@"Normal"];
                    }
                        break;
                    case kICRAnnouncementStatusHigh:
                    {
                        self.m_priorityLabel.text = [IBTCommon localizableString:@"High"];
                    }
                        break;
                    default:
                        break;
                }
                self.m_priorityLabel.backgroundColor = [UIColor colorWithPatternImage:[UIImage imageNamed:@"PriorityTagGrey"]];
            }
                break;
            default:
                break;
        }
        self.m_titleLabel.text = announcement.title ? : @"";
        self.m_creatByValueLabel.text = [announcement createInfo ][@"operator"][@"operName"] ? :@"";
        self.m_creatTimeValueLabel.text = [announcement createInfo ][@"time"]? : @"";
    }
    
    
    [self setNeedsLayout];
}
@end
