//
//  ICRPatrolPlan.h
//  XFFruit
//
//  Created by Lili Wang on 15/5/29.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "IBTModel.h"

typedef NS_ENUM(NSUInteger, ICRPatrolPlanStatus) {
    kICRPatrolPlanStatusCreated = 0,
    kICRPatrolPlanStatusCommited,
    kICRPatrolPlanStatusExeted,
    kICRPatrolPlanStatusFinished,
    kICRPatrolPlanStatusCanceld,
};

@interface ICRPatrolPlan : IBTModel
@property (copy, nonatomic) NSString *pID;
@property (copy, nonatomic) NSString *beginDate;
@property (copy, nonatomic) NSString *cancelInfo;
@property (copy, nonatomic) NSDictionary *createInfo;
@property (copy, nonatomic) NSString *endDate;
@property (copy, nonatomic) NSString *enterprise;
@property (copy, nonatomic) NSArray *inspectors;
@property (copy, nonatomic) NSDictionary *lastModifyInfo;
@property (copy, nonatomic) NSString *name;
@property (copy, nonatomic) NSArray *questions;
@property (assign, nonatomic) NSInteger recordLocation;
@property (copy, nonatomic) NSString *remark;
@property (copy, nonatomic) NSString *category;
@property (copy, nonatomic) NSArray *results;
@property (assign, nonatomic) NSInteger state;
@property (copy, nonatomic) NSDictionary *submitInfo;

@property (assign, nonatomic) NSInteger version;

@end
