//
//  ICRHTTPApiTestViewController.m
//  XFFruit
//
//  Created by Xummer on 15/3/31.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ICRHTTPApiTestViewController.h"
#import "ICRPostAttachment.h"

@interface ICRHTTPApiTestViewController ()

@property (strong, nonatomic) IBTTableViewInfo *m_tableViewInfo;

@end

@implementation ICRHTTPApiTestViewController

#pragma mark - Life Cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.title = @"HTTP API";
    [self initTableViewInfo];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method
- (void)initTableViewInfo {
    self.m_tableViewInfo = [[IBTTableViewInfo alloc] initWithFrame:self.view.bounds style:UITableViewStyleGrouped];
    
    IBTTableView *tableV = [_m_tableViewInfo getTableView];
    [self.view addSubview:tableV];
    
    IBTTableViewSectionInfo *secInfo;
    IBTTableViewCellInfo *cellInfo;
    
    // User
    secInfo = [IBTTableViewSectionInfo sectionInfoHeader:@"/user"];
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onLogin:) target:self
                                    title:@"/login/{loginname}"
                               rightValue:nil
                            accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onChangePassword:) target:self
                                     title:@"/resetPassword"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    
    [_m_tableViewInfo addSection:secInfo];
    
    // Data
    secInfo = [IBTTableViewSectionInfo sectionInfoHeader:@"/data"];
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onStoreQuery:) target:self
                                     title:@"/store/query"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];

    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onCurrentOrg:) target:self
                                     title:@"/organization/currentOrg"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onPostQuery:) target:self
                                     title:@"/post/query"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    [_m_tableViewInfo addSection:secInfo];
    
    // Board
    secInfo = [IBTTableViewSectionInfo sectionInfoHeader:@"/board"];
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onBoardQuery:) target:self
                                     title:@"/query"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onFetchBoard:) target:self
                                     title:@"/<board_id>"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onReadBoard:) target:self
                                     title:@"/read/<board_id>"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    [_m_tableViewInfo addSection:secInfo];
    
    // Patrol
    secInfo = [IBTTableViewSectionInfo sectionInfoHeader:@"/patrol"];
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onPatrolQuery:) target:self
                                     title:@"/query"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onStoreResult:) target:self
                                     title:@"/answer/storeResult/<planId>/<storeId>"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onPatrolAnswer:) target:self
                                     title:@"/answer/<plan_id>"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];

    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onPatrolOneAnswer:) target:self
                                     title:@"/oneAnswer/<result_Id>"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    [_m_tableViewInfo addSection:secInfo];

    // Task
    secInfo = [IBTTableViewSectionInfo sectionInfoHeader:@"/task"];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onTaskQuery:) target:self
                                     title:@"/query"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onNewTask:) target:self
                                     title:@"/new"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onTaskResult:) target:self
                                     title:@"/result/<mobileId>"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    [_m_tableViewInfo addSection:secInfo];

    // Signup
    secInfo = [IBTTableViewSectionInfo sectionInfoHeader:@"/signup"];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onSignup:) target:self
                                     title:@"/signup"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    [_m_tableViewInfo addSection:secInfo];

    // Attachment
    secInfo = [IBTTableViewSectionInfo sectionInfoHeader:@"/attachment"];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onAddAttachment:) target:self
                                     title:@"/add"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onListAttachment:) target:self
                                     title:@"/list"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onAddDirectAttachment:) target:self
                                     title:@"/addDirect"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onDownloadDirectAttachment:) target:self
                                     title:@"/downloadDirect/<attachment_id>"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    [_m_tableViewInfo addSection:secInfo];
    
    // Version
    secInfo = [IBTTableViewSectionInfo sectionInfoHeader:@"/version"];
    
    cellInfo =
    [IBTTableViewCellInfo normalCellForSel:@selector(onFetchVersion:) target:self
                                     title:@"/fetch/<request_id>"
                                rightValue:nil
                             accessoryType:UITableViewCellAccessoryNone];
    [secInfo addCell:cellInfo];
    [_m_tableViewInfo addSection:secInfo];
}


#pragma mark -
#pragma mark - HTTPAPI

#pragma mark - User
- (void)onLogin:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doLoginWithUserName:@"kevin"
                         password:@"aaa"
                     registerCode:@"A93jie957lK"
                          success:NULL
                          failure:NULL];
}

- (void)onChangePassword:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doChangePassword:@"bbb"
                   newPassword:@"aaa"
                       success:NULL
                       failure:NULL];
}

#pragma mark - Data
- (void)onStoreQuery:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doGetStoreListFromUpdateTime:0 position:0 size:20
                                   success:NULL failure:NULL];
}

- (void)onCurrentOrg:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doGetCurrentOrgWithSuccess:NULL failure:NULL];
}

- (void)onPersonQuery:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doGetPersonListFromUpdateTime:nil position:0 size:20 success:NULL failure:NULL];
}

#pragma mark - Board
- (void)onBoardQuery:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doGetBoardListFromUpdateTime:nil position:0 size:20 type:kICRAnnouncementTypeReaded deleteLocal:YES success:NULL failure:NULL];
}

- (void)onFetchBoard:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doGetBoardWithID:@( 12 ) success:NULL failure:NULL];
}

- (void)onReadBoard:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doReadBoardWithID:@( 12 ) success:NULL failure:NULL];
}

#pragma mark - Patrol
- (void)onPatrolQuery:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doGetMyPatrolFromUpdateTime:0 position:0 size:20 success:NULL failure:NULL];
}

- (void)onStoreResult:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doGetStoreResultWithPlanID:@( 14 ) storeID:@( 1 ) success:NULL failure:NULL];
}

- (void)onPatrolAnswer:(__unused id)sender {
    /*
     request body
     {
         "answers": [
         {
             "answerDetails": [
             {
             "mobileId": "352136063344242150208202744621841682",
             "answer": 2,
             "seq": 1
             }
             ],
             "content": "",
             "mobileId": "352136063344242150208201951492456126",
             "patrolQuestion": 34,
             "score": 0
         },
         {
         "answerDetails": [
             {
             "mobileId": "352136063344242150208202744621841682",
             "answer": 2,
             "seq": 1
             },
             {
             "mobileId": "352136063344242150208202744621841682",
             "answer": 4,
             "seq": 1
             }
             ],
             "content": "",
             "mobileId": "352136063344242150208201951492456126",
             "patrolQuestion": 35,
             "score": 0
         },
         {
             "answerDetails": [],
             "content": "",
             "mobileId": "352136063344242150208201955570455689",
             "patrolQuestion": 36,
             "content": "这是文字回复"
             },
             {
             "answerDetails": [],
             "content": "",
             "mobileId": "352136063344242150208202001581736800",
             "patrolQuestion": 37,
             "score": 8
         },
         {
         "answerDetails": [
         {
             "mobileId": "352136063344242150208202745409259531",
             "intResult": 30,
             "seq": 1
             },
             {
             "mobileId": "352136063344242150208202745409259531",
             "intResult": 230,
             "seq": 2
             },
             {
             "mobileId": "352136063344242150208202745409259531",
             "intResult": 40,
             "seq": 3
             }
             ],
             "content": "",
             "mobileId": "352136063344242150208202002821197558",
             "patrolQuestion": 38,
             "score": 0
         },
         {
         "answerDetails": [
         {
             "mobileId": "352136063344242150208202745409259531",
             "stringResult": "还不错",
             "seq": 1
             },
             {
             "mobileId": "352136063344242150208202745409259531",
             "stringResult": "马马虎虎",
             "seq": 2
             }
             ],
             "content": "",
             "mobileId": "352136063344242150208202009269242611",
             "patrolQuestion": 40,
             "score": 0
         },
         {
             "content": "",
             "mobileId": "352136063344242150208202003974675375",
             "patrolQuestion": 41,
             "score": 4
             }
             ],
             "latitude": "31.061215",
             "longitude": "121.234652",
             "mobileId": "352136063344242150208201951227469970",
             "note": "这是一个测试",
             "patrolEndTime": "2015-02-08 20:57:55",
             "patrolStartTime": "2015-02-08 20:19:51",
             "storeId": 1
        }
     }
     */
    
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doAnswerPatrolPlanWithID:@( 2 ) infoData:nil success:NULL failure:NULL];
}

- (void)onPatrolOneAnswer:(__unused id)sender {
    /*
     {
         "mobileId": "abcde002",
         "patrolQuestion": 2,
         "score": 0,
         "content": "",
         "details": [
                 {
                     "mobileId": "abcdefg003",
                     "answer": 0,
                     "seq": 1,
                     "intResult": 0,
                     "stringResult": "test result"
                 }
             ]
         }
     }

     */
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doAnswerOnePatrolResultWithID:@( 1 ) infoData:nil success:NULL failure:NULL];
}

#pragma mark - Task
- (void)onTaskQuery:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doGetTaskListFromUpdateTime:nil position:0 size:20 success:NULL failure:NULL];
}

- (void)onNewTask:(__unused id)sender {
    /*
     {
         "title": "a",
         "mobileId": "adfe",
         "content": "b",
         "relatedStore": 1,
         "post": 1,
         "requireDate": null,
         "assignToMe": false,
         "questionAnswer": null,
         "state": "finished",
         "result": "finished",
         "processorddate": "2015-01-20 16:48:27"
     }
     */
    NSDictionary *dict =
    @{ @"title" : @"a",
       @"mobileId" : @"adfe",
       @"content" : @"b",
       @"relatedStore" : @( 1 ),
       @"post" : @( 1 ),
       @"requireDate": @"2015-01-20 16:48:27",
       @"assignToMe" : @( YES ),
       @"questionAnswer" : @"2333",
       @"state" : @"finished",
       @"result" : @"finished",
       @"processorddate" : @"2015-01-20 16:48:27"
      
      };
    
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doCreateNewTaskWithInfo:dict success:NULL failure:NULL];
}

- (void)onTaskResult:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doUpdateTaskResultID:@"201501130001" resultText:@"2333" processDate:[[NSDate date] timeIntervalSince1970] success:NULL failure:NULL];
}

#pragma mark - Signup
- (void)onSignup:(__unused id)sender {
    /*
     {
         "mobileId":"12345",
         "signupTime":"2014-12-27 16:04:35",
         "store":1,
         "signType":"in",
         "longitude":"192.113",
         "latitude":"239.12"
     }
     */
    
    NSDictionary *dict =
    @{ @"mobileId" : @"12345",
       @"signupTime" : @"2014-12-27 16:04:35",
       @"store" : @( 1 ),
       @"signType" : @"in",
       @"longitude" : @"192.113",
       @"latitude" : @"239.12",
      };
    
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doSignupWithInfo:dict success:NULL failure:NULL];
}

#pragma mark - Attachment
- (void)onAddAttachment:(__unused id)sender {
    /*
     {
         "type": "task",
         "objectId": "201501130001",
         "filename": "autorun.inf",
         "content":"W2F1dG9ydW5dDQpvcGVuPUF1dG9ydW4uZXhlDQppY29uPUF1dG9SdW4uaWNvDQo=",
         "seq":1,
         "attachmentType": "ask"
     }
     */
    
//    NSDictionary *dict =
//    @{ @"type" : @"task",
//       @"objectId" : @"201501130001",
//       @"filename" : @"autorun.inf",
//       @"content" : @"W2F1dG9ydW5dDQpvcGVuPUF1dG9ydW4uZXhlDQppY29uPUF1dG9SdW4uaWNvDQo=",
//       @"seq" : @( 1 ),
//       @"attachmentType" : @"ask"
//      
//      };
    /**
     ** 第一次上传附件时修改，以后遇到再修改
     */
    
    ICRPostAttachment *attE = [[ICRPostAttachment alloc] init];
//    attE.type = @"task";
//    attE.objectId = @"201501130001";
//    attE.filename = @"name";
//    attE.content = @"W2F1dG9ydW5dDQpvcGVuPUF1dG9ydW4uZXhlDQppY29uPUF1dG9SdW4uaWNvDQo=";
//    attE.seq = @(1);
//    attE.attachmentType = @"ask";
    
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doAddAttachment:[attE dictForCommit] success:NULL failure:NULL];
}

- (void)onListAttachment:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doGetAttachmentListWithType:kAttachmentTask objID:@"201501130001" success:NULL failure:NULL];
}

- (void)onAddDirectAttachment:(__unused id)sender {
//    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
//    [httpCtrl doAddDirectAttachment:<#(id)#> success:<#^(id)succ#> failure:<#^(id)fail#>]
}

- (void)onDownloadDirectAttachment:(__unused id)sender {
//    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
}

#pragma mark - Version
- (void)onFetchVersion:(__unused id)sender {
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doFetchVersionWithCurrent:IBT_APP_VERSION_STR success:NULL failure:NULL];
}

@end
