//
//  IBTTableView.m
//  IBTTableViewKit
//
//  Created by Xummer on 15/1/5.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "IBTTableView.h"
#import "IBTInputViewHandleDelegate.h"

@implementation IBTTableView

- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    [super touchesBegan:touches withEvent:event];
    if (_bHandleKeyboard) {
        if ([self.m_inputHandleDelegate respondsToSelector:@selector(handleInputView:)]) {
            [self.m_inputHandleDelegate handleInputView:self];
        }
        else {
            [self.window endEditing:YES];
        }
    }
}

- (void)setContentInsetTop:(CGFloat)top andBottom:(CGFloat)bottom {
    self.contentInset = UIEdgeInsetsMake(top, 0, bottom, 0);
    self.scrollIndicatorInsets = self.contentInset;
}

@end

@implementation IBTTableView (TableHeaderFooter)

- (IBTUIView *)groupedSectionHeaderWithTitle:(NSString *)title {
    CGRect frame = self.bounds;
    frame.size.height = IBT_GROUP_SECTION_HEIGHT;
    IBTUIView *view = [[IBTUIView alloc] initWithFrame:frame];
    view.backgroundColor = [UIColor clearColor];
    
    frame = CGRectInset(view.bounds, IBT_GROUP_CELL_LEFT_PADDING, 0);
    UILabel *tLabel = [[UILabel alloc] initWithFrame:frame];
    tLabel.textAlignment = NSTextAlignmentLeft;
    tLabel.font = [UIFont systemFontOfSize:16];
    tLabel.textColor = [UIColor colorWithRed:122/255.0f green:122/255.0f blue:123/255.0f alpha:1];
    tLabel.text = title;
    [view addSubview:tLabel];
    
    return view;
}

+ (IBTUIView *)headerWithTitle:(NSString *)title
                       topGap:(CGFloat)fTopGap
               containerWidth:(CGFloat)fWidth
{
    UILabel *tLabel = [[UILabel alloc] init];
    tLabel.textAlignment = NSTextAlignmentCenter;
    tLabel.font = [UIFont systemFontOfSize:16];
    tLabel.textColor = [UIColor colorWithRed:122/255.0f green:122/255.0f blue:123/255.0f alpha:1];
    tLabel.text = title;
    tLabel.numberOfLines = 0;
    
    CGRect rect = CGRectMake(0, 0, fWidth, 0);
    rect.size.height = [UILabel getHeightWithText:title font:tLabel.font andWidth:fWidth] + fTopGap * 2;
    IBTUIView *view = [[IBTUIView alloc] initWithFrame:rect];
    view.backgroundColor = [UIColor clearColor];
    
    rect = CGRectInset(view.bounds, IBT_GROUP_CELL_LEFT_PADDING, fTopGap);
    
    tLabel.frame = rect;
    
    [view addSubview:tLabel];
    
    return view;
}

- (IBTUIView *)buttonViewWithTitle:(NSString *)title
                             color:(UIColor *)color
                            topGap:(CGFloat)topGap
                           pointer:(UIButton * __autoreleasing *)buttonPointer
                            target:(id)target
                            action:(SEL)selector
{
    return [IBTCustomButtom buttonViewWithTitle:title
                                          color:color
                                         topGap:topGap
                                 containerWidth:CGRectGetWidth(self.bounds)
                                        pointer:buttonPointer
                                         target:target
                                         action:selector];
}

@end