//
//  AddProductViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/27.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "AddProductViewController.h"
#import "SurveyCell.h"
#import "ChooseProductViewController.h"
#import "ChooseTypeViewController.h"

#define LeftMargin 15
#define BtnHeight 44
#define TableHeight 46
#define TopHeight 50
#define TotalHeight 508
#define KeyboardHeight 258


typedef enum : NSUInteger {
    DelTag = 9000,
    CommitTag,
    DissTag
} BtnTag;

@interface AddProductViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate,HPGrowingTextViewDelegate>
{
    UIView *_bgView;
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    CGRect _tableFrame;
}

@end

@implementation AddProductViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initData];
    [self bulidLayout];
}
- (void)initData{
    _dataArr = [NSMutableArray array];
    [_dataArr addObject:@"商品"];
    [_dataArr addObject:@"包装单位"];
    [_dataArr addObject:@"包装规格"];
    [_dataArr addObject:@"包装数量"];
    [_dataArr addObject:@"基础数量"];
    [_dataArr addObject:@"基础单价"];
    [_dataArr addObject:@"包装单价"];
    [_dataArr addObject:@"总金额"];
    [_dataArr addObject:@"备注"];
}
- (void)setViewFrame:(CGRect)viewFrame{
    _tableFrame = viewFrame;
}
- (void)bulidLayout{
    _bgView = [[UIView alloc]initWithFrame:CGRectMake(LeftMargin, (self.view.frame.size.height - TotalHeight)/2, self.view.frame.size.width - LeftMargin*2, TotalHeight)];
    _bgView.layer.cornerRadius = 5;
    _bgView.layer.masksToBounds = YES;
    [self.view addSubview:_bgView];
    
    UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(0, 0,CGRectGetWidth(_bgView.frame), TopHeight)];
    label.text = @"新增商品明细";
    label.textAlignment = NSTextAlignmentCenter;
    label.backgroundColor = XXFBgColor;
    label.textColor = GXF_CONTENT_COLOR;
    label.font = GXF_FIFTEENTEN_SIZE;
    [_bgView addSubview:label];
    
    UIButton *dissBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetWidth(_bgView.frame) - TopHeight, 0, TopHeight, TopHeight) target:self sel:@selector(btnClick:) tag:DissTag image:nil title:@"关闭" titleColor:GXF_CONTENT_COLOR isCorner:NO corner:0 bgColor:nil];
    dissBtn.titleLabel.font = GXF_FIFTEENTEN_SIZE;
    [_bgView addSubview:dissBtn];
    
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopHeight,CGRectGetWidth(_bgView.frame), CGRectGetHeight(_bgView.frame)-TopHeight)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 50)];
    
    UIButton *delBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 10, (CGRectGetWidth(_bgView.frame) - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:6001 image:nil title:@"删除" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_SAVE_COLOR];
    [footView addSubview:delBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(delBtn.frame.origin.x + delBtn.frame.size.width + LeftMargin, 10, (CGRectGetWidth(_bgView.frame) - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:1001 image:nil title:@"提交" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_COMMIT_COLOR];
    [footView addSubview:commitBtn];
    
    //    [self.view addSubview:footView];
    _tableView.tableFooterView = footView;
    [_bgView addSubview:_tableView];
}
- (void)btnClick:(UIButton *)btn{
    switch (btn.tag) {
        case DissTag:
        {
            if ([self.delegate respondsToSelector:@selector(dissmiss)]) {
                [self.delegate dissmiss];
            }
        }
            break;
            
        default:
            break;
    }
}


#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row ==0 || indexPath.row == 1) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}
-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0 || indexPath.row == 1 ) {
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, CGRectGetWidth(_bgView.frame) - 100 - LeftMargin*2-10, TableHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_PLACEHOLDER_COLOR;
        contentLabel.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:contentLabel];
        if (indexPath.row == 0) {
            contentLabel.text = @"选择商品";
            self.productNameLabel = contentLabel;
            
        }else if(indexPath.row == 1){
            contentLabel.text = @"选择包装单位";
            self.productTypeLabel = contentLabel;
            
        }
    }else if (indexPath.row == _dataArr.count -1){
        self.remarkTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(100+LeftMargin, 0,  CGRectGetWidth(_bgView.frame) - 100 - LeftMargin*2-10, TableHeight)];
        self.remarkTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        self.remarkTextView.minNumberOfLines = 1;
        self.remarkTextView.maxNumberOfLines = 2;
        self.remarkTextView.font = GXF_FIFTEENTEN_SIZE;
        self.remarkTextView.textAlignment = NSTextAlignmentRight;
        self.remarkTextView.delegate = self;
        self.remarkTextView.returnKeyType = UIReturnKeyDone;
        self.remarkTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:self.remarkTextView];
    }else{
        
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0,  CGRectGetWidth(_bgView.frame) - 100 - LeftMargin*2-30, TableHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = GXF_CONTENT_COLOR;
        textField.font = GXF_FIFTEENTEN_SIZE;
        textField.keyboardType = UIKeyboardTypeNumbersAndPunctuation;
        textField.returnKeyType = UIReturnKeyDone;
        textField.delegate = self;
        [cell.contentView addSubview:textField];
        UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(textField.frame) + 5, 0, 20, TableHeight)];
        label.textColor = GXF_CONTENT_COLOR;
        label.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:label];
        if (indexPath.row == 2) {
            label.text = @"斤";
            textField.placeholder = @"包装规格";
            self.productStandFiled = textField;
        }else if (indexPath.row == 3) {
            label.text = @"框";
            textField.placeholder = @"包装数量";
            self.productCountFiled = textField;

        }else if (indexPath.row == 4) {
            label.text = @"斤";
            textField.placeholder = @"基础数量";
            self.baseCountFiled = textField;
            
        }else if (indexPath.row == 5) {
            label.text = @"元";
            textField.placeholder = @"基础单价";

            self.basePriceFiled = textField;
        }else if (indexPath.row == 6) {
            label.text = @"元";
            textField.placeholder = @"包装单价";
            self.productPriceFiled = textField;
        }else if (indexPath.row == 7) {
            label.text = @"元";
            textField.placeholder = @"总金额";
            self.totalPriceFiled = textField;
        }
    }
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if(indexPath.row == 0){
        ChooseProductViewController *cvc = [ChooseProductViewController new];
        cvc.choseProduct = ^(Product *product){
            self.productNameLabel.text = [NSString stringWithFormat:@"%@[%@]",product.name,product.code];
            self.productNameLabel.textColor = GXF_CONTENT_COLOR;
        };
        cvc.isMoreChose = NO;
        [self.delegate pushViewController:cvc];
    }else if (indexPath.row == 1){
        ChooseTypeViewController *tvc = [[ChooseTypeViewController alloc]init];
        tvc.title = @"类型";
        tvc.dataArr = @[@"筐",@"斤"];
        tvc.choseType = ^(NSString *type){
            self.productTypeLabel.text = type;
            self.productTypeLabel.textColor = GXF_CONTENT_COLOR;
        };
        [self.delegate pushViewController:tvc];
    }
}




#pragma mark delegate
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [self.remarkTextView resignFirstResponder];
    [self setTableFrame:TopHeight];
    return YES;
}
- (void)growingTextViewDidBeginEditing:(HPGrowingTextView *)growingTextView{
    CGFloat offset = ScreenSize.height - TotalHeight - KeyboardHeight;
    if (offset < 0) {//上移
        [self setTableFrame:TopHeight+offset];
    }
}
- (void)setTableFrame:(CGFloat)tabelH{
    [UIView animateWithDuration:0.25 animations:^{
        CGRect tableFrame = _tableView.frame;
        tableFrame.origin.y = tabelH;
        _tableView.frame = tableFrame;
    }];
}
- (void)textFieldDidBeginEditing:(UITextField *)textField{
    if (textField == self.basePriceFiled || textField == self.productPriceFiled || textField == self.totalPriceFiled) {
        CGFloat offset = ScreenSize.height - TotalHeight - KeyboardHeight;
        if (offset < 0) {//上移
            [self setTableFrame:TopHeight+offset];
        }
    }
}

- (void)keyboardHidden{
    [self.productStandFiled resignFirstResponder];
    [self.productPriceFiled resignFirstResponder];
    [self.productCountFiled resignFirstResponder];
    [self.basePriceFiled resignFirstResponder];
    [self.baseCountFiled resignFirstResponder];
    [self.totalPriceFiled resignFirstResponder];
    [self setTableFrame:TopHeight];

}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
