//
//  NewPurchaseViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/21.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NewPurchaseViewController.h"
#import "TopPurchaseView.h"
#import "ProductViewController.h"
#import "AddProductViewController.h"
#import "PurchaseBillProduct.h"
#define TopHeight 328
#define BottomHeight 300
#define SpaceHeight 20
#define BottomViewHeight 60

typedef enum : NSUInteger {
    SaveTag = 8000,
    CommitTag,
} BtnTag;

@interface NewPurchaseViewController ()<TopPurchaseViewDelegate,ProductViewDelegate>
{
    UIScrollView *_scrollView;
    TopPurchaseView *_purchaseView;
    UIView *_bottomView;
    ProductViewController *_pvc ;
    AddProductViewController *_avc;
}

@property (nonatomic,strong)NSNumber *total;
@property (nonatomic,strong)NSNumber *charge;
@property (nonatomic,strong)NSString *remark;
@property (nonatomic,strong)NSString *state;

@end

@implementation NewPurchaseViewController

- (instancetype)init{
    self = [super init];
    if (self) {
        //监听值的改变
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(setProductTotalPrice:) name:SetProductTotalPrice object:nil];
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    //布局
    [self bulidLayout];
}


#pragma mark - 布局
- (void)bulidLayout
{
    self.view.backgroundColor  = XXFBgColor;
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0,0, ScreenSize.width, ScreenSize.height- 64 - BottomViewHeight )];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, TopHeight+ BottomHeight + SpaceHeight*2);
    [self.view addSubview:_scrollView];
    
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, ScreenSize.height - BottomViewHeight - 64, ScreenSize.width, BottomViewHeight)];
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_SAVE_COLOR];
    [footView addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetMaxX(saveBtn.frame) + 15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:CommitTag image:nil title:@"提交" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_COMMIT_COLOR];
    [footView addSubview:commitBtn];
    
    [self.view addSubview:footView];

    _purchaseView = [[TopPurchaseView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, TopHeight)];
    _purchaseView.delegate = self;
    [_scrollView addSubview:_purchaseView];
    
    _bottomView = [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_purchaseView.frame) + 20, ScreenSize.width,BottomHeight)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
    
    _pvc = [[ProductViewController alloc]init];
    _pvc.delegate = self;
    _pvc.viewFrame = _bottomView.bounds;
    [_bottomView addSubview:_pvc.view];
    
}

- (void)setProductTotalPrice:(NSNotification *)fication{
    //计算总金额
    //其他费用 + 商品总金额
    float otherPrice = [_purchaseView.otherPriceFiled.text floatValue];
    NSMutableArray *purchaseProduct = _pvc.productArr;
    float totalPrice = 0;
    for (PurchaseBillProduct *billProduct in purchaseProduct) {
        totalPrice += [billProduct.total floatValue];
    }
    _purchaseView.purchasePriceLabel.text = [NSString stringWithFormat:@"%.2f",totalPrice + otherPrice];
    self.charge = [NSNumber numberWithFloat:otherPrice];
    self.total = [NSNumber numberWithFloat:totalPrice];
}

- (void)btnClick:(UIButton *)btn{
    switch (btn.tag) {
        case SaveTag:
        {
            if ([self checkPurchase]) {
                
            }
        }
            break;
        case CommitTag:{
        
        }
            break;
        default:
            break;
    }
}

#pragma mark - checkNull
- (BOOL)checkPurchase{
    self.remark = _purchaseView.remarkTextView.text;
    if (_purchaseView.vendor_uuid.length == 0 || _purchaseView.receiveWrh_uuid.length == 0 || _purchaseView.type.length == 0 || [self.total floatValue] < 0 || !self.total) {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"提示信息" message:@"信息不完整" delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
        [alert show];
        return NO;
    }
    return YES;
}


#pragma mark - TopPurchaseViewDelegate

- (void)pushNextViewController:(id)vc{
    [self PushViewController:vc animated:YES];
}

#pragma mark - ProductViewDelegate
- (void)pushViewController:(id)cvc selfController:(id)avc{
    _avc = avc;
    [self PushViewController:cvc animated:YES];
}
- (void)viewWillAppear:(BOOL)animated{
    [super viewWillAppear:animated];
    if (_avc) {
        [AppWindow addSubview:_avc.view];
    }
}

#pragma mark - 协议方法
- (void)hiddenKeyBoard{
    [self keyboardHidden];
}
- (void)keyboardHidden{
    [_purchaseView.otherPriceFiled resignFirstResponder];
    [_purchaseView.remarkTextView resignFirstResponder];
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
