//
//  TopPurchaseView.m
//  XFFruit
//
//  Created by n22 on 15/8/21.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TopPurchaseView.h"

#import "SurveyCell.h"
#import "ChooseVendorViewController.h"
#import "ChooseTypeViewController.h"
#import "ChooseWarehouseViewController.h"
#import "Vendor.h"
#define LeftMargin 15
#define TopMargin 20
#define LeftWidth 80
#define TableHeight 44
#define SpaceHeight 10
#define TitleSize 15

@interface TopPurchaseView ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
}
@end


@implementation TopPurchaseView
- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        //界面
        [self bulidLayout];
    }
    return self;
}

#pragma mark - 布局
- (void)bulidLayout
{
    self.backgroundColor  = XXFBgColor;
    _dataArr = [NSMutableArray array];
    NSArray *arr = @[@"采购通知:",@"类型:",@"供应商:",@"收货仓库:",@"其他费用:",@"总金额:",@"备注:"];
    [_dataArr addObjectsFromArray:arr];
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,self.frame.size.width, self.frame.size.height - TopMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [self addSubview:_tableView];
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row > 0 && indexPath.row < 4) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}
-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 4 ) {
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-30, TableHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = GXF_CONTENT_COLOR;
        textField.font = GXF_FIFTEENTEN_SIZE;
        textField.keyboardType = UIKeyboardTypeNumbersAndPunctuation;
        textField.returnKeyType = UIReturnKeyDone;
        textField.delegate = self;
        [cell.contentView addSubview:textField];
        self.otherPriceFiled = textField;
        self.otherPriceFiled.placeholder = @"请输入其他费用";
        UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(textField.frame) + 5, 0, 20, TableHeight)];
        label.text = @"元";
        label.textColor = GXF_CONTENT_COLOR;
        label.font = FontSize(TitleSize);
        [cell.contentView addSubview:label];
        
    }else if (indexPath.row == _dataArr.count -1){
        self.remarkTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableHeight)];
        self.remarkTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        self.remarkTextView.minNumberOfLines = 1;
        self.remarkTextView.maxNumberOfLines = 2;
        self.remarkTextView.font = GXF_FIFTEENTEN_SIZE;
        self.remarkTextView.textAlignment = NSTextAlignmentRight;
        self.remarkTextView.delegate = self;
        self.remarkTextView.returnKeyType = UIReturnKeyDone;
        self.remarkTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:self.remarkTextView];
    }else{
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_PLACEHOLDER_COLOR;
        contentLabel.font = FontSize(TitleSize);
        [cell.contentView addSubview:contentLabel];
        if (indexPath.row == 0) {
            contentLabel.text = @"采购通知单号";
            self.purchaseNoticeLabel = contentLabel;
            
        }else if(indexPath.row == 1){
            contentLabel.text = @"选择类型";
            self.purchaseTypeLabel = contentLabel;
            
        }else if(indexPath.row == 2){
            contentLabel.text = @"选择供应商";
            self.purchaseSupplierLabel = contentLabel;
            
        }else if(indexPath.row == 3){
            contentLabel.text = @"选择收货仓库";
            self.purchaseStoreLabel = contentLabel;
        }else if(indexPath.row == 5){
            contentLabel.text = @"0";
            contentLabel.frame = CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-30, TableHeight);
            contentLabel.textColor = [UIColor redColor];
            self.purchasePriceLabel = contentLabel;
            UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(contentLabel.frame)+ 5, 0, 20, TableHeight)];
            label.text = @"元";
            label.textColor = GXF_CONTENT_COLOR;
            label.font = FontSize(TitleSize);
            [cell.contentView addSubview:label];

        }
    }
}
-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if(indexPath.row == 2){
        ChooseVendorViewController *cvc = [ChooseVendorViewController new];
        cvc.title = @"供应商";
        cvc.choseVendor = ^(NSArray *vendors){
            if (vendors.count > 0) {
                Vendor *vendor = vendors[0];
                self.purchaseSupplierLabel.text = [NSString stringWithFormat:@"%@[%@]",vendor.name,vendor.code];
                self.purchaseSupplierLabel.textColor = GXF_CONTENT_COLOR;
                self.vendor_uuid = vendor.uuid;
                self.vendor_code = vendor.code;
                self.vendor_name = vendor.name;
            }
            
        };
        cvc.isMoreChose = NO;
        [self.delegate pushNextViewController:cvc];
    }else if(indexPath.row == 1){
        ChooseTypeViewController *tvc = [[ChooseTypeViewController alloc]init];
        tvc.title = @"类型";
        tvc.dataArr = @[@"普通",@"紧急"];
        tvc.choseType = ^(NSString *type){
            self.purchaseTypeLabel.text = type;
            self.purchaseTypeLabel.textColor = GXF_CONTENT_COLOR;
            self.type = type;
        };
        [self.delegate pushNextViewController:tvc];
    }else if(indexPath.row == 3){
        ChooseWarehouseViewController *wvc = [[ChooseWarehouseViewController alloc]init];
        wvc.title = @"仓库";
        wvc.choseWarehouse = ^(Warehouse *warehouse){
            self.purchaseStoreLabel.text = [NSString stringWithFormat:@"%@[%@]",warehouse.name,warehouse.code];
            self.purchaseStoreLabel.textColor = GXF_CONTENT_COLOR;
            self.receiveWrh_uuid = warehouse.uuid;
            self.receiveWrh_code = warehouse.code;
            self.receiveWrh_name = warehouse.name;
        };
        [self.delegate pushNextViewController:wvc];
    }
}
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [self.remarkTextView resignFirstResponder];
    return YES;
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self.delegate hiddenKeyBoard];
    return YES;
}
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event{
    [self.delegate hiddenKeyBoard];
}
- (void)textFieldDidEndEditing:(UITextField *)textField{
    if (textField == self.otherPriceFiled) {
        if (self.otherPriceFiled.text.length > 0) {
            [[NSNotificationCenter defaultCenter] postNotificationName:SetProductTotalPrice object:nil];
        }
    }
}



@end
