//
//  ResultView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/11.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ResultView.h"
#import "TPCustomImageVIew.h"
#import "UIImageView+WebCache.h"
#import "SingleScrollView.h"
#import "Attachment.h"
#define TPSamleVT_Top_Height 10
#define Back_Btn_Width 37
#define Back_Btn_Height 36
@interface  ResultView()<UIScrollViewDelegate,UIGestureRecognizerDelegate>
{
    NSMutableArray *_imagesArray;
    UIScrollView *_scrollView;
}

@end

@implementation ResultView

- (id)initWithFrame:(CGRect)frame{
    if (self = [super initWithFrame:frame]) {
        _imagesArray = [NSMutableArray new];
        
        _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, TPSamleVT_Top_Height, self.frame.size.width, self.frame.size.height-TPSamleVT_Top_Height*2)];
        _scrollView.delegate = self;
        _scrollView.showsHorizontalScrollIndicator  = NO;
        _scrollView.showsVerticalScrollIndicator = NO;
        _scrollView.pagingEnabled = YES;
        [self addSubview:_scrollView];
    }
    return self;
}

- (void)setScrollView{
    [self setImagesArray];
    _scrollView.contentSize = CGSizeMake(_scrollView.frame.size.width * _imagesArray.count ,_scrollView.frame.size.height);
    _scrollView.contentOffset = CGPointMake(_scrollView.frame.size.width*(self.index+1), 0);
    _scrollView.alpha = 0;
    [UIView animateWithDuration:1 animations:^{
        _scrollView.alpha = 1;
    }];
    [self createImageButton];
    
}


//创建滚动视图上的图片按钮
- (void)createImageButton{
    for (NSInteger i = 0; i < _imagesArray.count; i++) {
        SingleScrollView *customView = [[SingleScrollView alloc] initWithFrame: CGRectMake(_scrollView.frame.size.width*(i),0 , self.frame.size.width, _scrollView.frame.size.height) image:_imagesArray[i]];
        [customView addSingleClickTarget:self action:@selector(imageViewHide)];
        customView.delegate = self;
        [_scrollView addSubview:customView];
    }
}

//为图片数组赋值
- (void)setImagesArray{
    [_imagesArray removeAllObjects];
    if (self.images.count >0) {
        Attachment *att =[self.images lastObject];
        [_imagesArray addObject:att.content];
        for (Attachment *typeBo in self.images) {
            [_imagesArray addObject:typeBo.content];
        }
        Attachment *endTypeBo = self.images[0];
        [_imagesArray addObject:endTypeBo.content];
    }else{
        [_imagesArray addObject:@"HomeDisplayImage"];
        [_imagesArray addObject:@"HomeDisplayImage"];
        [_imagesArray addObject:@"HomeDisplayImage"];
    }
    
}
#pragma mark - scrollView协议的方法
- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView
{
    float offsetX=_scrollView.contentOffset.x;
    if (offsetX/_scrollView.frame.size.width==0) {
        _scrollView.contentOffset=CGPointMake(scrollView.frame.size.width*(_imagesArray.count-2), 0);
        
    }else if (offsetX/scrollView.frame.size.width==_imagesArray.count-1) {
        _scrollView.contentOffset=CGPointMake(scrollView.frame.size.width*1, 0);
        
    }
    if (![scrollView isKindOfClass:[SingleScrollView class]]) {
        for (SingleScrollView *sv in scrollView.subviews) {
            //如果 自定义的滚动视图 有放大 那么在滚动下方的滚动视图减速停止的时候 还原自定义滚动视图的大小
            sv.zoomScale = 1;
        }
    }
    
}
#pragma mark - 手势触发
- (UIView *)viewForZoomingInScrollView:(UIScrollView *)scrollView{
    if ([scrollView isKindOfClass:[SingleScrollView class]]) {
        return scrollView.subviews[0];
    }
    return nil;
}
#pragma mark - 按钮触发事件
- (void)imageViewHide
{
    [self.delegate clickBackButton];
}
@end
