//
//  ChosePersonViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChosePersonViewController.h"
#import "SurveyUser.h"
#import "User.h"

@interface ChosePersonViewController (){
    NSIndexPath *_currentIndexPath;
}

@end

@implementation ChosePersonViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.tableView.header.lastUpdatedTimeKey = ChoosePersonUpdateDate;
    self.title = @"选择人员";
    [self fetchUserList:@""];
}

- (void)getBaseDataFromLocal{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf endRefreshing];
        [strongSelf fetchUserList:@""];
    };
    
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getUserWithPage_number:0 page_size:100 success:succ failure:fail];
}
#pragma mark -成功
- (void)fetchUserList:(NSString *)titleStr{
    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
        NSString * sql = @"";
        if (titleStr.length > 0) {
            sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE NAME LIKE '%%%@%%' ORDER BY %@", [User TableName],titleStr, @"uuid"];
        }else{
            sql = [NSString stringWithFormat:@"SELECT * FROM %@ ORDER BY %@", [User TableName], @"uuid"];
        }
        return [db executeQuery:sql];
    };
    
    __weak typeof(self)weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (![GXF_NSUSERFEFTAULTS objectForKey:ChoosePersonUpdateDate]) {
            [GXF_NSUSERFEFTAULTS setObject:[NSDate date] forKey:ChoosePersonUpdateDate];
            [GXF_NSUSERFEFTAULTS synchronize];
            [self getBaseDataFromLocal];
        }else{
            [strongSelf.dataArr removeAllObjects];
            [strongSelf.dataArr addObject:self.tableView.header.lastUpdatedTime];
            [strongSelf.dataArr addObjectsFromArray:fetchedObjects];
            [self tableViewRefresh];
        }
    };
    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
    [dbCtrl runFetchForClass:[User class]
                  fetchBlock:fetchBlk
           fetchResultsBlock:fetchResultsBlk];
}
- (void)sureClick{
    if (self.isMoreChose) {
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        for (NSIndexPath *index in self.indexArr) {
            User *user = self.dataArr[index.row];
            SurveyUser * survey = [[SurveyUser alloc]init];
            survey.userUuid = user.uuid;
            survey.userCode = user.login;
            survey.userName = user.name;
            [arr addObject:survey];
        }
        self.chosePerson(arr);
    }else{
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        if (self.dataArr.count > 0) {
            if (_currentIndexPath) {
                User *user = self.dataArr[_currentIndexPath.row];
                SurveyUser * survey = [[SurveyUser alloc]init];
                survey.userUuid = user.uuid;
                survey.userCode = user.login;
                survey.userName = user.name;
                [arr addObject:survey];
                self.chosePerson(arr);
            }
        }
    }
    [self PopViewControllerAnimated:YES];
}

#pragma mark - 协议方法
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    if (self.isMoreChose) {
        if ([self isHaveIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }else{
        if (_currentIndexPath) {
            if (indexPath.row == _currentIndexPath.row) {
                cell.Commitbtn.hidden = NO;
            }else{
                cell.Commitbtn.hidden = YES;
            }
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    if (self.dataArr.count > 0) {
        if (indexPath.row == 0) {
            NSString *dateStr = [self.dataArr[indexPath.row] httpParameterString];
            cell.titleLabel.textColor = GXF_CONTENT_COLOR;
            [cell setTitleStr:[NSString stringWithFormat:@"上次更新时间:%@",dateStr]];
        }else{
            User *user =  self.dataArr[indexPath.row];
            [cell setTitleStr:user.name];
        }

    }
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0) {
        return;
    }
    if (self.isMoreChose == YES) {
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        if (![self isHaveIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
            [self.indexArr addObject:indexPath];
        }else{
            cell.Commitbtn.hidden = YES;
            [self.indexArr removeObject:indexPath];
        }
    }else{
        MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
        currentCell.Commitbtn.hidden = YES;
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        _currentIndexPath = indexPath;
    }
}
- (void)deleteTextFieldStr{
    [super deleteTextFieldStr];
    [self boxValueChanged:nil];
}
#pragma mark - 按钮事件
- (void)boxValueChanged:(NSNotification *)fication{
    NSString *tilkeStr = [IBTCommon trimmingCharacters:self.selectTextFiled.text];
    [self fetchUserList:tilkeStr];
}
- (void)tableViewRefresh{
    _currentIndexPath = nil;
    if (self.indexArr.count > 0) {
        [self.indexArr removeAllObjects];
    }
    [self.tableView reloadData];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

@end
