//
//  MaterialVIewController.m
//  XFFruit
//
//  Created by n22 on 15/8/19.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "MaterialVIewController.h"
#import "HeaderCell.h"
#import "FooterCell.h"
#import "MaterialCell.h"
#define TableHeight 44


@interface MaterialVIewController ()<UITableViewDataSource,UITableViewDelegate,FooterCellDelegate>
{
    CGRect _tableFrame;
    NSInteger _currentRow;
    BOOL isFirst;
}
@end

@implementation MaterialVIewController


- (void)viewDidLoad {
    self.view.backgroundColor  = XXFBgColor;
    [super viewDidLoad];
    isFirst = YES;
    _meterialArr = [NSMutableArray array];
    [self createView];
}
- (void)setViewFrame:(CGRect)viewFrame{
    _tableFrame = viewFrame;
}
- (void)createView{
    self.tableView = [[UITableView alloc]initWithFrame:_tableFrame style:(UITableViewStylePlain)];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.view addSubview:self.tableView];
    
    NSArray *arr = @[@"原料",@"基础数量",@"入库时间"];
    
    HeaderCell *headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) withArr:arr];
    [self.view addSubview:headCell];
    self.tableView.tableHeaderView = headCell;
    
    FooterCell *footCell = [[FooterCell alloc]initWithFrame:CGRectMake(0, 0, _tableFrame.size.width, 50) withTitle:@"+点击添加原料明细"];
    [self.view addSubview:footCell];
    footCell.delegate = self;
    self.tableView.tableFooterView = footCell;
}

- (void)addClick{
    [self.meterialArr addObject:@"dddd"];
    [self.tableView reloadData];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.meterialArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaterialCell";
    MaterialCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaterialCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (indexPath.row != _currentRow) {
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = TableHeight-1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = 0;
        cell.showView.frame = showfrmame;
        cell.showView.hidden = YES;
        cell.backgroundColor = [UIColor whiteColor];
        
    }else if (indexPath.row == _currentRow && !isFirst)
    {
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = 200-1;
        cell.lineLabel.frame = Linefrmame;
        
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = 150;
        cell.showView.frame = showfrmame;
        cell.showView.hidden = NO;
        cell.backgroundColor = XXFBgColor;
    }

    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    MaterialCell *cell = (MaterialCell *)[tableView cellForRowAtIndexPath:indexPath];
    CGRect Linefrmame = cell.lineLabel.frame;
     CGRect showfrmame = cell.showView.frame;
    if (Linefrmame.origin.y == TableHeight - 1) {
        Linefrmame.origin.y = 200-1;
        showfrmame.size.height = 150;
        cell.showView.hidden = NO;
        isFirst = NO;
        cell.backgroundColor = [UIColor whiteColor];

    }else{
        isFirst = YES;
        Linefrmame.origin.y = TableHeight -1;
        showfrmame.size.height = 0;
        cell.showView.hidden = YES;
        cell.backgroundColor = [UIColor whiteColor];

    }
    cell.lineLabel.frame = Linefrmame;
    cell.showView.frame = showfrmame;
    _currentRow = indexPath.row;
    [self.tableView reloadData];
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == _currentRow && !isFirst) {
        return 200;
    }
    return TableHeight;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
