//
//  HeaderCell.m
//  XFFruit
//
//  Created by n22 on 15/8/19.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "HeaderCell.h"
#define LeftMargin 13
#define LeftWidth 45
#define RightWidth 30
#define SpaceMargin 1
@interface HeaderCell ()
@property (nonatomic,strong)NSArray *arr;
@property (nonatomic,strong)UILabel *lineLabel;

@end

@implementation HeaderCell

- (instancetype)initWithFrame:(CGRect)frame withArr:(NSArray *)arr{
    self = [super initWithFrame:frame];
    if (self) {
        self.arr = arr;
        [self bulidLayout];
    }
    return self;
}
- (void)bulidLayout{

    CGFloat headWidth = (ScreenSize.width - LeftWidth - LeftWidth - SpaceMargin* (self.arr.count -1))/self.arr.count;
    for (NSInteger i = 0; i < self.arr.count; i++) {
        UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(LeftWidth + (SpaceMargin + headWidth)*i, 0, headWidth, self.frame.size.height)];
        label.font = GXF_FIFTEENTEN_SIZE;
        label.textAlignment = NSTextAlignmentLeft;
        label.textColor = GXF_PLACEHOLDER_COLOR;
        label.text = self.arr[i];
        [self addSubview:label];
    }
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, self.frame.size.height-1, ScreenSize.width - LeftMargin * 2, 1))];
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    self.lineLabel.font = GXF_FIFTEENTEN_SIZE;
    [self addSubview:self.lineLabel];
}
@end
