//
//  Photo.m
//  PhotoDemo
//
//  Created by Harry on 12-12-6.
//  Copyright (c) 2012年 Harry. All rights reserved.
//

#import "HGPhoto.h"

#import <QuartzCore/QuartzCore.h>
#import "UIImageView+WebCache.h"
static CGRect oldframe;
@interface HGPhoto() <UIGestureRecognizerDelegate>

@property (strong, nonatomic) UIView *viewMask;
@property (strong, nonatomic) UIImageView *viewPhoto;
@property (strong, nonatomic) UIButton *delBtn;

@property (strong, nonatomic) NSString *stringImageUrl;
@property (nonatomic) CGPoint pointOrigin;
@property (nonatomic) BOOL editModel;

@property (nonatomic) PhotoType type;


@end

#define kPhotoSize 100. //75//

@implementation HGPhoto


- (id)initWithOrigin:(CGPoint)origin
{
    self = [super initWithFrame:CGRectMake(origin.x, origin.y, kPhotoSize, kPhotoSize)];
    if (self) {
        self.backgroundColor = [UIColor clearColor];
        
        self.viewPhoto = [[UIImageView alloc] initWithFrame:self.bounds];
        self.viewPhoto.layer.cornerRadius = 12;
        self.viewPhoto.layer.masksToBounds = YES;
        self.delBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_delBtn setBackgroundImage:[UIImage imageNamed:@"attachment_delete_btn"] forState:UIControlStateNormal];
        CGFloat btnX = _viewPhoto.frame.size.width * 0.7;
        CGFloat btnY = 0;
        CGFloat btnW = _viewPhoto.frame.size.width - btnX;
        _delBtn.frame = CGRectMake(btnX, btnY, btnW, btnW);
        [_delBtn addTarget:self action:@selector(delphoto) forControlEvents:UIControlEventTouchUpInside];
        [_viewPhoto addSubview:_delBtn];
       
        
   
        
        self.viewMask = [[UIView alloc] initWithFrame:self.bounds];
        self.viewMask.alpha = 0.6;
        self.viewMask.backgroundColor = [UIColor blackColor];
        self.viewMask.layer.cornerRadius = 11;
        self.viewMask.layer.masksToBounds = YES;
        
        UITapGestureRecognizer *tapRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tapPress:)];
        
        [self addSubview:self.viewPhoto];
        [self addSubview:self.viewMask];
        [self addGestureRecognizer:tapRecognizer];
        
        self.editModel = NO;
        self.viewMask.hidden = YES;
    }
    self.autoresizingMask = UIViewContentModeScaleAspectFill;
    //self.autoresizingMask = UIViewAutoresizingFlexibleWidth & UIViewAutoresizingFlexibleHeight;
    return self;
}
- (id)initWithOrigin:(CGPoint)origin andLength:(CGFloat)length {
    self =  [self initWithOrigin:origin];
    self.viewPhoto.size = CGSizeMake(length, length);
    self.size = CGSizeMake(length, length);
    return self;
    
}
- (void)setPhotoType:(PhotoType)type
{
    self.type = type;
    if (type == PhotoTypeAdd) {
        self.viewPhoto.image = [UIImage imageNamed:@"AttachCamera"];//@"addPhoto"];
         [_delBtn removeFromSuperview];
    }
}

- (PhotoType)getPhotoType
{
    return self.type;
}

- (void)setPhotoUrl:(NSString*)photoUrl
{
    [self.viewPhoto setImageWithURL:[NSURL URLWithString:photoUrl] placeholderImage:nil];
}
- (void)setPhotoImg:(UIImage *)img {
    [self.viewPhoto setImage:img];
}
- (void)moveToPosition:(CGPoint)point
{
    if (self.type == PhotoTypePhoto) {
        [UIView animateWithDuration:0.5 animations:^{
            self.frame = CGRectMake(point.x, point.y, self.frame.size.width, self.frame.size.height);
        } completion:nil];
    } else {
        self.frame = CGRectMake(point.x, point.y, self.frame.size.width, self.frame.size.height);
    }
}

- (void)setEditModel:(BOOL)edit
{
    if (self.type == PhotoTypePhoto) {
        if (edit) {
            UILongPressGestureRecognizer *longPressreRecognizer = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(handleLongPress:)];
            longPressreRecognizer.delegate = self;
            [self addGestureRecognizer:longPressreRecognizer];
        } else {
            for (UIGestureRecognizer *recognizer in [self gestureRecognizers]) {
                if ([recognizer isKindOfClass:[UILongPressGestureRecognizer class]]) {
                    [self removeGestureRecognizer:recognizer];
                    break;
                }
            }
        }
    }
}
#pragma btn action
- (void)delphoto {
    if ([self.delegate respondsToSelector:@selector(photoDel:)]) {
        [self.delegate photoDel:self];
    }
}

#pragma mark - UITapGestureRecognizer

- (void)tapPress: (UITapGestureRecognizer *)tap//(id)sender
{
    //根据点击的位置不同去响应事件
    CGMutablePathRef pathRef=CGPathCreateMutable();
    CGPathMoveToPoint(pathRef, NULL, _delBtn.frame.origin.x, _delBtn.frame.origin.y);
    CGPathAddLineToPoint(pathRef, NULL,  _delBtn.frame.origin.x, _delBtn.frame.origin.y);
    CGPathAddLineToPoint(pathRef, NULL, _delBtn.frame.origin.x + _delBtn.frame.size.width, _delBtn.frame.origin.y);
    CGPathAddLineToPoint(pathRef, NULL, _delBtn.frame.origin.x,_delBtn.frame.origin.y + _delBtn.frame.size.height );

    CGPathAddLineToPoint(pathRef, NULL, _delBtn.frame.origin.x + _delBtn.frame.size.width, _delBtn.frame.origin.y + _delBtn.frame.size.height);
    CGPathCloseSubpath(pathRef);
    
    CGPoint p = [tap locationInView:self];
    
    if (CGPathContainsPoint(pathRef, NULL, p, NO)) {
        NSLog(@"point in path!");
        if ([self.delegate respondsToSelector:@selector(photoDel:)]) {
            [self.delegate photoDel:self];
        }
    }
    else {
        NSLog(@"outPoint out path!");
        if ([self.delegate respondsToSelector:@selector(photoTaped:)]) {
        [self.delegate photoTaped:self];
        }
    }
}

- (void)handleLongPress:(id)sender
{
    UILongPressGestureRecognizer *recognizer = sender;
    CGPoint point = [recognizer locationInView:self];
    
    CGFloat diffx = 0.;
    CGFloat diffy = 0.;
    
    if (UIGestureRecognizerStateBegan == recognizer.state) {
        self.viewMask.hidden = NO;
        self.pointOrigin = point;
        [self.superview bringSubviewToFront:self];
    } else if (UIGestureRecognizerStateEnded == recognizer.state) {
        self.viewMask.hidden = YES;
        if ([self.delegate respondsToSelector:@selector(photoMoveFinished:)]) {
            [self.delegate photoMoveFinished:self];
        }
    } else {
        diffx = point.x - self.pointOrigin.x;
        diffy = point.y - self.pointOrigin.y;
    }
    
    CGFloat originx = self.frame.origin.x +diffx;
    CGFloat originy = self.frame.origin.y +diffy;
    
    self.frame = CGRectMake(originx, originy, self.frame.size.width, self.frame.size.height);
}


- (void)showImage {
    UIImage *image = _viewPhoto.image;
    UIWindow *window = [UIApplication sharedApplication].keyWindow;
    UIView *backgroundView = [[UIView alloc]init];
    backgroundView.frame = CGRectMake(0, 0, [UIScreen mainScreen].bounds.size.width, [UIScreen mainScreen].bounds.size.height);
    oldframe = [_viewPhoto convertRect:_viewPhoto.bounds toView:window ];
    backgroundView.backgroundColor=[UIColor blackColor];
    backgroundView.alpha = 0;
    UIImageView *imageView = [[UIImageView alloc]init];
    imageView.image = image;
    imageView.tag = 1;
    [backgroundView addSubview:imageView];
    [window addSubview:backgroundView];
    
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(hideImage:)];
    [backgroundView addGestureRecognizer:tap];
    
    [UIView animateWithDuration:0.3 animations:^{
        imageView.frame = CGRectMake(
                    0,
    ([UIScreen mainScreen].bounds.size.height-image.size.height*[UIScreen mainScreen].bounds.size.width/image.size.width)/2,
    [UIScreen mainScreen].bounds.size.width, image.size.height*[UIScreen mainScreen].bounds.size.width/image.size.width);
        backgroundView.alpha = 1;

    } completion:^(BOOL finished) {
        
    }];
    
}

- (void)hideImage : (UITapGestureRecognizer *)tap {
    UIView *backgroundView = tap.view;
    UIImageView *imageView = (UIImageView *)[tap.view viewWithTag:1];
    [UIView animateWithDuration:0.3 animations:^{
        imageView.frame = oldframe;
        backgroundView.alpha = 0;
    } completion:^(BOOL finished) {
        [backgroundView removeFromSuperview];
    }];
}
@end
