//
//  GXFTableViewCell.m
//  XFFruit
//
//  Created by freecui on 15/9/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "GXFTableViewCell.h"

@interface GXFTableViewCell ()
@end


@implementation GXFTableViewCell

//带有placeholder和label
- (instancetype)initWithStyle:(UITableViewCellStyle)style
              reuseIdentifier:(NSString *)reuseIdentifier
         textFieldPlaceholder:(NSString *)placeholder
                     hasLable:(BOOL)hasLbl
                backLableText:(NSString *)lblText {
    self = [self initWithStyle:style reuseIdentifier:reuseIdentifier textFieldPlaceholder:placeholder isEdit:YES];
    
    UILabel *lbl = [[UILabel alloc]initWithFrame:CGRectMake(self.width - 25, 0, 25, self.height)];
    lbl.textAlignment = NSTextAlignmentLeft;
    lbl.text = lblText;
    [self.contentView addSubview:lbl];
    
    return self;
    
}



//@"lblCell" :无箭头cellstyle为默认  :带有placeholder和label ,,没箭头可编辑

- (instancetype)initWithreuseIdentifier: (NSString *)reuseIdentifier
                   textFieldPlaceholder: (NSString *)placeholder
                             //  hasLable: (BOOL)hasLbl
                          backLableText: (NSString *)lblText {
    
    self = [self initWithStyle:UITableViewCellStyleDefault reuseIdentifier:reuseIdentifier textFieldPlaceholder:placeholder hasLable:YES backLableText:lblText];
    
    return self;

   
    return self;

}

#pragma 共同调用原始的初始化方法待有textfield
//带有placeholder分两张情况 :1),有箭头 2）没箭头可编辑
- (instancetype)initWithStyle:(UITableViewCellStyle)style
              reuseIdentifier:(NSString *)reuseIdentifier
         textFieldPlaceholder: (NSString *)placeholder
                       isEdit:(BOOL)isEdit {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (!self) {
        return nil;
    }
    
    UITextField *textF = [[UITextField alloc]initWithFrame:CGRectMake(self.width * 0.2, 0, self.width * 0.8 - 30, self.height)];
    textF.textAlignment = NSTextAlignmentRight;
    textF.placeholder = placeholder;
    textF.enabled = isEdit;
    
    
    self.f_textField = textF;
    [self.contentView addSubview:_f_textField];
    
    return self;
}

 //@"arrowCell"：带有placeholder :1),有箭头不可编辑
- (instancetype)initAccessorWithreuseIdentifier: (NSString *)reuseIdentifier
                           textFieldPlaceholder: (NSString *)placeholder {
    self = [self initWithStyle:UITableViewCellStyleDefault reuseIdentifier:reuseIdentifier textFieldPlaceholder:placeholder isEdit:NO];
    
    self.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    return self;

}
//// @"noLblCell" ：带有placeholder :2）没箭头可编辑

- (instancetype)initEditNoAccessorWithreuseIdentifier: (NSString *)reuseIdentifier
                                 textFieldPlaceholder: (NSString *)placeholder {
    self = [self initWithStyle:UITableViewCellStyleDefault reuseIdentifier:reuseIdentifier textFieldPlaceholder:placeholder isEdit:YES];
    
    return self;


}


// cell 一行中显示的内容
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier contentArray:(NSArray *)array {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (!self) {
        return nil;
    }
    [self p_setSubViews:array];
    return self;
}

- (void)p_setSubViews: (NSArray *)array{

    for (NSInteger i = 0; i < array.count; i++) {
        CGFloat lblW = self.width * 1.0 / 3.0;
        CGFloat lblX = lblW * i;
        
        UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(lblX,0,lblW,self.height)];
        label.font = FontSize(15);
        label.textAlignment = NSTextAlignmentCenter;
        label.textColor = HexColor(@"bbbbbb");
        label.text = array[i];
        [self.contentView addSubview:label];
    }

}


- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end



@implementation GXFTableViewCell (Frame)

//带有placeholder和label
- (instancetype)initWithWidth: (CGFloat)width
                        Style:(UITableViewCellStyle)style
              reuseIdentifier:(NSString *)reuseIdentifier
         textFieldPlaceholder:(NSString *)placeholder
                     hasLable:(BOOL)hasLbl
                backLableText:(NSString *)lblText {
    self = [self initWithWidth:width Style:style reuseIdentifier:reuseIdentifier textFieldPlaceholder:placeholder isEdit:YES];
    self.width = width;
    UILabel *lbl = [[UILabel alloc]initWithFrame:CGRectMake(self.width - 25, 0, 25, self.height)];
    lbl.textAlignment = NSTextAlignmentLeft;
    lbl.text = lblText;
    [self.contentView addSubview:lbl];
    
    return self;
    
}




#pragma 共同调用原始的初始化方法待有textfield
//带有placeholder分两张情况 :1),有箭头 2）没箭头可编辑
- (instancetype)initWithWidth: (CGFloat)width
                        Style:(UITableViewCellStyle)style
              reuseIdentifier:(NSString *)reuseIdentifier
         textFieldPlaceholder: (NSString *)placeholder
                       isEdit:(BOOL)isEdit {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (!self) {
        return nil;
    }
    self.width = width;
    UITextField *textF = [[UITextField alloc]initWithFrame:CGRectMake(self.width * 0.2, 0, self.width * 0.8 - 30, self.height)];
    textF.textAlignment = NSTextAlignmentRight;
    textF.placeholder = placeholder;
    textF.enabled = isEdit;
    
    
    self.f_textField = textF;
    [self.contentView addSubview:_f_textField];
    
    return self;
}


//// cell 一行中显示的内容
//- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier contentArray:(NSArray *)array {
//    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
//    if (!self) {
//        return nil;
//    }
//    [self p_setSubViews:array];
//    return self;
//}


@end
