//
//  ChooseStoreViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/26.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChooseWarehouseViewController.h"
#define TopMargin 50
#define TableHeight 50
@interface ChooseWarehouseViewController ()

@end

@implementation ChooseWarehouseViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    //记录更新时间
    self.tableView.header.lastUpdatedTimeKey = ChooseWarehouseUpdateDate;
    self.title = @"选择仓库";
    [self fetchDataList:@"" tableStr:GXF_BASECLASS_WAREHOUSE];
}

- (void)getBaseDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            __strong __typeof(weakSelf)strongSelf = weakSelf;
            [self endRefreshing];
            [strongSelf fetchDataList:@"" tableStr:GXF_BASECLASS_WAREHOUSE];
        }else{
            [IBTLoadingView showTips:data];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
        
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getWarehouseWithPage_number:0 page_size:100 success:succ failure:fail];
}

#pragma mark - 协议方法
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    
    if (self.currentIndexPath) {
        if (indexPath.row == self.currentIndexPath.row) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }else{
        cell.Commitbtn.hidden = YES;
    }
    if (self.dataArr.count > 0) {
        if (indexPath.row == 0) {
            NSString *dateStr = [self.dataArr[indexPath.row] httpParameterString];
            cell.titleLabel.textColor = GXF_CONTENT_COLOR;
            [cell setTitleStr:[NSString stringWithFormat:@"上次更新时间:%@",dateStr]];
        }else{
            Warehouse *warehouse = self.dataArr[indexPath.row];
            NSString *proStr = [NSString stringWithFormat:@"%@[%@]",warehouse.name,warehouse.code];
            
            [cell setTitleStr:proStr];
        }
    }
    return cell;
}

- (void)boxValueChanged:(NSNotification *)fication{
    NSString *tilkeStr = [IBTCommon trimmingCharacters:self.selectTextFiled.text];
    [self fetchDataList:tilkeStr tableStr:GXF_BASECLASS_WAREHOUSE];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
