//
//  FollowUpRecordViewController.m
//  XFFruit
//
//  Created by mac on 15/9/16.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "FollowUpRecordViewController.h"
#import "NotuceRecordCell.h"
#import "NoticeRecord.h"
#define TableHeight 70
@interface FollowUpRecordViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate>

@end

@implementation FollowUpRecordViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self bulidLayout];
    [self getDataFromServer];
    // Do any additional setup after loading the view.
}
- (void)bulidLayout{
    self.productArr=[[NSMutableArray alloc]initWithObjects:@"",@"", nil];
    self.tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height) style:(UITableViewStylePlain)];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.view addSubview:self.tableView];
}
- (void)getDataFromServer{
//    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
//        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message  = data[@"message"] ;
            if (success == 1) {
                NSDictionary *dictData = data[@"data"];
                NoticeRecord *noticeRecord = [[NoticeRecord alloc]init];
                [noticeRecord setValuesForKeysWithDictionary:dictData];
                
                self.noticeRecord = noticeRecord;
                [self.tableView reloadData];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"     无记录     "];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getPurchaseNoticeRecodWithData:self.purchaseNotice.billnumber success:succ failure:fail];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
   
    
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
   
    return self.productArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
   
        
        static NSString *CellID = @"CellID";
         NotuceRecordCell*Cell = [tableView dequeueReusableCellWithIdentifier:CellID];
        
        if (Cell == nil) {
            Cell = [[NotuceRecordCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellID];
            tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
            Cell.selectionStyle = UITableViewCellSelectionStyleNone;
            
           
        }
   
    Cell.uuidLable.text=self.noticeRecord.uuid;//唯一标识
     Cell.traceIdLable.text=[NSString stringWithFormat:@"采购通知单：%@",self.noticeRecord.traceId];//采购通知单
     Cell.typeLable.text=self.noticeRecord.type;//业务类型
     Cell.creatorLable.text=self.noticeRecord.creator;//业务人
     Cell.createdLable.text=[[NSString alloc]initWithData:self.noticeRecord.created  encoding:NSUTF8StringEncoding];//业务时间
     Cell.remarkLable.text=self.noticeRecord.remark;//日志描述信息
        return Cell;
        

}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    
    
    
       return TableHeight;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
  }


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
