//
//  NoticeProductViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NoticeProductViewController.h"
#import "SurveyCell.h"
#import "HPGrowingTextView.h"
#import "ChooseProductViewController.h"
#import "ChooseProductUnitViewController.h"
#define LeftMargin 15
#define BtnHeight 44
#define TableRowHeight 46
#define CornerRadius 5
#define BtnSize 19
#define TotalHeight 230
#define KeyboardHeight 258
typedef enum : NSUInteger {
    deleteTag = 10000,
    SaveTag,
} BtnTag;

@interface NoticeProductViewController ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    
    UILabel *_chooseCostLabel;
    UILabel *_choosePackUnitLabel;
    UITextField *_qpcField;
    UITextField *_qpcQuantityField;
    UITextField *_quantityField;
    HPGrowingTextView *_noteTextView;
}
@property (nonatomic,strong)NSString *productNameStr;
@property (nonatomic,strong)NSString *productCodeStr;
@property (nonatomic,strong)NSString *productUuidStr;
@end

@implementation NoticeProductViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = self.navTitle;
    [self initData];
    [self createTableView];
    
}
- (void)initData{
    
    _dataArr = [NSMutableArray array];
    [_dataArr addObject:@"商品"];
    [_dataArr addObject:@"包装单位"];
    [_dataArr addObject:@"包装规格"];
    [_dataArr addObject:@"包装数量"];
    [_dataArr addObject:@"基础数量"];
    [_dataArr addObject:@"备注"];
}

- (void)createTableView
{
    self.view.backgroundColor  = XXFBgColor;
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, LeftMargin,ScreenSize.width, ScreenSize.height - 64 - LeftMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 50)];
    
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 10, (ScreenSize.width - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:deleteTag image:nil title:@"删除" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:GXF_SAVE_COLOR];
    [footView addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(saveBtn.frame.origin.x + saveBtn.frame.size.width + LeftMargin, 10, (ScreenSize.width - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:GXF_COMMIT_COLOR];
    [footView addSubview:commitBtn];
    
    _tableView.tableFooterView = footView;
    [self.view addSubview:_tableView];
}

#pragma mark - 按钮点击事件
- (void)btnClick:(UIButton *)btn{
    switch (btn.tag) {
        case deleteTag://删除
        {
            if ([self checkCost]) {
                if (self.indexPath) {
                    self.deleteNoticeProduct(self.noticeProduct,self.indexPath);
                    [self PopViewControllerAnimated:YES];
                }else{
                    [self clearInfomation];
                }
            }
        }
            break;
        case SaveTag:
        {
            if ([self checkCost]) {
                self.choseNoticeProduct(self.noticeProduct,self.indexPath);
                [self PopViewControllerAnimated:YES];
            }
        }
            break;
        default:
            break;
    }
}
- (void)clearInfomation{
    _chooseCostLabel.text = @"选择商品";
    _chooseCostLabel.textColor = GXF_PLACEHOLDER_COLOR;
    _choosePackUnitLabel.text = @"选择包装单位";
    _choosePackUnitLabel.textColor = GXF_PLACEHOLDER_COLOR;
    _qpcField.text = @"";
    _qpcQuantityField.text = @"";
    _quantityField.text = @"";
}
- (BOOL)checkCost{
    
    if (_chooseCostLabel.text.length == 0 ) {
        ShowMessage(@"商品不能为空");
        return NO;
    }
    if (_qpcField.text.length == 0 ) {
        ShowMessage(@"包装规格不能为空");
        return NO;
    }
    if (_qpcQuantityField.text.length == 0) {
        ShowMessage(@"包装数量不能为空");
        return NO;
    }
    if (_quantityField.text.length == 0) {
        ShowMessage(@"基础数量不能为空");
        return NO;
    }
    if (!self.noticeProduct) {
        self.noticeProduct = [[NoticeProduct alloc]init];
    }
    self.noticeProduct.productCode = self.productCodeStr;
    self.noticeProduct.productName = self.productNameStr;
    self.noticeProduct.productUuid = self.productUuidStr;
    
    self.noticeProduct.packUnit = _choosePackUnitLabel.text;
    self.noticeProduct.qpc = [NSNumber numberWithFloat:[_qpcField.text floatValue]];
    self.noticeProduct.qpcQuantity = [NSNumber numberWithFloat:[_qpcQuantityField.text floatValue]];
    self.noticeProduct.quantity = [NSNumber numberWithFloat:[_quantityField.text floatValue]];
    self.noticeProduct.remark = _noteTextView.text;
    return YES;
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row == 0 || indexPath.row == 1) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}

-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0 || indexPath.row == 1) {
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableRowHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_PLACEHOLDER_COLOR;
        contentLabel.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:contentLabel];
        
        if (indexPath.row == 0) {
            contentLabel.text = @"选择商品";
            _chooseCostLabel = contentLabel;
        }else if(indexPath.row == 1) {
            contentLabel.text = @"选择包装单位";
            _choosePackUnitLabel = contentLabel;
        }
    }else if (indexPath.row == _dataArr.count -1){
        _noteTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableRowHeight)];
        _noteTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        _noteTextView.minNumberOfLines = 1;
        _noteTextView.maxNumberOfLines = 1;
        _noteTextView.isScrollable = YES;
        _noteTextView.font = GXF_FIFTEENTEN_SIZE;
        _noteTextView.textAlignment = NSTextAlignmentRight;
        _noteTextView.delegate = self;
        _noteTextView.returnKeyType = UIReturnKeyDone;
        _noteTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:_noteTextView];
    }else{
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableRowHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = GXF_CONTENT_COLOR;
        textField.font = GXF_FIFTEENTEN_SIZE;
        textField.returnKeyType = UIReturnKeyDone;
        textField.keyboardType = UIKeyboardTypeDecimalPad;
        textField.delegate = self;
        [cell.contentView addSubview:textField];
        if (indexPath.row == 2) {
            textField.placeholder = @"输入包装规格";
            _qpcField = textField;
        }else if(indexPath.row == 3){
            textField.placeholder = @"输入包装数量";
            _qpcQuantityField = textField;
        }else{
            textField.placeholder = @"输入基础数量";
            _quantityField = textField;
        }
    }
    if (self.noticeProduct) {
        [self prepareDataIncell];
    }
}
- (void)prepareDataIncell{
    _chooseCostLabel.text = [NSString stringWithFormat:@"%@[%@]",self.noticeProduct.productName,self.noticeProduct.productCode];
    self.productUuidStr = self.noticeProduct.productUuid;
    self.productCodeStr = self.noticeProduct.productCode;
    self.productNameStr = self.noticeProduct.productName;
    
    _chooseCostLabel.textColor = GXF_CONTENT_COLOR;
    _choosePackUnitLabel.text = self.noticeProduct.packUnit;
    _choosePackUnitLabel.textColor = GXF_CONTENT_COLOR;

    _qpcField.text = [self.noticeProduct.qpc stringValue];
    _qpcQuantityField.text = [self.noticeProduct.qpcQuantity stringValue];
    _quantityField.text = [self.noticeProduct.quantity stringValue];
    _noteTextView.text = self.noticeProduct.remark;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableRowHeight;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if(indexPath.row == 0){
        ChooseProductViewController *cvc = [ChooseProductViewController new];
        cvc.choseBaseInfo = ^(NSArray  *products){
            Product *product=products [0];
            _chooseCostLabel.text = [NSString stringWithFormat:@"%@[%@]",product.name,product.code];
            _chooseCostLabel.textColor = GXF_CONTENT_COLOR;
            self.productNameStr = product.name;
            self.productUuidStr = product.uuid;
            self.productCodeStr = product.code;
        };
        cvc.isMoreChose = NO;
        [self PushViewController:cvc animated:YES];
    }else if(indexPath.row == 1){
        ChooseProductUnitViewController *cvc = [ChooseProductUnitViewController new];
        cvc.choseBaseInfo = ^(NSArray  *products){
            if (products.count > 0) {
                GXFProductUnit *productUnit=products [0];
                _choosePackUnitLabel.text = [NSString stringWithFormat:@"%@",productUnit.name];
                _choosePackUnitLabel.textColor = GXF_CONTENT_COLOR;
            }
        };
        cvc.isMoreChose = NO;
        [self PushViewController:cvc animated:YES];
    }
}
#pragma mark delegate
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [_noteTextView resignFirstResponder];
    return YES;
}

- (void)keyboardHidden{
    [_qpcField resignFirstResponder];
    [_qpcQuantityField resignFirstResponder];
    [_quantityField resignFirstResponder];
    [_noteTextView resignFirstResponder];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
