//
//  ReceiveBoltView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/10/13.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ReceiveBoltView.h"

#import "MaskCell.h"

#define TableHeight 45
#define LeftMargin 80
#define TotalHeight 224
#define LeftHeight 44
#define BottomHeight 50

@interface ReceiveBoltView ()<UITextFieldDelegate>
{
    UIView *_leftView;
    UIButton *_currentBtn;
    NSIndexPath *_currentIndexPath;
    NSString *_state;
    UIButton *_clearBtn;
}
@property (nonatomic,strong)NSString *state;

@end

@implementation ReceiveBoltView

- (instancetype)initWithFrame:(CGRect)frame state:(NSString *)state{
    self = [super initWithFrame:frame];
    if (self) {
        self.state = state;
        [self createView];
        [self createRightView];
        [self preferData];
    }
    return self;
}
- (void)preferData{
     if ([self.state isEqualToString:TRANSPORT_STATE_UNRECEIVED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:0 inSection:0];
    }else if ([self.state isEqualToString:TRANSPORT_STATE_RECEIVED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:1 inSection:0];
    }
}

#pragma mark - 创建视图
- (void)createView
{
    _leftView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, LeftMargin,self.frame.size.height- BottomHeight)];
    [self addSubview:_leftView];
    NSArray *arr = @[@"按状态"];
    for (NSInteger i = 0; i<arr.count; i++) {
        UIButton *button = [UIButton buttonWithType:UIButtonTypeSystem];
        button.frame = CGRectMake(0, LeftHeight * i ,  LeftMargin ,LeftHeight);
        [button setTitle:arr[i] forState:UIControlStateNormal];
        [button setTitleColor:GXF_DETAIL_COLOR forState:UIControlStateNormal];
        if (i == 0) {
            button.enabled = NO;
            _currentBtn = button;
        }
        [button setBackgroundImage:[UIImage imageNamed:@"maskEnable"] forState:UIControlStateDisabled];
        [button setBackgroundImage:[UIImage imageNamed:@"mask"] forState:UIControlStateNormal];
        button.tag = 1001+i;
        [button addTarget:self action:@selector(leftBtnClick:) forControlEvents:UIControlEventTouchUpInside];
        [_leftView addSubview:button];
    }
    _clearBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    _clearBtn.frame = CGRectMake(0, CGRectGetMaxY(_leftView.frame), self.frame.size.width, BottomHeight);
    [_clearBtn setTitle:@"清空选项" forState:UIControlStateNormal];
    [_clearBtn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
    _clearBtn.titleLabel.font = GXF_FIFTEENTEN_SIZE;
    [_clearBtn addTarget:self action:@selector(clearBolt) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:_clearBtn];
}
- (void)createRightView{
    self.tableView = [[UITableView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self addSubview:self.tableView];
    
}


- (void)leftBtnClick:(UIButton *)btn{
    _currentBtn.enabled = YES;
    btn.enabled = NO;
    _currentBtn = btn;
}

- (void)clearBolt{
    if (_currentIndexPath) {
        _currentIndexPath = nil;
        [self.tableView reloadData];
    }
    if ([self.delegate respondsToSelector:@selector(clearBoltInformation)]) {
        [self.delegate clearBoltInformation];
    }
}

#pragma mark - 协议
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskID";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth: ScreenSize.width - 80 totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (_dataArr.count > 0) {
        cell.Commitbtn.hidden = YES;
        [cell setTitleStr:self.dataArr[indexPath.row]];
        
    }
    if (_currentIndexPath) {
        if (indexPath.row == _currentIndexPath.row) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    //获取选中的cell
    MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
    currentCell.Commitbtn.hidden = YES;
    MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
    cell.Commitbtn.hidden = NO;
    _currentIndexPath = indexPath;
    
    NSString *stateStr = @"";
    if (indexPath.row == 0) {
        stateStr = TRANSFER_STATE_UNRECEIVED;
    }else if(indexPath.row == 1){
        stateStr = TRANSFER_STATE_RECEIVED;
    }
    [self.delegate getBoltValueSelectRow:stateStr];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}

@end

