//
//  ICRConfigurationViewController.m
//  XFFruit
//
//  Created by Lili Wang on 15/4/3.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ICRConfigurationViewController.h"
#import "IBTTableView.h"

@interface ICRConfigurationViewController ()

@property (strong, nonatomic) IBTTableViewInfo *m_tableViewInfo;

@end

@implementation ICRConfigurationViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initTableViewInfo];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method

- (void)initTableViewInfo {
    
    self.title = [IBTCommon localizableString:@"Congiguration"];
    
    self.m_tableViewInfo = [[IBTTableViewInfo alloc] initWithFrame:self.view.bounds style:UITableViewStyleGrouped];
    
    IBTTableView *tableV = [_m_tableViewInfo getTableView];
    tableV.backgroundColor = [UIColor colorWithW:246 a:1];
    [self.view addSubview:tableV];
    
    IBTTableViewSectionInfo *secInfo;
    IBTTableViewCellInfo *cellInfo;
    
    UIColor *titleColor = [UIColor colorWithRed:0.031f green:0.031f blue:0.031f alpha:1.00f];
    CGFloat fCellHeight = 44.0f;
    
    secInfo = [IBTTableViewSectionInfo sectionInfoDefaut];
    
    //restore state
    cellInfo = [IBTTableViewCellInfo normalCellForSel:@selector(restoreStateAction:)
                                               target:self
                                                title:[IBTCommon localizableString:@"Restore State:"]
                                        accessoryType:UITableViewCellAccessoryNone];
    cellInfo.selectionStyle = UITableViewCellSelectionStyleNone;
    [cellInfo addUserInfoValue:titleColor forKey:CInfoTitleColorKey];
    cellInfo.fCellHeight = fCellHeight;
    [secInfo addCell:cellInfo];
    
    //update data
    cellInfo = [IBTTableViewCellInfo switchCellForSel:@selector(onSwitchChange:)
                                               target:self
                                                title:[IBTCommon localizableString:@"Only Wifi Update Data:"]
                                                   on:NO];
    [cellInfo addUserInfoValue:titleColor forKey:CInfoTitleColorKey];
    cellInfo.fCellHeight = fCellHeight;
    [secInfo addCell:cellInfo];
    [_m_tableViewInfo addSection:secInfo];
}

#pragma mark - Actions 
- (void)restoreStateAction:(__unused id)sender {
    
}
- (void)onSwitchChange:(__unused id)sender {
    
}
@end
