//
//  TransportPurchaseCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransportPurchaseCell.h"
#import "TransportPurductCell.h"
#import "HeaderCell.h"
#define TableHeight 44
#define ShowHeight  110


@implementation TransportPurchaseCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.contentView.backgroundColor = XXFBgColor;
    
    self.bgView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 170)];
    self.bgView.backgroundColor = [UIColor whiteColor];
    [self.contentView addSubview:self.bgView];
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0,0, ScreenSize.width, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;

    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0, 0, ScreenSize.width, 44))];
    self.titleLabel.textColor = GXF_NAVIGAYION_COLOR;
    self.titleLabel.textAlignment = NSTextAlignmentCenter;
    self.titleLabel.font = GXF_SEVENTEENTH_SIZE;
    
    self.secondLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0,44-1, ScreenSize.width, 1))];;
    self.secondLabel.backgroundColor = GXF_LINE_COLOR;

    
    [self.bgView addSubview:self.titleLabel];
    [self.bgView addSubview:self.lineLabel];
    [self.bgView addSubview:self.secondLabel];

    self.secondTable = [[UITableView alloc]initWithFrame:(CGRectMake(0, 44,ScreenSize.width, self.bgView.height-45)) style:(UITableViewStylePlain)];
    
    self.secondTable.delegate = self;
    self.secondTable.dataSource = self;
        self.secondTable.bounces = NO;
    self.secondTable.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.bgView addSubview:self.secondTable];
    NSArray *arr = @[@"商品",@"单价",@"包装数量"];
    
    HeaderCell *headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) withArr:arr withHiddenEdit:YES];
    self.secondTable.tableHeaderView = headCell;
    

}
- (void)setPurchaseBill:(PurchaseBill *)bill selectArr:(NSMutableArray *)selectArr{
    self.bgView.height = 92 + bill.products.count * 44;
    self.secondTable.height = self.bgView.height - 45;
    self.titleLabel.text = [NSString stringWithFormat:@"采购单:%@",bill.billNumber];
    self.secondArr = [NSMutableArray array];
    self.selectArr = selectArr;
    [self.secondArr addObjectsFromArray:bill.products];
    
//    self.secondTable = [[UITableView alloc]initWithFrame:(CGRectMake(0, 44,ScreenSize.width, self.bgView.height-45)) style:(UITableViewStylePlain)];
//
//    self.secondTable.delegate = self;
//    self.secondTable.dataSource = self;
////    self.secondTable.bounces = NO;
//    self.secondTable.separatorStyle = UITableViewCellSeparatorStyleNone;
//    [self.bgView addSubview:self.secondTable];
//    NSArray *arr = @[@"商品",@"单价",@"包装数量"];
//    
//    HeaderCell *headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) withArr:arr];
//    self.secondTable.tableHeaderView = headCell;
    //重要
    [self.secondTable reloadData];
}

- (void)setTransPort:(Transport *)bill selectArr:(NSMutableArray *)selectArr{
    self.bgView.height = 92 + bill.pdtDetails.count * 44;
    self.secondTable.height = self.bgView.height - 45;
    self.titleLabel.text = [NSString stringWithFormat:@"发运单号:%@",bill.billnumber];
    self.secondArr = [NSMutableArray array];
    self.selectArr = selectArr;
    [self.secondArr addObjectsFromArray:bill.pdtDetails];
    //重要
    [self.secondTable reloadData];
}

-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.secondArr.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *cellID = @"TransportPurductCell";
    TransportPurductCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[TransportPurductCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID withImageName:@"selected"];
        cell.editBtn.hidden = YES;
        cell.rightImageName = @"edit";
    }
    if (self.secondArr.count > 0) {
        TransportPdtDetail * billProduct = self.secondArr[indexPath.row];
        [cell setPdtDetail:billProduct row:indexPath.row];
        
        if ([self isHaveIndexPath:billProduct]) {
            cell.editBtn.hidden = NO;
            //        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
            //        cell.lineLabel.y = ShowHeight + TableHeight -1;
            //        cell.showView.height = ShowHeight;
            //        cell.backgroundColor = XXFBgColor;
        }else{
            cell.editBtn.hidden = YES;
            //        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
            //        cell.lineLabel.y =  TableHeight -1;
            //        cell.showView.height = 0;
            //        cell.backgroundColor = [UIColor whiteColor];
        }
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
    
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
//    TransportPdtDetail * billProduct = self.secondArr[indexPath.row];
//    if ([self isHaveIndexPath:billProduct]) {
//        return ShowHeight + TableHeight;
//    }
    return TableHeight;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    TransportPurductCell *cell = (TransportPurductCell *)[tableView cellForRowAtIndexPath:indexPath];
    TransportPdtDetail * billProduct = self.secondArr[indexPath.row];
    if (![self isHaveIndexPath:billProduct]) {
        cell.editBtn.hidden = NO;
//        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
//        cell.lineLabel.y = ShowHeight + TableHeight -1;
//        cell.showView.height = ShowHeight;
//        cell.backgroundColor = [UIColor whiteColor];
        
        [self.selectArr addObject:billProduct];
//        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_getSelectPurchaseProduct object:nil userInfo:@{@"selectArr":billProduct,@"state":@"add"}];
    }else{
        [self.selectArr removeObject:billProduct];
        cell.editBtn.hidden = YES;
//        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
//        cell.lineLabel.y =  TableHeight -1;
//        cell.showView.height = 0;
//        cell.backgroundColor = [UIColor whiteColor];
//        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_getSelectPurchaseProduct object:nil userInfo:@{@"selectArr":billProduct,@"state":@"remove"}];
    }
    [self.secondTable reloadData];
}
- (BOOL)isHaveIndexPath:(TransportPdtDetail *)billProduct{
    for (TransportPdtDetail *detail in self.selectArr) {
        if (detail.uuid == billProduct.uuid || [detail.uuid isEqualToString:billProduct.uuid]) {
            return YES;
        }
    }
    return NO;
}
- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
