//
//  PurchaseDetailViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/23.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "PurchaseDetailViewController.h"
#import "ProductBillViewController.h"
#import "PurchaseBillProduct.h"
#define BottomHeight                                50
#define LeftMargin                                  15
#define LeftWidth                                   100
#define LeftHeight                                  30
#define TopMargin                                   15
#define OneWidth                                    (ScreenSize.width - LeftMargin * 2)
#define TwoWidth                                    ((ScreenSize.width - LeftMargin*3)/2)
typedef enum : NSUInteger {
    CancleTag = 3500,//作废
    EndTag,          //结束
    RejectTag,       //拒绝
    PassTag,         //审核
    SureTag,         //确定

} BtnTag;

@interface PurchaseDetailViewController ()
{
    UIScrollView *_scrollView;
    UIView *_purchaseView;
    UIView *_bottomView;
    ProductBillViewController *_pvc;
    NSArray *_leftArr;
    UIButton *_firstBtn;
    UIButton *_secondBtn;

}
@property (nonatomic,strong)UILabel *billNumberLabel;
@property (nonatomic,strong)UILabel *noticeNumberLabel;
@property (nonatomic,strong)UILabel *createOperNameLabel;
@property (nonatomic,strong)UILabel *checkNameLabel;
@property (nonatomic,strong)UILabel *stateLabel;
@property (nonatomic,strong)UILabel *lastModifyNameLabel;

@property (nonatomic,strong)UILabel *typeLabel;
@property (nonatomic,strong)UILabel *vendorNameLabel;
@property (nonatomic,strong)UILabel *vendorIsSureLabel;
@property (nonatomic,strong)UILabel *warehouseLabel;
@property (nonatomic,strong)UILabel *otherPriceLabel;

@property (nonatomic,strong)UILabel *totalPriceLabel;
@property (nonatomic,strong)UILabel *noteLabel;


@property (nonatomic,strong)NSString *rejectCause;//拒接原因
@end

@implementation PurchaseDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self bulidLayout];
    [self getDataFromServer];
}
- (void)getDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message  = data[@"message"] ;
            if (success == 1) {
                NSDictionary *dictData = data[@"data"];
                PurchaseBill *bill = [[PurchaseBill alloc]init];
                [bill setValuesForKeysWithDictionary:dictData];
                self.bill = bill;
                [strongSelf fetchtPurchaseDetail];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"     无记录     "];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getPurchaseResultWithPurchaseUuid:self.bill.uuid success:succ failure:fail];
}


#pragma mark - 视图初始化
- (void)bulidLayout{
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height - 64 - BottomHeight)];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.backgroundColor = XXFBgColor;
    [self.view addSubview:_scrollView];
    [self createBtn];
    [self createBottomView];

    [self createPurchaseView];
    
}

- (void)createBtn{
    _firstBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, (ScreenSize.width - LeftMargin*3)/2, 40) target:self sel:@selector(btnClick:) tag:0 image:nil title:@"" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_SAVE_COLOR];
    [self.view addSubview:_firstBtn];
    
    _secondBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetMaxX(_firstBtn.frame)+ LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, (ScreenSize.width - LeftMargin*3)/2, 40) target:self sel:@selector(btnClick:) tag:0 image:nil title:@"" titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_COMMIT_COLOR];
    [self.view addSubview:_secondBtn];
    [self showBtnByPermissions];
}
//根据权限判断按钮显示
- (void)showBtnByPermissions{
    //逻辑判断按钮显示不显示
    if ([self.bill.state isEqualToString:PURCHASE_STATE_SUBMITTED]) {//状态已提交 未审批
        if([self checkIsPermission:PURCHASE_PERMISSIONS_MANAGEAPPROVE]){
            //显示拒绝和审批
            [self changeBtnFrame:_firstBtn title:@"拒绝" originX:LeftMargin width:TwoWidth];
            [self changeBtnFrame:_secondBtn title:@"审核通过" originX:CGRectGetMaxX(_firstBtn.frame) + LeftMargin width:TwoWidth];
            _firstBtn.tag = RejectTag;
            _secondBtn.tag = PassTag;
            self.indexStyle = 1;
        }else{
            [self hiddenTwoBtn];
        }
    }else if([self.bill.state isEqualToString:PURCHASE_STATE_APPROVED]){//状态是发运中即已审批
        if([self checkIsPermission:PURCHASE_PERMISSIONS_VENDORAPPROVE]){//供应商审批权
            //显示确认按钮
            _firstBtn.hidden = YES;
            [self changeBtnFrame:_secondBtn title:@"确认" originX:LeftMargin width:OneWidth];
            _secondBtn.tag = SureTag;
            self.indexStyle = 2;
        }else{
            self.indexStyle = 0;
            if ([self checkIsPermission:PURCHASE_PERMISSIONS_FINISH]&&[self checkIsPermission:PURCHASE_PERMISSIONS_ABORT]) {
                //显示结束和作废按钮
                [self changeBtnFrame:_firstBtn title:@"结束" originX:LeftMargin width:TwoWidth];
                [self changeBtnFrame:_secondBtn title:@"作废" originX:CGRectGetMaxX(_firstBtn.frame) + LeftMargin width:TwoWidth];
                _firstBtn.tag = EndTag;
                _secondBtn.tag = CancleTag;
            }else{
                if ([self checkIsPermission:PURCHASE_PERMISSIONS_FINISH]){//结束权
                    //显示结束按钮
                    _firstBtn.hidden = YES;
                    [self changeBtnFrame:_secondBtn title:@"结束" originX:LeftMargin width:OneWidth];
                    _secondBtn.tag = EndTag;
                }else if([self checkIsPermission:PURCHASE_PERMISSIONS_ABORT]){//作废权
                    //显示作废按钮
                    _firstBtn.hidden = YES;
                    [self changeBtnFrame:_secondBtn title:@"作废" originX:LeftMargin width:OneWidth];
                    _secondBtn.tag = CancleTag;
                }else{
                    [self hiddenTwoBtn];
                }
            }
        }
    }else if([self.bill.state isEqualToString:PURCHASE_STATE_FINISHED]){//完成
        if ([self checkIsPermission:PURCHASE_PERMISSIONS_ABORT]) {//有作废权的
            //显示作废按钮
            _firstBtn.hidden = YES;
            [self changeBtnFrame:_secondBtn title:@"作废" originX:LeftMargin width:OneWidth];
            _secondBtn.tag = CancleTag;
            self.indexStyle = 0;

        }else{
            [self hiddenTwoBtn];
        }
    }else if([self.bill.state isEqualToString:PURCHASE_STATE_ABORTED]){//已作废
        [self hiddenTwoBtn];
    }
}

- (void)hiddenTwoBtn{
    _firstBtn.hidden = YES;
    _secondBtn.hidden = YES;
    self.indexStyle = 1;
    CGRect scrollViewFrame = _scrollView.frame;
    scrollViewFrame.size.height = ScreenSize.height - 64;
    _scrollView.frame = scrollViewFrame;
}
//改变按钮的位置
- (void)changeBtnFrame:(UIButton *)btn title:(NSString *)title originX:(CGFloat)originX width:(CGFloat)width{
    CGRect btnFrame = btn.frame;
    btnFrame.origin.x = originX;
    btnFrame.size.width = width;
    btn.frame = btnFrame;
    [btn setTitle:title forState:UIControlStateNormal];
}
- (BOOL)checkIsPermission:(NSString *)permission{
    for (NSString *per in [ICRUserUtil sharedInstance].permissions) {
        if ([per isEqualToString:permission]) {
            return YES;
        }
    }
    return NO;
}

- (void)btnClick:(UIButton *)btn{
    CLog(@"%ld",(long)btn.tag);
    switch (btn.tag) {
        case CancleTag:
        {
            CLog(@"作废");
            [self dealByAction:PURCHASE_ACTION_ABORT];
        }
            break;
        case EndTag:
        {
            CLog(@"结束");
            [self dealByAction:PURCHASE_ACTION_FINISH];
        }
            break;
        case RejectTag:
        {
            CLog(@"拒绝");
            [self dealByAction:PURCHASE_ACTION_REJECT];
        }
            break;
        case PassTag:
        {
            CLog(@"审核通过");
            [self dealByAction:PURCHASE_ACTION_APPROVE];
        }
            break;
        case SureTag:
        {
            CLog(@"确认");
            [self dealByAction:PURCHASE_ACTION_VENDORCONFIRM];
        }
            break;
        default:
            break;
    }
}
- (void)dealByAction:(NSString *)action{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                [ICRUserUtil sharedInstance].needFresh = YES;
                [self PopViewControllerAnimated:YES];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"操作异常"];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController]dealByActionWithPurchaseUuid:self.bill.uuid action:action remark:[IBTCommon checkString:self.rejectCause] version:self.bill.version success:succ failure:fail];
}

- (void)createBottomView{
    _bottomView= [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_purchaseView.frame) + TopMargin, ScreenSize.width, 200)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
    
    _pvc = [[ProductBillViewController alloc]init];
    [self addChildViewController:_pvc];
    
    _pvc.viewFrame = _bottomView.bounds;
    _pvc.isHiddenEdit = YES;
    [_bottomView addSubview:_pvc.view];
}

- (void)createPurchaseView{
    if (self.indexStyle == 0) {
        _leftArr = @[@"单号:",@"采购通知单:",@"创建人:",@"最后修改人:",@"状态:",@"类型:",@"供应商:",@"供应商确认:",@"收货仓库:",@"其他费用:",@"总金额:",@"备注:"];
    }else if (self.indexStyle == 1) {
        _leftArr = @[@"单号:",@"采购通知单:",@"创建人:",@"审核人:",@"状态:",@"类型:",@"供应商:",@"供应商确认:",@"收货仓库:",@"其他费用:",@"总金额:",@"备注:"];
    }else{
        _leftArr = @[@"单号:",@"采购通知单:",@"创建人:",@"审核人:",@"状态:",@"供应商:",@"其他费用:",@"总金额:",@"备注:"];
    }
    _purchaseView= [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, LeftHeight*_leftArr.count +LeftMargin)];
    _purchaseView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_purchaseView];
    
    for (NSInteger i = 0 ; i < _leftArr.count; i++) {
        UILabel *leftLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin, 10 + LeftHeight *i, LeftWidth, LeftHeight)];
        leftLabel.font = GXF_SEVENTEENTH_SIZE;
        leftLabel.text = _leftArr[i];
        leftLabel.textColor = GXF_DETAIL_COLOR;
        [_purchaseView addSubview:leftLabel];
        
        UILabel *rightLabel = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(leftLabel.frame), 10 + LeftHeight *i, _purchaseView.frame.size.width - LeftMargin - LeftWidth, LeftHeight)];
        rightLabel.font = GXF_SEVENTEENTH_SIZE;
        rightLabel.textColor = GXF_DETAIL_COLOR;
        
        if (i == 0) {
            self.billNumberLabel = rightLabel;
        }else if (i == 1) {
            self.noticeNumberLabel = rightLabel;
        }else if(i == 2){
            self.createOperNameLabel = rightLabel;
        }else if(i == _leftArr.count - 3){
            self.otherPriceLabel = rightLabel;
        }else if(i == _leftArr.count - 2){
            self.totalPriceLabel = rightLabel;
        }else if(i == _leftArr.count - 1){
            rightLabel.numberOfLines = 0;
            self.noteLabel = rightLabel;
        }
        if (self.indexStyle == 0 || self.indexStyle == 1) {
            if (self.indexStyle == 0) {
                if (i == 3) {
                    self.lastModifyNameLabel = rightLabel;
                }
            }else{
                if (i == 3) {
                    self.checkNameLabel = rightLabel;
                }
            }
            if(i == 4){
                self.stateLabel = rightLabel;
            }else if(i == 5){
                self.typeLabel = rightLabel;
            }else if(i == 6){
                self.vendorNameLabel = rightLabel;
            }else if(i == 7){
                self.vendorIsSureLabel = rightLabel;
            }else if(i == 8){
                self.warehouseLabel = rightLabel;
            }
        }else{
            if(i == 3){
                self.checkNameLabel = rightLabel;
            }else if(i == 4){
                self.stateLabel = rightLabel;
            }else if(i == 5){
                self.vendorNameLabel = rightLabel;
            }
        }
        [_purchaseView addSubview:rightLabel];
    }
}

- (void)fetchtPurchaseDetail{
    self.billNumberLabel.text = [IBTCommon checkString:self.bill.billNumber];
    if ([self.bill.state isEqualToString:PURCHASE_STATE_INITIAL]) {
        self.stateLabel.textColor = [UIColor redColor];
        self.stateLabel.text = @"未提交";
    }else if ([self.bill.state isEqualToString:PURCHASE_STATE_SUBMITTED]) {
        self.stateLabel.textColor = [UIColor greenColor];
        self.stateLabel.text = @"已提交";
    }else if ([self.bill.state isEqualToString:PURCHASE_STATE_REJECTED]) {
        self.stateLabel.textColor = [UIColor grayColor];
        self.stateLabel.text = @"已拒绝";
    }else if ([self.bill.state isEqualToString:PURCHASE_STATE_APPROVED]) {
        self.stateLabel.textColor = [UIColor grayColor];
        self.stateLabel.text = @"已审批";
    }else if ([self.bill.state isEqualToString:PURCHASE_STATE_SHIPPING]) {
        self.stateLabel.textColor = [UIColor grayColor];
        self.stateLabel.text = @"发运中";
    }else if ([self.bill.state isEqualToString:PURCHASE_STATE_FINISHED]) {
        self.stateLabel.textColor = [UIColor blackColor];
        self.stateLabel.text = @"已完成";
    }
    self.noticeNumberLabel.text = (self.bill.noticeNumber.length == 0) ? @"无":(self.bill.noticeNumber);
    self.createOperNameLabel.text = [IBTCommon checkString:self.bill.create_operName];
    self.checkNameLabel.text = [IBTCommon checkString:self.bill.vendor_name];
    self.vendorNameLabel.text = [IBTCommon checkString:self.bill.vendor_name];
    self.totalPriceLabel.text = [IBTCommon checkString:[self.bill.total stringValue]];
    self.noteLabel.text = [IBTCommon checkString:self.bill.remark];
    self.lastModifyNameLabel.text = [IBTCommon checkString:self.bill.lastModify_operName];
    NSString *type = [self.bill.type isEqualToString:GXF_Critical] ? @"紧急" : @"普通";
    self.typeLabel.text = type;
    self.vendorIsSureLabel.text = self.bill.vendorConfirmTime.length > 0 ? @"是":@"否";
    self.warehouseLabel.text = [IBTCommon checkString:self.bill.receiveWrh_name];
    self.otherPriceLabel.text = [self.bill.charge stringValue];
    NSMutableArray *productArr = [NSMutableArray array];
    for (NSDictionary *billDict in self.bill.products) {
        PurchaseBillProduct *billProbuct = [PurchaseBillProduct new];
        [billProbuct setValuesForKeysWithDictionary:billDict];
        [productArr addObject:billProbuct];
    }
    _pvc.productArr = productArr;
    [_pvc.tableView reloadData];
    
    [self setNoteHeight];
}

- (void)setNoteHeight
{
    CGFloat height =  [self.noteLabel calculateHeight];
    
    CGRect noteFrame = self.noteLabel.frame;
    noteFrame.size.height = height;
    self.noteLabel.frame = noteFrame;
    
    CGFloat totalHeight = height + LeftHeight*_leftArr.count;
    CGRect purchaseFrame = _purchaseView.frame;
    purchaseFrame.size.height = totalHeight;
    _purchaseView.frame = purchaseFrame;
    
    
    CGRect bottomFrame = _bottomView.frame;
    bottomFrame.origin.y = CGRectGetMaxY(_purchaseView.frame) + TopMargin;
    _bottomView.frame = bottomFrame;
    
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, totalHeight + CGRectGetHeight(_bottomView.frame) + TopMargin*2);
}





- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
