//
//  ProductCell.m
//  XFFruit
//
//  Created by n22 on 15/8/21.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ProductBillCell.h"
#define LeftMargin 13
#define TableHeight 44
#define SmallSize 10
#define SmallWidth 20
#define SpaceMargin 1
#define LeftWidth 45
#define RightWidth 30

#define ShowWidth 150
#define ShowHeight 20

@implementation ProductBillCell



- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    CGFloat headWidth = (ScreenSize.width - LeftWidth*2 - SpaceMargin* (3 -1))/3;
    
    self.smallImageView = [[UIImageView alloc]initWithFrame:CGRectMake(LeftMargin, (TableHeight - SmallSize)/2 , SmallSize, SmallSize)];
    self.smallImageView.image = [UIImage imageNamed:@"arrowright"];
    self.smallImageView.contentMode = UIViewContentModeScaleAspectFit;
    
    self.seqLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.smallImageView.frame), 0, SmallWidth, TableHeight))];
    self.seqLabel.textColor = GXF_CONTENT_COLOR;
    self.seqLabel.text = @"13";
    self.seqLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftWidth, 0, headWidth, TableHeight))];
    self.titleLabel.textAlignment = NSTextAlignmentLeft;
    self.titleLabel.textColor = GXF_CONTENT_COLOR;
    self.titleLabel.text = @"苹果桃子";
    self.titleLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.priceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.titleLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.priceLabel.textAlignment = NSTextAlignmentLeft;
    self.priceLabel.textColor = GXF_CONTENT_COLOR;
    self.priceLabel.text = @"80";
    self.priceLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.countLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.priceLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.countLabel.textAlignment = NSTextAlignmentLeft;
    self.countLabel.text = @"200";
    self.countLabel.textColor = GXF_CONTENT_COLOR;
    self.countLabel.font = GXF_SIXTEENTEH_SIZE;

    
    self.showView = [[UIView alloc]initWithFrame:CGRectMake(0, TableHeight, ScreenSize.width, 0)];
    self.showView.clipsToBounds = YES;
    
    self.showStandLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.seqLabel.frame), 0, ShowWidth, ShowHeight))];
    self.showStandLabel.textAlignment = NSTextAlignmentLeft;
    self.showStandLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showStandLabel.text = @"包装规格：1*12斤";
    self.showStandLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.showStandLabel.frame), 0, ShowWidth, ShowHeight))];
    self.showCountLabel.textAlignment = NSTextAlignmentLeft;
    self.showCountLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showCountLabel.text = @"包装数量：10000";
    self.showCountLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showBaseCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showStandLabel.frame), ShowWidth, ShowHeight))];
    self.showBaseCountLabel.textAlignment = NSTextAlignmentLeft;
    self.showBaseCountLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showBaseCountLabel.text = @"基础数量：300";
    self.showBaseCountLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showPriceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showCountLabel.frame), CGRectGetMaxY(self.showStandLabel.frame), ShowWidth, ShowHeight))];
    self.showPriceLabel.textAlignment = NSTextAlignmentLeft;
    self.showPriceLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showPriceLabel.text = @"包装单价：11元";
    self.showPriceLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showBasePriceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showBaseCountLabel.frame), ShowWidth, ShowHeight))];
    self.showBasePriceLabel.textAlignment = NSTextAlignmentLeft;
    self.showBasePriceLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showBasePriceLabel.text = @"基础单价：1000";
    self.showBasePriceLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showTotalLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showCountLabel.frame), CGRectGetMaxY(self.showBaseCountLabel.frame), ShowWidth, ShowHeight))];
    self.showTotalLabel.textAlignment = NSTextAlignmentLeft;
    self.showTotalLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showTotalLabel.text = @"总金额：100";
    self.showTotalLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showNoteLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showBasePriceLabel.frame), ShowWidth, ShowHeight))];
    self.showNoteLabel.textAlignment = NSTextAlignmentLeft;
    self.showNoteLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showNoteLabel.text = @"备注：1000";
    self.showNoteLabel.font = GXF_THREETEENTH_SIZE;
    
   
    
    self.editBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.editBtn setImage:[UIImage imageNamed:@"edit"] forState:UIControlStateNormal];
    self.editBtn.frame = CGRectMake(ScreenSize.width - LeftWidth, 0, LeftWidth , TableHeight);
    self.editBtn.contentMode = UIViewContentModeScaleAspectFit;

    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width  - LeftMargin * 2, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    
    [self.contentView addSubview:self.smallImageView];
    [self.contentView addSubview:self.seqLabel];
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.priceLabel];
    [self.contentView addSubview:self.countLabel];
    [self.contentView addSubview:self.editBtn];
    [self.contentView addSubview:self.showView];
    
    [self.showView addSubview:self.showStandLabel];
    [self.showView addSubview:self.showCountLabel];
    [self.showView addSubview:self.showBaseCountLabel];
    [self.showView addSubview:self.showPriceLabel];
    [self.showView addSubview:self.showBasePriceLabel];
    [self.showView addSubview:self.showTotalLabel];

    [self.showView addSubview:self.showNoteLabel];
    [self.contentView addSubview:self.lineLabel];
    
}
- (void)setBillProduct:(PurchaseBillProduct *)billProduct row:(NSInteger)row
{
    self.seqLabel.text = [NSString stringWithFormat:@"%@",@(row+1)];
    self.titleLabel.text = billProduct.product_name;
    self.priceLabel.text = [billProduct.price stringValue];
    self.countLabel.text = [billProduct.qty stringValue];
    self.showStandLabel.text = [NSString stringWithFormat:@"包装规格：%@",billProduct.qpc];
    self.showCountLabel.text = [NSString stringWithFormat:@"包装数量：%@",billProduct.baseQty];
    self.showBaseCountLabel.text =[NSString stringWithFormat:@"基础数量：%@",billProduct.qty];
    self.showPriceLabel.text = [NSString stringWithFormat:@"包装单价：%@",billProduct.price];
    self.showBasePriceLabel.text = [NSString stringWithFormat:@"基础单价：%@",billProduct.basePrice];
    self.showTotalLabel.text = [NSString stringWithFormat:@"总金额：%@",billProduct.total];
    self.showNoteLabel.text =[NSString stringWithFormat:@"备注：%@",billProduct.remark];
    [self isShowShippingQty:billProduct];
}

- (void)isShowShippingQty:(PurchaseBillProduct *)billProduct{
    if(billProduct.shippedQty){
        self.showShippedFlag = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showBasePriceLabel.frame), ShowWidth, ShowHeight))];
        self.showShippedFlag.textAlignment = NSTextAlignmentLeft;
        self.showShippedFlag.textColor = GXF_PLACEHOLDER_COLOR;
        self.showShippedFlag.text = @"是否发运：未";
        self.showShippedFlag.font = GXF_THREETEENTH_SIZE;
        
        self.showShippedQty = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showCountLabel.frame), CGRectGetMaxY(self.showBasePriceLabel.frame), ShowWidth, ShowHeight))];
        self.showShippedQty.textAlignment = NSTextAlignmentLeft;
        self.showShippedQty.textColor = GXF_PLACEHOLDER_COLOR;
        self.showShippedQty.text = @"发运包装数量：";
        self.showShippedQty.font = GXF_THREETEENTH_SIZE;
        
        self.showShippedBaseQty = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showShippedFlag.frame), ShowWidth, ShowHeight))];
        self.showShippedBaseQty.textAlignment = NSTextAlignmentLeft;
        self.showShippedBaseQty.textColor = GXF_PLACEHOLDER_COLOR;
        self.showShippedBaseQty.text = @"发运基础数量：";
        self.showShippedBaseQty.font = GXF_THREETEENTH_SIZE;
        
        self.showNoteLabel.frame = CGRectMake(CGRectGetMinX(self.showCountLabel.frame), CGRectGetMaxY(self.showShippedFlag.frame), ShowWidth, ShowHeight);
    }
    NSMutableAttributedString *attributeStr1 = [IBTCommon setTextViewFontOfString:@"发运状态：" paragraphStyle:0 fontSize:13 color:GXF_CELL_COLOR];
    NSString *str = [NSString stringWithFormat:@"%@",[billProduct.shippedFlag integerValue] == 0 ? @"未完成":@"已完成"];
    [attributeStr1 appendAttributedString:[IBTCommon setTextViewFontOfString:str paragraphStyle:0 fontSize:13 color:[UIColor redColor]]];
    self.showShippedFlag.attributedText = attributeStr1;

    self.showShippedBaseQty.text = [NSString stringWithFormat:@"发运包装数量：%@",[billProduct.shippedBaseQty stringValue]];
    self.showShippedQty.text = [NSString stringWithFormat:@"发运基础数量：%@",[billProduct.shippedQty stringValue]];
    [self.showView addSubview:self.showShippedFlag];
    [self.showView addSubview:self.showShippedQty];
    [self.showView addSubview:self.showShippedBaseQty];
}

- (void)awakeFromNib {
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
}

@end
