//
//  ShopDetaileViewController.m
//  XFFruit
//
//  Created by mac on 15/8/19.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ShopDetaileViewController.h"
#import "SurveyCell.h"
#import "HPGrowingTextView.h"
#import "StartTimeView.h"
#import "ChosePersonViewController.h"
#import "ChooseProductViewController.h"
#import "SelectCompanyViewController.h"
#import "SurveyUser.h"
#import "Survey.h"
#import "Product.h"
#define LeftMargin 15
#define BtnHeight 44
#define TableHeight 46
#define CornerRadius 5
#define TitleSize 15
#define BtnSize 19
#define TotalHeight 432
#define KeyboardHeight 258
#define DateViewHeight 300
typedef enum : NSUInteger {
    SaveTag = 2000,
    CommitTag,
} BtnTag;
@interface ShopDetaileViewController ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate,StartTimeViewDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    UITextField *_titleField;
    UILabel *_productLabel;
    UILabel *_PackagingLable;
    UILabel *_startDateLabel;
    UILabel *_endDateLabel;
    UILabel *_personLabel;
    HPGrowingTextView *_noteTextView;
    UIDatePicker *_timePicker;
    BOOL _isClickStart;
    StartTimeView *_startTimeView;
    
    UITextField *merchandise;         //商品
    UITextField *packageSpecification;//包装规格
    UITextField *packageQuantity;     //包装数量
    UITextField *packageUnit;         //包装单位
    UITextField *foundationQuantity;  //基础数量
    UITextField *foundationUnitPrice; //基础单价
    UITextField *packageUnitPrice;    //包装单价
    UITextField *totalMoney;          //总金额
    UITextField *remark;              //备注
}
@property (nonatomic,strong)NSString *titleStr;
@property (nonatomic,strong)NSString *productCodeStr;
@property (nonatomic,strong)NSString *productNameStr;
@property (nonatomic,strong)NSString *productUuidStr;
@property (nonatomic,strong)NSString *beginDateStr;
@property (nonatomic,strong)NSString *endDateStr;
@property (nonatomic,strong)NSString *remarkStr;
@property (nonatomic,strong)NSMutableArray *users;
@end

@implementation ShopDetaileViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = self.navTitle;
    [self initData];
    [self setupSubviews];
       // Do any additional setup after loading the view.
}
- (void)initData{
    merchandise=[[UITextField alloc]init];
    packageUnit=[[UITextField alloc]init];
    merchandise.text=packageUnit.text=NULL;
    _dataArr = [NSMutableArray array];
    self.users = [NSMutableArray array];
    [_dataArr addObject:@"商品"];
    [_dataArr addObject:@"包装规格"];
    [_dataArr addObject:@"包装数量"];
    [_dataArr addObject:@"包装单位"];
    [_dataArr addObject:@"基础数量"];
    [_dataArr addObject:@"基础单价"];
    [_dataArr addObject:@"包装单价"];
    [_dataArr addObject:@"总金额"];
    [_dataArr addObject:@"备注"];
    
}

-(void)setupSubviews
{
    //    self.view.backgroundColor  = XXFBgColor;
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, 0,ScreenSize.width, ScreenSize.height - 64 - LeftMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 50)];
    
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 10, (ScreenSize.width - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"删除" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:GXF_SAVE_COLOR];
    [footView addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(saveBtn.frame.origin.x + saveBtn.frame.size.width + LeftMargin, 10, (ScreenSize.width - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:CommitTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:GXF_COMMIT_COLOR];
    [footView addSubview:commitBtn];
    
    //    [self.view addSubview:footView];
    _tableView.tableFooterView = footView;
    [self.view addSubview:_tableView];
    
}
- (void)setviewsData
{
    if (self.shopDetail!=nil) {
       
       _productLabel.text=self.shopDetail.merchandise;//商品
        merchandise.text=self.shopDetail.merchandise;
       
        packageUnit.text=self.shopDetail.packageUnit;
        _PackagingLable.text=self.shopDetail.packageUnit;//包装单位
        packageSpecification.text=self.shopDetail.packageSpecification;//包装规格
        packageQuantity.text=self.shopDetail.packageQuantity;     //包装数量
       
        foundationQuantity.text=self.shopDetail.foundationQuantity;  //基础数量
        foundationUnitPrice.text=self.shopDetail.foundationUnitPrice; //基础单价
        packageUnitPrice.text=self.shopDetail.packageUnitPrice;    //包装单价
    totalMoney.text=self.shopDetail.totalMoney;          //总金额
        remark.text=self.shopDetail.remark;
        _productLabel.textColor=GXF_CONTENT_COLOR;
         _PackagingLable.textColor=GXF_CONTENT_COLOR;
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
#pragma mark - 按钮点击事件
- (void)btnClick:(UIButton *)btn{
    switch (btn.tag) {
        case SaveTag://删除
        {
            if (self.shopDetail!=nil) {
                ShopDetail *shopDetail=self.shopDetail;

                if (shopDetail.IsXiuGai==YES) {
                    shopDetail.IsDeleted=YES;
                    self.choseShopDetail(shopDetail);//回调
                    [self PopViewControllerAnimated:YES];
                }else
                {
                    [self  clearShopDetail];
                }
               

            }else
            {
                 [self  clearShopDetail];
            }
            //            if ([self checkSurvey]) {
            //                [self saveSurvey:@"initial" message:@"正在保存..."];
            //            }
        }
            break;
        case CommitTag:
        {
            if ([self informationComplete]) {
                ShopDetail *shopDetail=self.shopDetail;
                shopDetail.IsDeleted=NO;
                self.choseShopDetail(shopDetail);//回调
                [self PopViewControllerAnimated:YES];
                //                [self saveSurvey:@"submitted" message:@"正在提交..."];
            }
        }
            break;
        default:
            break;
    }
}
- (void)clearShopDetail
{
    _productLabel.text=@"选择商品";//商品
    merchandise.text=@"";
    
    packageUnit.text=@"";
    _PackagingLable.text=@"选择包装单位";//包装单位
    packageSpecification.text=@"";//包装规格
    packageQuantity.text=@"";     //包装数量
    
    foundationQuantity.text=@"";  //基础数量
    foundationUnitPrice.text=@""; //基础单价
    packageUnitPrice.text=@"";    //包装单价
    totalMoney.text=@"";          //总金额
    remark.text=@"";
    _productLabel.textColor=GXF_PLACEHOLDER_COLOR;
    _PackagingLable.textColor=GXF_PLACEHOLDER_COLOR;
}
- (BOOL)informationComplete{
    self.shopDetail=[[ShopDetail alloc]init];
    self.shopDetail.merchandise=merchandise.text;
    self.shopDetail.packageSpecification=packageSpecification.text;
    self.shopDetail.packageQuantity=packageQuantity.text;
    self.shopDetail.packageUnit=packageUnit.text;
    self.shopDetail.foundationQuantity=foundationQuantity.text;
    self.shopDetail.foundationUnitPrice=foundationUnitPrice.text;
    self.shopDetail.packageUnitPrice=packageUnitPrice.text;
    self.shopDetail.totalMoney=totalMoney.text;
    self.shopDetail.remark=remark.text;
    self.shopDetail.product_code = self.productCodeStr;
    self.shopDetail.product_uuid = self.productUuidStr;
    if (merchandise.text.length == 0 ) {
        ShowMessage(@"商品不能为空");
        return NO;
    }
    if (packageSpecification.text.length == 0 ) {
        ShowMessage(@"包装规格不能为空");
        return NO;
    }
    if (packageQuantity.text.length == 0 ) {
        ShowMessage(@"包装数量不能为空");
        return NO;
    }
    if (packageUnit.text.length == 0) {
        ShowMessage(@"包装单位不能为空");
        return NO;
    }
    if (foundationQuantity.text.length == 0) {
        ShowMessage(@"基础数量不能为空");
        return NO;
    }
    if (foundationUnitPrice.text.length == 0) {
        ShowMessage(@"基础单价不能为空");
        return NO;
    }if (packageUnitPrice.text.length == 0) {
        ShowMessage(@"总金额不能为空");
        return NO;
    }
    if (remark.text.length == 0) {
        ShowMessage(@"备注不能为空");
        return NO;
    }
    return YES;
    
}


#pragma mark - 保存
- (void)saveSurvey:(NSString *)state message:(NSString *)msg
{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                //成功
                [IBTLoadingView showTips:@"操作成功"];
                [self clearAllInformation];
                if (self.survey) {
                    [ICRUserUtil sharedInstance].needFresh = YES;
                    [self.navigationController popViewControllerAnimated:YES];
                }
            }else{
                [IBTLoadingView showTips:message];
            }
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    id uuidObject = [NSNull null];
    if(self.survey.uuid.length > 0){
        uuidObject = self.survey.uuid;
    }
    id billNumberObject = [NSNull null];
    if (self.survey.billNumber > 0) {
        billNumberObject = self.survey.billNumber;
    }
    NSNumber *version = [NSNumber numberWithLong:0];
    if (self.survey) {
        version = self.survey.version;
    }
    NSDictionary *dict = @{@"uuid":uuidObject,
                           @"version":version,
                           @"billnumber":billNumberObject,
                           @"title":[IBTCommon checkString:self.titleStr],
                           @"state":state,
                           @"productUuid":[IBTCommon checkString:self.productUuidStr],
                           @"productCode":[IBTCommon checkString:self.productCodeStr],
                           @"productName":[IBTCommon checkString:self.productNameStr],
                           @"beginDate":[IBTCommon checkString:self.beginDateStr],
                           @"endDate":[IBTCommon checkString:self.endDateStr],
                           @"remark":[IBTCommon checkString:self.remarkStr],
                           @"users":self.users};
    [IBTLoadingView showProgressLabel:msg];
    [[ICRHTTPController sharedController] saveSurveyWithAuthenticode:dict success:succ failure:fail];
}

- (void)clearAllInformation{
    _titleField.text = @"";
    _productLabel.text = @"请输入商品";
    _productLabel.textColor = GXF_PLACEHOLDER_COLOR;
    _startDateLabel.text = @"选择日期";
    _startDateLabel.textColor = GXF_PLACEHOLDER_COLOR;
    _endDateLabel.text = @"选择日期";
    _endDateLabel.textColor = GXF_PLACEHOLDER_COLOR;
    _personLabel.text = @"选择调研人员";
    _personLabel.textColor = GXF_PLACEHOLDER_COLOR;
    _noteTextView.text =  @"";
    //清空数据
    self.titleStr = @"";
    self.productCodeStr = @"";
    self.productNameStr = @"";
    self.productUuidStr = @"";
    self.beginDateStr = @"";
    self.endDateStr = @"";
    [self.users removeAllObjects];
    self.remarkStr = @"";
}





#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    //    if (indexPath.row == 0){
    //        return TableHeight*2;
    //    }else{
    return TableHeight;
    //    }
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row==0||indexPath.row==3) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}

-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0||indexPath.row==3) {
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_PLACEHOLDER_COLOR;
        contentLabel.font = FontSize(TitleSize);
        [cell.contentView addSubview:contentLabel];
        if (indexPath.row==0) {
            _productLabel = contentLabel;
            contentLabel.text = @"选择商品";
            [self preferDataInProductLabel];
        }else if (indexPath.row==3)
        {
            _PackagingLable = contentLabel;
            contentLabel.text = @"选择包装单位";
            [self preferDataInProductLabel];
        }
        
    }else
    {
        _titleField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight)];
        _titleField.textAlignment = NSTextAlignmentRight;
        _titleField.textColor = GXF_CONTENT_COLOR;
        _titleField.placeholder = @"输入调研标题";
        _titleField.font = FontSize(15);
        _titleField.returnKeyType = UIReturnKeyDone;
        _titleField.delegate = self;
        [cell.contentView addSubview:_titleField];
        if (indexPath.row==1) {
            packageSpecification=_titleField;//包装规格
            _titleField.placeholder = @"输入包装规格";
        }else if (indexPath.row==2)
        {
            packageQuantity=_titleField;     //包装数量
            _titleField.placeholder = @"输入包装数量";
        }else if (indexPath.row==4)
        {
            foundationQuantity=_titleField;  //基础数量
            _titleField.placeholder = @"输入基础数量";
        }else if (indexPath.row==5)
        {
            foundationUnitPrice=_titleField; //基础单价
            _titleField.placeholder = @"输入基础单价";
        }else if (indexPath.row==6)
        {
            packageUnitPrice=_titleField;    //包装单价
            _titleField.placeholder = @"输入包装单价";
        }else if (indexPath.row==7)
        {
            totalMoney=_titleField;          //总金额
            _titleField.placeholder = @"输入总金额";
        }else if (indexPath.row==8)
        {
            remark=_titleField;              //备注
            _titleField.placeholder = @"输入备注内容";
        }
        
        
    }
     [self  setviewsData];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    
    if(indexPath.row == 0){
        ChooseProductViewController *cvc = [ChooseProductViewController new];
        cvc.choseBaseInfo = ^(NSArray  *products){
            Product *product=products [0];
            _productLabel.text = [NSString stringWithFormat:@"%@[%@]",product.name,product.code];
            merchandise.text=[NSString stringWithFormat:@"%@[%@]",product.name,product.code];
            _productLabel.textColor = GXF_CONTENT_COLOR;
            self.productNameStr = product.name;
            self.productUuidStr = product.uuid;
            self.productCodeStr = product.code;
        };
        cvc.isMoreChose = NO;
        [self PushViewController:cvc animated:YES];
    }else if (indexPath.row ==3)
    {
        SelectCompanyViewController *vc=[SelectCompanyViewController new];
        vc.chosePackaging = ^(NSString *Packaging){
            
            _PackagingLable.text = [NSString stringWithFormat:@"%@",Packaging];
            packageUnit.text=[NSString stringWithFormat:@"%@",Packaging];
            _PackagingLable.textColor = GXF_CONTENT_COLOR;
            
        };
        
        
        [self PushViewController:vc animated:YES];
        
    }
}

- (void)preferDataInPersonLabel{
    if (self.survey) {
        if (self.survey.users.count > 0) {
            NSString *personStr = @"";
            for (SurveyUser * surveyUser in self.survey.users) {
                if (personStr.length == 0) {
                    personStr = [personStr stringByAppendingFormat:@"%@",surveyUser.userName];
                }else {
                    personStr = [personStr stringByAppendingFormat:@"、%@",surveyUser.userName];
                }
            }
            _personLabel.text = personStr;
            _personLabel.textColor = GXF_CONTENT_COLOR;
            
        }
        if (self.users > 0) {
            [self.users addObjectsFromArray:self.survey.users];
        }
    }
}
- (void)preferDataInProductLabel{
    if (self.survey) {
        _productLabel.text = [IBTCommon checkString:self.survey.productName];
        _productLabel.textColor = GXF_CONTENT_COLOR;
        self.productCodeStr = [IBTCommon checkString:self.survey.productCode];
        self.productNameStr = [IBTCommon checkString:self.survey.productName];
        self.productUuidStr = [IBTCommon checkString:self.survey.productUuid];
    }
}


- (void)startDatePickView{
    if (!_startTimeView) {
        _startTimeView = [[StartTimeView alloc] initWithFrame:CGRectMake(0, ScreenSize.height, ScreenSize.width, ScreenSize.height - 64)];
        _startTimeView.delegate = self;
        _startTimeView.backgroundColor        = RGBA(0, 0, 0 ,0.5);
        [self.view addSubview:_startTimeView];
        
        [UIView animateWithDuration:0.15 animations:^{
            CGRect startFrame =  _startTimeView.frame;
            startFrame.origin.y =  0;
            _startTimeView.frame = startFrame;
        } completion:^(BOOL finished) {
            
        }];
    }
}

- (void)cancelTimeView{
    [self clearDatePickView];
}
- (void)okTimeView:(NSDate *)time{
    if (_isClickStart) {
        _startDateLabel.textColor = GXF_CONTENT_COLOR;
        _startDateLabel.text = [IBTCommon stringFromDate:time];
        self.beginDateStr = [time httpParameterString];
    }else{
        _endDateLabel.textColor = GXF_CONTENT_COLOR;
        _endDateLabel.text = [IBTCommon stringFromDate:time];
        self.endDateStr = [time httpParameterString];
    }
    // 关闭选择器
    [self clearDatePickView];
}
#pragma mark - 取消
- (void)clearDatePickView{
    [UIView animateWithDuration:0.15 animations:^{
        CGRect startFrame =  _startTimeView.frame;
        startFrame.origin.y = ScreenSize.height;
        _startTimeView.frame = startFrame;
    } completion:^(BOOL finished) {
        [_startTimeView removeFromSuperview];
        _startTimeView = nil;
    }];
}






#pragma mark delegate
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [_noteTextView resignFirstResponder];
    [self setTableFrame:LeftMargin];
    return YES;
}
- (void)growingTextViewDidBeginEditing:(HPGrowingTextView *)growingTextView{
    CGFloat offset = ScreenSize.height - TotalHeight - KeyboardHeight;
    if (offset < 0) {//上移
        [self setTableFrame:LeftMargin+offset];
    }
}
- (void)setTableFrame:(CGFloat)tabelH{
    [UIView animateWithDuration:0.25 animations:^{
        CGRect tableFrame = _tableView.frame;
        tableFrame.origin.y = tabelH;
        _tableView.frame = tableFrame;
    }];
}

- (void)keyboardHidden{
    [_titleField resignFirstResponder];
    [_noteTextView resignFirstResponder];
    [self setTableFrame:LeftMargin];
}

- (void)viewWillDisappear:(BOOL)animated{
    [super viewWillDisappear:animated];
    
}

/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */

@end
