//
//  GXFFunctionsViewController.m
//  XFFruit
//
//  Created by freecui on 15/8/27.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//


#import "GXFFunctionsViewController.h"
#import "GXFDisplayFunction.h"
#import "GXFFunction.h"
#import "GXFFunctionDBHelper.h"
#import "GXFFunctionDB.h"
@interface GXFFunctionsViewController ()<UITableViewDataSource,UITableViewDelegate>

//@property (nonatomic, strong) NSArray *
@property (nonatomic, strong) UITableView *f_tableView;
@property (nonatomic, strong) NSArray *firstSectionArr;
@property (nonatomic, strong) NSArray *secondSectionArr;

@end

@implementation GXFFunctionsViewController
static NSString *cellID = @"cell";

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initData];
    [self setupSubViews];
}
- (void)initData {
    NSUserDefaults *f_default = [NSUserDefaults standardUserDefaults];
    BOOL noDefault = [[f_default objectForKey:@"noDefault"] integerValue] > 0 ? YES : NO;
    if (!noDefault) {
        self.secondSectionArr = [[GXFFunctionDB sharedInstance]defaultdisplayFunctions];
    } else {
            self.secondSectionArr = [[GXFFunctionDB sharedInstance]originDisplayFunctions];
    }
    NSDictionary *dictOne = @{@"Id":@(1),@"functionName":@"新建行情反馈",@"imgName":@"RefreshBtn",@"isSelected":@(0)};
        NSDictionary *dictTwo = @{@"Id":@(2),@"functionName":@"查询行情反馈",@"imgName":@"RefreshBtn",@"isSelected":@(1)};
    GXFDisplayFunction *dFuntionOne = [[GXFDisplayFunction alloc]initWithDictionary:dictOne];
    GXFDisplayFunction *dFuntionTwo =[[GXFDisplayFunction alloc]initWithDictionary:dictTwo];
    self.firstSectionArr = @[dFuntionOne,dFuntionTwo];
//@[dFuntionOne,dFuntionTwo];
}
- (void)setupSubViews {
    [self setupRightBarBtn];
    [self setupTableView];
}
- (void)setupRightBarBtn {
    UIBarButtonItem *rightBarBtn =  [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(selectedFunctions)];
    self.navigationItem.rightBarButtonItem = rightBarBtn;
}
- (void)setupTableView {
    self.f_tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, self.view.width, self.view.height - 64) style:UITableViewStyleGrouped];
    self.f_tableView.dataSource = self;
    self.f_tableView.delegate = self;
    //[self.f_tableView dequeueReusableCellWithIdentifier ]
    [self.view addSubview:_f_tableView];
    [_f_tableView reloadData];
}



#pragma BarButton Action
- (void)selectedFunctions {
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_changeIsSelectedFunctions object:nil];

    //配置功能 不是默认配置
    NSUserDefaults *f_default = [NSUserDefaults standardUserDefaults];
    BOOL noDefault = [[f_default objectForKey:@"noDefault"] integerValue] > 0 ? YES : NO;
    if (!noDefault) {
        [f_default setObject:@(1) forKey:@"noDefault"];
    }
    
    [self PopViewControllerAnimated:YES];
    
    
}


#pragma UITablewViewDataSource 
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 2;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if (section == 0) {
        return _firstSectionArr.count;
    } else {
        return _secondSectionArr.count;
    }
    
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    //TableViewCell重用机制避免重复显示问题  它的子视图全部删除
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (!cell) {
        cell = [[UITableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
    } else {
        while ([cell.contentView.subviews lastObject] != nil) {
            [(UIView *)[cell.contentView.subviews lastObject] removeFromSuperview];
        }
    }
    
    [self p_contentToTableViewCell:cell ForRowAtIndexPath:indexPath];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    
    return cell;
}

- (NSString *)tableView:(UITableView *)tableView titleForDeleteConfirmationButtonForRowAtIndexPath:(NSIndexPath *)indexPath {
    NSString *sectionTitle = [NSString string];
    switch (indexPath.section) {
        case 0:
        {
            sectionTitle = @"提示选择";
        }
            break;
        case 1:
        {
            sectionTitle = @"功能选择";
        }
            break;
    }
    
    return sectionTitle;
}
#pragma UITableViewDelegate 
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
        switch (indexPath.section) {
        case 0:
        {
            
        }
            break;
        case 1:
        {
            GXFDisplayFunction *displayFunction = (GXFDisplayFunction *)_secondSectionArr[indexPath.row];
            UITableViewCell *cell = [_f_tableView  cellForRowAtIndexPath:indexPath];
            if (cell.accessoryType == UITableViewCellAccessoryNone) {
                cell.accessoryType = UITableViewCellAccessoryCheckmark;
                displayFunction.isSelected = YES;

            } else {
                cell.accessoryType = UITableViewCellAccessoryNone;
                 displayFunction.isSelected = NO;
            }
            
            [[GXFFunctionDB sharedInstance] updateDisplayFunctionIsSelectedWithId:displayFunction];
            
        }
            break;
    }

}

#pragma 给cell的内容赋值
- (void)p_contentToTableViewCell: (UITableViewCell *)cell ForRowAtIndexPath:(NSIndexPath *)indexPath  {
    switch (indexPath.section) {
        case 0:
        {
            GXFDisplayFunction *dFunction = (GXFDisplayFunction *)_firstSectionArr[indexPath.row];
            cell.imageView.image = [UIImage imageNamed:@"RefreshBtn"];//dFunction.functionImgName];
            cell.textLabel.text = dFunction.functionName;

            
        }
            break;
        case 1:
        {
            GXFDisplayFunction *dFunction = (GXFDisplayFunction *)_secondSectionArr[indexPath.row];
            cell.imageView.image = [UIImage imageNamed:@"RefreshBtn"];//dFunction.functionImgName];
            cell.textLabel.text = dFunction.functionName;
            if (dFunction.isSelected) {
                cell.accessoryType =  UITableViewCellAccessoryCheckmark;
            } else {
                cell.accessoryType = UITableViewCellAccessoryNone;
            }
        }
            break;
        default:
            break;
    }


}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
