//
//  PassgerPriceViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "PassgerPriceViewController.h"
#import "PasengerCell.h"
#import "PassengerHeaderCell.h"
#import "RPassgerView.h"
#import "ReportDetailViewController.h"
#define LeftWidth   50

static NSString *passgerPriceHeaderIdentify = @"PassgerPriceHeaderIdentify";


@interface PassgerPriceViewController ()<UITableViewDataSource,UITableViewDelegate>

@property (nonatomic,strong)RPassgerView *rpassgerView;


@end

@implementation PassgerPriceViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self bulidLayout];
}


#pragma mark - 布局
- (void)bulidLayout{
    self.view .backgroundColor = [UIColor whiteColor];
    
    CGRect rect = CGRectMake(0, 0, ScreenSize.width, 145);
    self.rpassgerView = [[RPassgerView alloc]initWithFrame:rect withPage:2];
    self.rpassgerView.bgImage.image = [UIImage imageNamed:@"salebg_3"];
    self.rpassgerView.cenImage.image = [UIImage imageNamed:@"sale_3"];

    [self.view addSubview:self.rpassgerView];

    
    rect = CGRectMake(0,0, self.view.width, self.view.height- 158);
    self.tableView = [[UITableView alloc]initWithFrame:rect style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.tableView registerClass:[PassengerHeaderCell class] forHeaderFooterViewReuseIdentifier:passgerPriceHeaderIdentify];
    self.tableView.tableHeaderView = self.rpassgerView;
    
    [self.view addSubview:self.tableView];
    
}
- (void)setValueInPassgerPrice:(id)compass{
    [self.rpassgerView setPersalesWithCompass:compass];
}

#pragma mark - tableViewDelegate
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    static NSString *passgerPriceCellIdentify = @"PassgerPriceCellIdentify";

    PasengerCell *cell = [tableView dequeueReusableCellWithIdentifier:passgerPriceCellIdentify];
    
    if(cell == nil) {
        cell = [[PasengerCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:passgerPriceCellIdentify];
    }
    //没有选中风格
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    //取消分割线
    tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    

    Compass *test = _dataArr[indexPath.row];
    [cell setColorAndFont:test.level];
    if(test != nil) {
        [cell updateCellWithPrice:test index:indexPath];
    }
    cell.detailBtn.tag = indexPath.row;
    [cell.detailBtn addTarget:self action:@selector(detailClick:) forControlEvents:UIControlEventTouchUpInside];
    return cell;
}
- (void)detailClick:(UIButton *)btn{
    Compass *com = self.dataArr[btn.tag];
    NSObject *comObj = [NSNull null];
    if (com) {
        comObj = com;
    }
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_GoReportDetail object:nil userInfo:@{@"compass":comObj}];
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [PasengerCell cellHeight];
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    [[NSNotificationCenter defaultCenter]postNotificationName:KNOTIFICATION_GetNextDetailData object:nil userInfo:@{@"indexPath":indexPath}];
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    PassengerHeaderCell *headerView = [tableView dequeueReusableHeaderFooterViewWithIdentifier:passgerPriceHeaderIdentify];
    
    if (headerView == nil) {
        headerView = [[PassengerHeaderCell alloc] initWithReuseIdentifier:passgerPriceHeaderIdentify];
    }
    
    [headerView buildLayout:@"客单价"];
    [headerView setTotalValue:[NSString stringWithFormat:@"共%ld家",(long)self.count]];
    return headerView;
}


- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return [PassengerHeaderCell viewHeight];
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
