//
//  RSaleView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/13.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "RSaleView.h"
#import "SMPageControl.h"
#define LeftWidth   50
#define ImageSize 20
#define ContentHeight 25
#define CenImageSize 40

@interface RSaleView ()
@property (nonatomic,strong)UILabel *centerLabel;
@property (nonatomic,strong)UILabel *dateLabel;
@property (nonatomic,strong)UIButton *lastWeekLabel;
@property (nonatomic,strong)UIButton *lastYearLabel;
@property (nonatomic,strong)UILabel *rateLabel;
@property (nonatomic,strong)UILabel *averageLabel;
@property (nonatomic,strong)UIImageView *lastWeekImage;
@property (nonatomic,strong)UIImageView *lastYearImage;
@property (nonatomic,strong)SMPageControl *pageControl;
@property (nonatomic,assign)NSInteger currentPage;


@end



@implementation RSaleView

- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        [self bulidLayout];
        self.currentPage = 0;
    }
    return self;
}
- (instancetype)initWithFrame:(CGRect)frame withPage:(NSInteger)currentPage{
    self = [super initWithFrame:frame];
    if (self) {
        self.currentPage = currentPage;
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout{
    
    CGRect rect = CGRectMake(0, 0, self.width, self.height);
  
    self.bgImage = [[UIImageView alloc]initWithFrame:rect];
    [self addSubview:self.bgImage];
    
    rect = CGRectMake(self.width/4, 20, CenImageSize, CenImageSize);
    self.cenImage = [[UIImageView alloc]initWithFrame:rect];
    self.cenImage.contentMode = UIViewContentModeScaleAspectFit;
    [self addSubview:self.cenImage];
    
    
    rect = CGRectMake(self.cenImage.right+5, 20, ScreenSize.width - self.cenImage.right, ContentHeight);
    self.centerLabel = [[UILabel alloc]initWithFrame:rect];
    self.centerLabel.textColor = ReportContentColor;
    self.centerLabel.font = FontSize(28);
    [self addSubview:self.centerLabel];

    
    rect = CGRectMake(self.centerLabel.left, self.centerLabel.bottom,self.width-self.centerLabel.left, ContentHeight);
    self.dateLabel = [[UILabel alloc]initWithFrame:rect];
    self.dateLabel.textColor = [UIColor lightGrayColor];
    self.dateLabel.font =  GXF_THREETEENTH_SIZE;
    self.dateLabel.textAlignment = NSTextAlignmentLeft;
    [self addSubview:self.dateLabel];
    
    CGFloat bottomWidth = (ScreenSize.width - 20)/4;
    
    rect = CGRectMake(10, self.dateLabel.bottom + 5,bottomWidth, ContentHeight);
    self.lastWeekLabel = [IBTCommon buttonWithTitle:@"" Image:nil frame:rect fontSize:15 fontColor:ReportContentColor];
    [self addSubview:self.lastWeekLabel];
    
    rect = CGRectMake(self.lastWeekLabel.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *weekLabel = [[UILabel alloc]initWithFrame:rect];
    weekLabel.textColor = [UIColor lightGrayColor];
    weekLabel.text = @"比上周同期";
    weekLabel.font = GXF_THREETEENTH_SIZE;
    weekLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:weekLabel];
    
    rect = CGRectMake(self.lastWeekLabel.right, self.lastWeekLabel.top,bottomWidth, ContentHeight);
     self.lastYearLabel = [IBTCommon buttonWithTitle:@"" Image:nil frame:rect fontSize:15 fontColor:GXF_NAVIGAYION_COLOR];
    [self addSubview:self.lastYearLabel];

    
    rect = CGRectMake(self.lastYearLabel.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *yearLabel = [[UILabel alloc]initWithFrame:rect];
    yearLabel.textColor = [UIColor lightGrayColor];
    yearLabel.text = @"比去年同期";
    yearLabel.font = GXF_THREETEENTH_SIZE;
    yearLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:yearLabel];
    
    rect = CGRectMake(self.lastYearLabel.right,self.lastWeekLabel.top,bottomWidth, ContentHeight);
    self.rateLabel = [[UILabel alloc]initWithFrame:rect];
    self.rateLabel.textColor = GXF_COMMIT_COLOR;
    self.rateLabel.font =  GXF_FIFTEENTEN_SIZE;

    self.rateLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:self.rateLabel];
    
    rect = CGRectMake(self.rateLabel.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *raLabel = [[UILabel alloc]initWithFrame:rect];
    raLabel.textColor = [UIColor lightGrayColor];
    raLabel.text = @"销售达成率";
    raLabel.font = GXF_THREETEENTH_SIZE;
    raLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:raLabel];
    
    rect = CGRectMake(self.rateLabel.right, self.lastWeekLabel.top,bottomWidth, ContentHeight);
    self.averageLabel = [[UILabel alloc]initWithFrame:rect];
    self.averageLabel.textColor = GXF_COMMIT_COLOR;
    self.averageLabel.font =  GXF_FIFTEENTEN_SIZE;

    self.averageLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:self.averageLabel];
    
    rect = CGRectMake(self.averageLabel.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *avLabel = [[UILabel alloc]initWithFrame:rect];
    avLabel.textColor = [UIColor lightGrayColor];
    avLabel.text = @"单店日均";
    avLabel.font = GXF_THREETEENTH_SIZE;
    avLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:avLabel];
    
    self.pageControl = [[SMPageControl alloc]initWithFrame:CGRectMake(0, avLabel.bottom+5, ScreenSize.width, 10)];
    self.pageControl.numberOfPages = 4;
    self.pageControl.currentPage = self.currentPage;
    self.pageControl.pageIndicatorImage = [UIImage imageNamed:@"white_point"];
    self.pageControl.currentPageIndicatorImage = [UIImage imageNamed:@"yellow_point"];
    self.pageControl.indicatorMargin = 5.0f;
    self.pageControl.indicatorDiameter = 10.0f;
    [self addSubview:self.pageControl];
}

- (void)setValueInSaleView:(Compass *)compass{
    //统计时间
//    compass.dataScope = @"2015-01";
    NSString *weekday = @"";
    if ([IBTCommon convertToDateFrom:compass.dataScope]) {
        weekday = [IBTCommon weekdayStringFromDate:[IBTCommon convertToDateFrom:compass.dataScope]];
    }
   
    self.dateLabel.text = [NSString stringWithFormat:@"%@%@累计销售额",compass.dataScope?compass.dataScope:@"无",weekday];
    //销售额
     self.centerLabel.text = compass.sales?[compass.sales stringValue]:@"0" ;

    //销售环比变化率
    if ([compass.salesChainSign isEqualToString:ReportChainSignPlus]) {
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateNormal];
        [self.lastWeekLabel setTitleColor:ReportContentColor forState:UIControlStateNormal];
    }else{
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateNormal];
        [self.lastWeekLabel setTitleColor:GXF_SAVE_COLOR forState:UIControlStateNormal];
    }
    NSString *salesChainRateStr = [NSString stringWithFormat:@"%@%%",compass.salesChainRate?compass.salesChainRate:@"0"];
    [self.lastWeekLabel setTitle:salesChainRateStr forState:UIControlStateNormal];
    //销售同比变化率
    if ([compass.salesYoYSign isEqualToString:ReportChainSignPlus]) {
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateNormal];
         [self.lastYearLabel setTitleColor:ReportContentColor forState:UIControlStateNormal];
    }else{
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateNormal];
         [self.lastYearLabel setTitleColor:GXF_SAVE_COLOR forState:UIControlStateNormal];
    }
    NSString *salesYoStr = [NSString stringWithFormat:@"%@%%",compass.salesYoYRate?compass.salesYoYRate:@"0"];
    [self.lastYearLabel setTitle:salesYoStr forState:UIControlStateNormal];
    //销售目标达成率
    NSString *salesTargetStr = [NSString stringWithFormat:@"%@%%",compass.salesTargetRate?compass.salesTargetRate:@"0"];
    self.rateLabel.text = salesTargetStr;
    //单店日均销售
    NSString *dailysalesPerStr = [NSString stringWithFormat:@"%@%%",compass.dailysalesPerStore?compass.dailysalesPerStore:@"0"];
    self.averageLabel.text = dailysalesPerStr;
    
}

@end
