//
//  RsearchCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/17.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "RsearchCell.h"
#define LeftMargin 10
@implementation RsearchCell

+ (CGFloat)cellHeight{
    return 50;
}

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin*2, 44))];
    self.titleLabel.textAlignment= NSTextAlignmentLeft;
    self.titleLabel.textColor = ReportColor;
    self.titleLabel.text = @"2222";
    self.titleLabel.font = GXF_FIFTEENTEN_SIZE;
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, 44-1, ScreenSize.width - LeftMargin * 2, 1))];
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.lineLabel];
}

- (void)setvalueWithLowerOrgs:(LowerOrgs *)orgs{
    self.titleLabel.text = [NSString stringWithFormat:@"%@%@",orgs.code,orgs.name];
}

- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
