//
//  SaleHeaderView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "SaleHeaderView.h"

#define Sale_Header_Height 35

@interface SaleHeaderView ()
{
    BOOL    hasBuildLayout;         // default, NO;
}

@property (nonatomic, strong) UILabel *label;
@property (nonatomic, strong) UIFont *textFont;

@end


@implementation SaleHeaderView


+ (CGFloat)viewHeight
{
    return Sale_Header_Height;
}

- (void)buildLayout
{
    if(hasBuildLayout) {
        return;
    }
    
    if(self.textFont == nil) {
        self.textFont = [UIFont systemFontOfSize:13];
    }
    
    hasBuildLayout = YES;
    self.contentView.backgroundColor = XXFBgColor;
    CGRect rect = CGRectMake(0, 0, ScreenSize.width, 1);
    UILabel *lineLabel = [[UILabel alloc]initWithFrame:rect];
    lineLabel.backgroundColor = GXF_LINE_COLOR;
    [self.contentView addSubview:lineLabel];
    
    
    rect = CGRectMake(10, 0, 105, Sale_Header_Height);
    UILabel *searLabel = [IBTCommon labelWithTitle:@"共280家" frame:rect textFont:self.textFont];
    searLabel.textColor = ReportTitleColor;
    [self.contentView addSubview:searLabel];
    self.totalLabel = searLabel;
    
    CGFloat width = (ScreenSize.width  - searLabel.right - 35)/3;

    rect = CGRectMake(searLabel.right, 0, width + 10, Sale_Header_Height);
    UILabel * xsBtn = [IBTCommon labelWithTitle:@"销售额" frame:rect textFont:self.textFont];
    xsBtn.textColor = ReportTitleColor;
    xsBtn.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:xsBtn];
    
    rect = CGRectMake(xsBtn.right , 0, width, Sale_Header_Height);
    UILabel * bszLabel = [IBTCommon labelWithTitle:@"比上周" frame:rect textFont:self.textFont];
    bszLabel.textColor = ReportTitleColor;
    bszLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:bszLabel];
    
    rect = CGRectMake(bszLabel.right , 0, width-10, Sale_Header_Height);
    UILabel * sclLabel = [IBTCommon labelWithTitle:@"达成率" frame:rect textFont:self.textFont];
    sclLabel.textColor = ReportTitleColor;
    sclLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:sclLabel];
    
    rect = CGRectMake(0, Sale_Header_Height-1, ScreenSize.width, 1);
    UILabel *lineTLabel = [[UILabel alloc]initWithFrame:rect];
    lineTLabel.backgroundColor = GXF_LINE_COLOR;
    [self.contentView addSubview:lineTLabel];
   
}

@end
