//
//  SaleViewCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "SaleViewCell.h"

#define Sale_Cell_Height  50
#define Left_Width 110
#define Left_margin 5
@interface SaleViewCell ()
{
    BOOL    hasBuildLayout;         // default, NO;
}

@property (nonatomic, strong) UIFont *textFont;
@property (nonatomic, strong) UIFont *titleFont;

@property (nonatomic, strong) NSIndexPath *indexPath;

@end


@implementation SaleViewCell


+ (CGFloat)cellHeight
{
    return Sale_Cell_Height;
}

#pragma mark - build view

- (void)buildLayout
{
    if(hasBuildLayout) {
        return;
    }
    
    hasBuildLayout = YES;
    
    
    if(self.textFont == nil) {
        self.textFont = [UIFont systemFontOfSize:15];
    }
    
    if(self.titleFont == nil) {
        self.titleFont = [UIFont systemFontOfSize:17];
    }
    
    //页面布局
    [self createView];
}

//创建视图
- (void)createView
{

    CGRect rect = CGRectMake(Left_margin,5, Left_Width, Sale_Cell_Height/2);
    self.nameLabel = [IBTCommon labelWithTitle:@"第一片区" frame:rect textFont:self.textFont];
    [self.contentView addSubview:self.nameLabel];
    
    rect = CGRectMake(Left_margin,self.nameLabel.bottom, Left_Width, Sale_Cell_Height/2-10);
    
    self.dqLabel = [IBTCommon labelWithTitle:@"0101" frame:rect textFont:self.textFont];
    [self.contentView addSubview:self.dqLabel];
    
    CGFloat width = (ScreenSize.width - self.dqLabel.right - 35)/3;
    
    rect = CGRectMake(self.dqLabel.right , 0, width+10, Sale_Cell_Height);
    self.saleLabel = [IBTCommon labelWithTitle:@"56,080" frame:rect textFont:self.textFont];
    self.saleLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:self.saleLabel];
    
    rect = CGRectMake(self.saleLabel.right, 0, width, Sale_Cell_Height);
      self.lastWeekLabel = [IBTCommon buttonWithTitle:@"" Image:nil frame:rect fontSize:15 fontColor:ReportContentColor];
    self.lastWeekLabel.enabled = NO;
    [self.contentView addSubview:self.lastWeekLabel];
    
    rect = CGRectMake(self.lastWeekLabel.right, 0, width-10, Sale_Cell_Height);
    self.rateLabel = [IBTCommon labelWithTitle:@"60%" frame:rect textFont:self.textFont];
    self.rateLabel.textColor = GXF_COMMIT_COLOR;
    self.rateLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:self.rateLabel];

    rect = CGRectMake(self.rateLabel.right, 0, 35, Sale_Cell_Height);
    self.detailBtn = [IBTCommon buttonWithTitle:@"详" Image:nil frame:rect fontSize:20 fontColor:ReportBgColor];
    self.detailBtn.titleLabel.font = [UIFont boldSystemFontOfSize:15];
    [self.contentView addSubview:self.detailBtn];
    
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0, Sale_Cell_Height - 1, ScreenSize.width, 1))];
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    [self.contentView addSubview:self.lineLabel];
    
}


#pragma mark - update view

- (void)updateCellWith:(Compass *)sale index:(NSIndexPath *)indexPath
{
    self.indexPath = indexPath;
    
    [self buildLayout];
    //组织name
    self.dqLabel.text = sale.orgCode;
    self.nameLabel.text = sale.orgName;
    
    //销售环比变化率
    if ([sale.salesChainSign isEqualToString:ReportChainSignPlus]) {
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateDisabled];
        [self.lastWeekLabel setTitleColor:ReportContentColor forState:UIControlStateNormal];
        self.saleLabel.textColor = ReportContentColor;

    }else{
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateDisabled];
        [self.lastWeekLabel setTitleColor:GXF_NAVIGAYION_COLOR forState:UIControlStateNormal];
        self.saleLabel.textColor = GXF_NAVIGAYION_COLOR;
    }
    //销售额
    self.saleLabel.text = sale.sales?[sale.sales stringValue] : @"0";
    
    NSString *salesYoStr = [NSString stringWithFormat:@"%@%%",sale.salesChainRate];
    [self.lastWeekLabel setTitle:salesYoStr forState:UIControlStateNormal];
    //销售目标达成率
    NSString *salesTargetRateStr = [NSString stringWithFormat:@"%@%%",sale.salesTargetRate];
    self.rateLabel.text = salesTargetRateStr;
    [self setColorAndFont:sale.level];
}
- (void)setColorAndFont:(NSInteger)level{
    if (level == 0) {
        self.dqLabel.textColor = GXF_CONTENT_COLOR;
        self.nameLabel.textColor = GXF_CONTENT_COLOR;
        self.lineLabel.hidden = NO;
        [self setFontLabel:17];
        [self setWidthDQ:0];
        self.contentView.backgroundColor = [UIColor whiteColor];
    }else if (level == 1) {
        self.dqLabel.textColor = [UIColor blackColor];
        self.nameLabel.textColor = [UIColor blackColor];
        self.lineLabel.hidden = NO;
        [self setFontLabel:15];
        [self setWidthDQ:0];
        self.contentView.backgroundColor = [UIColor whiteColor];
    }else if(level == 2){
        self.lineLabel.hidden = NO;
        self.dqLabel.textColor = GXF_LEFTSIX_COLOR;
        self.nameLabel.textColor = GXF_LEFTSIX_COLOR;
        [self setWidthDQ:5];
        [self setFontLabel:13];
        self.contentView.backgroundColor = [UIColor whiteColor];
    }else {
        self.lineLabel.hidden = YES;
        self.dqLabel.textColor = ReportTwoColor;
        self.nameLabel.textColor = ReportTwoColor;
        [self setFontLabel:12];
         [self setWidthDQ:5];
        self.contentView.backgroundColor = XXFBgColor;
        
    }
}
- (void)setFontLabel:(NSInteger)fontSize{
    self.dqLabel.font = FontSize(fontSize-2);
    self.nameLabel.font = FontSize(fontSize);
    self.saleLabel.font = FontSize(fontSize);
    self.lastWeekLabel.titleLabel.font = FontSize(fontSize);
    self.rateLabel.font = FontSize(fontSize);
}
- (void)setWidthDQ:(NSInteger)width{
    self.lineLabel.left = width;
    self.lineLabel.width = ScreenSize.width - width;
    if (width > 0) {
        self.nameLabel.left = width + 5;
        self.nameLabel.width = ScreenSize.width - width - 5;
        self.dqLabel.left = width + 5;
        self.dqLabel.width = ScreenSize.width - width - 5;
    }else{
        self.nameLabel.left = 5;
        self.nameLabel.width = ScreenSize.width - 5;
        self.dqLabel.left = 5;
        self.dqLabel.width = ScreenSize.width - 5;
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
