//
//  ICRFunctionItemControl.m
//  XFFruit
//
//  Created by Lili Wang on 15/4/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#define ICRFUNCTION_IMG_TOP_PADDING   (25)
#define ICRFUNCTION_IMG_WIDTH         (65)
#define ICRFUNCTION_LABEL_HEIGHT      (15)
#define ICRFUNCTION_INNER_GAP         (7)
#define RIGHT_LINE_WIDTH              (0.5)

#import "ICRFunctionItemControl.h"

@interface ICRFunctionItemControl ()

@property(strong, nonatomic) UIImageView *m_rightLine;
@property(strong, nonatomic) UIImageView *m_bottomLine;

@end
@implementation ICRFunctionItemControl

#pragma mark - life Cycle
- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
        [self _init];
    }
    
    return self;
}

- (void)layoutSubviews {
    _functionImage.frame = (CGRect){
        .origin.x = (CGRectGetWidth(self.frame) - ICRFUNCTION_IMG_WIDTH)/2,
        .origin.y = ICRFUNCTION_IMG_TOP_PADDING,
        .size.width = ICRFUNCTION_IMG_WIDTH,
        .size.height = ICRFUNCTION_IMG_WIDTH
    };
    
    CGSize labelSize = CGSizeMake(CGRectGetWidth(self.frame), ICRFUNCTION_LABEL_HEIGHT);
    labelSize = [_functinNameLabel sizeThatFits:labelSize];
    _functinNameLabel.frame = (CGRect){
        .origin.x = (CGRectGetWidth(self.frame) - labelSize.width)/2,
        .origin.y = CGRectGetMaxY(_functionImage.frame) + ICRFUNCTION_INNER_GAP,
        .size.width = labelSize.width,
        .size.height = ICRFUNCTION_LABEL_HEIGHT
    };
    
    _m_rightLine.frame = (CGRect){
        .origin.x = CGRectGetWidth(self.frame) - RIGHT_LINE_WIDTH,
        .origin.y = 0,
        .size.width = RIGHT_LINE_WIDTH,
        .size.height = CGRectGetHeight(self.frame)
    };
                     
     _m_bottomLine.frame = (CGRect){
         .origin.x = 0,
         .origin.y = CGRectGetHeight(self.frame) - RIGHT_LINE_WIDTH,
         .size.width = CGRectGetWidth(self.frame),
         .size.height = RIGHT_LINE_WIDTH
    };
}

- (void)setHighlighted:(BOOL)highlighted{
    [super setHighlighted:highlighted];
    
    if (_highLightWhenTapped) {
        self.alpha = highlighted ? IBT_BIN_HIGHLIGHT_ALPHA : 1.0f;
    }
}

#pragma mark - Public Method
+ (ICRFunctionItemControl *)highLightControl {
    ICRFunctionItemControl *control = [[ICRFunctionItemControl alloc] init];
    control.highLightWhenTapped = YES;
    return control;
}

#pragma mark - Private Method
- (void)_init {
    self.functionImage = [[UIImageView alloc] init];
    _functionImage.layer.masksToBounds = YES;
    _functionImage.layer.cornerRadius = 65 * 0.5;
    _functionImage.backgroundColor = [UIColor clearColor];
    [self addSubview:_functionImage];
    
    self.functinNameLabel = [[UILabel alloc] init];
    _functinNameLabel.textColor = [UIColor colorWithRed:0.596f green:0.596f blue:0.596f alpha:1.00f];
    _functinNameLabel.textAlignment = NSTextAlignmentCenter;
    _functinNameLabel.font = [UIFont systemFontOfSize:13];
    [self addSubview:_functinNameLabel];
    
    self.m_rightLine = [[UIImageView alloc] init];
    _m_rightLine.backgroundColor = [UIColor colorWithRed:0.596f green:0.596f blue:0.596f alpha:1.00f];
    [self addSubview:_m_rightLine];
    
    self.m_bottomLine = [[UIImageView alloc] init];
    _m_bottomLine.backgroundColor = [UIColor colorWithRed:0.596f green:0.596f blue:0.596f alpha:1.00f];
    [self addSubview:_m_bottomLine];
}

@end
