//
//  PassengerViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "PassengerViewController.h"

#import "CustomSegView.h"
#import "SMPageControl.h"
#import "PasengerCell.h"
#import "PassengerHeaderCell.h"
#define LeftWidth   50

static NSString *passengerCellIdentify = @"PassengerCellIdentify";
static NSString *passengerHeaderIdentify = @"PassengerHeaderIdentify";


@interface PassengerViewController ()<CustomSegViewDelegate,UITableViewDataSource,UITableViewDelegate>
@property (nonatomic,strong)CustomSegView *segView;
@property (nonatomic,strong)SMPageControl *pageControl;

@property (nonatomic,strong)UIImageView *centerImage;
@property (nonatomic,strong)UILabel *centerLabel;
@property (nonatomic,strong)UILabel *dateLabel;
@property (nonatomic,strong)UILabel *lastWeekLabel;
@property (nonatomic,strong)UILabel *lastYearLabel;
@property (nonatomic,strong)UILabel *rateLabel;
@property (nonatomic,strong)UILabel *averageLabel;
@property (nonatomic,strong)UIImageView *lastWeekImage;
@property (nonatomic,strong)UIImageView *lastYearImage;

@property (nonatomic,strong)UITableView *tableView;
@property (nonatomic,strong)NSMutableArray *dataArr;
@end

@implementation PassengerViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self bulidLayout];
}


#pragma mark - 布局
- (void)bulidLayout{
    self.view .backgroundColor = [UIColor whiteColor];
    CGRect rect = CGRectMake(10, 10, ScreenSize.width - 10*2, 30);
    NSArray *arr = @[SaleDay,SaleWeek,SaleMonth];
    self.segView = [[CustomSegView alloc]initWithFrame:rect withArr:arr];
    self.segView.delegate = self;
    [self.view addSubview:self.segView];
    
    rect = CGRectMake(50, self.segView.bottom + 20, 30 , 30);
    self.centerImage = [[UIImageView alloc]initWithFrame:rect];
    self.centerImage.image = [UIImage imageNamed:@"goSale"];
    [self.view addSubview:self.centerImage];
    
    rect = CGRectMake(self.centerImage.right + 5, self.segView.bottom + 20, ScreenSize.width - self.centerImage.right, 30);
    self.centerLabel = [[UILabel alloc]initWithFrame:rect];
    self.centerLabel.text = @"1290人次";
    self.centerLabel.font = [UIFont boldSystemFontOfSize:30];
    self.centerLabel.textColor = [UIColor redColor];
    [self.view addSubview:self.centerLabel];

    
    rect = CGRectMake(0, self.centerLabel.bottom,ScreenSize.width, 20);
    self.dateLabel = [[UILabel alloc]initWithFrame:rect];
    self.dateLabel.textColor = GXF_CONTENT_COLOR;
    self.dateLabel.font =  GXF_FOURTEENTH_SIZE;
    self.dateLabel.textAlignment = NSTextAlignmentCenter;
    self.dateLabel.text = @"2015-10-21星期一累计客流量";
    [self.view addSubview:self.dateLabel];
    
    CGFloat bottomWidth = (ScreenSize.width - 20*2)/2;
    
    rect = CGRectMake(20, self.dateLabel.bottom,40,30);
    UILabel *weekLabel = [[UILabel alloc]initWithFrame:rect];
    weekLabel.textColor = [UIColor lightGrayColor];
    weekLabel.text = @"比上周";
    weekLabel.font = GXF_THREETEENTH_SIZE;
    [self.view addSubview:weekLabel];
    
    rect = CGRectMake(weekLabel.right, self.dateLabel.bottom,30, 30);
    UIImageView *lastImage = [[UIImageView alloc]initWithFrame:rect];
    lastImage.image = [UIImage imageNamed:@"goSale"];
    [self.view addSubview:lastImage];
    self.lastWeekImage = lastImage;
    
    rect = CGRectMake(lastImage.right, lastImage.top,bottomWidth - lastImage.width - weekLabel.width, 30);
    self.lastWeekLabel = [[UILabel alloc]initWithFrame:rect];
    self.lastWeekLabel.textColor = GXF_CONTENT_COLOR;
    self.lastWeekLabel.text = @"13.2%";
    self.lastWeekLabel.textColor = [UIColor redColor];
    [self.view addSubview:self.lastWeekLabel];
    
    
    
    rect = CGRectMake(self.lastWeekLabel.right, self.dateLabel.bottom,40,30);
    UILabel *yearLabel = [[UILabel alloc]initWithFrame:rect];
    yearLabel.textColor = [UIColor lightGrayColor];
    yearLabel.text = @"比去年";
    yearLabel.font = GXF_THREETEENTH_SIZE;
    [self.view addSubview:yearLabel];
    

    
    rect = CGRectMake(yearLabel.right, lastImage.top,30, 30);
    UIImageView *yearImage = [[UIImageView alloc]initWithFrame:rect];
    yearImage.image = [UIImage imageNamed:@"downSale"];
    [self.view addSubview:yearImage];
    self.lastYearImage = yearImage;
    
    rect = CGRectMake(yearImage.right, lastImage.top,bottomWidth - yearImage.width - yearLabel.width, 30);
    self.lastYearLabel = [[UILabel alloc]initWithFrame:rect];
    self.lastYearLabel.textColor = GXF_CONTENT_COLOR;
    self.lastYearLabel.text = @"13.2%";
    self.lastYearLabel.textColor = GXF_NAVIGAYION_COLOR;
    [self.view addSubview:self.lastYearLabel];
    
    
    self.pageControl = [[SMPageControl alloc]initWithFrame:CGRectMake(0, weekLabel.bottom + 5 , self.view.width, 20)];
    self.pageControl.currentPage = 0;
    self.pageControl.pageIndicatorTintColor = XXFBgColor;
    self.pageControl.currentPageIndicatorTintColor = GXF_NAVIGAYION_COLOR;
    self.pageControl.numberOfPages = 3;
    self.pageControl.currentPage = 1;
    self.pageControl.indicatorMargin = 15.0f;
    self.pageControl.indicatorDiameter = 15.0f;
    [self.view addSubview:self.pageControl];
    
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(pageClick)];
    [self.pageControl addGestureRecognizer:tap];
    
    CLog(@"%f---------",self.view.height);
    
    rect = CGRectMake(0, self.pageControl.bottom + 5, self.view.width, self.view.height - self.pageControl.bottom - 118);
    self.tableView = [[UITableView alloc]initWithFrame:rect style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    //    self.tableView.backgroundColor = [UIColor redColor];
    [self.tableView registerClass:[PasengerCell class] forCellReuseIdentifier:passengerCellIdentify];
    [self.tableView registerClass:[PassengerHeaderCell class] forHeaderFooterViewReuseIdentifier:passengerHeaderIdentify];
    
    
    [self.view addSubview:self.tableView];
    
}


#pragma mark - tableViewDelegate
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return 5;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    PasengerCell *cell = (PasengerCell *)[tableView dequeueReusableCellWithIdentifier:passengerCellIdentify forIndexPath:indexPath];
    
    if(cell == nil) {
        cell = [[PasengerCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:passengerCellIdentify];
    }
    //没有选中风格
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    //取消分割线
    tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    
    
    //    if(task != nil) {
    [cell updateCellWith:nil index:indexPath];
    //        cell.delegate = self;
    
    
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [PasengerCell cellHeight];
}


- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    PassengerHeaderCell *headerView = [tableView dequeueReusableHeaderFooterViewWithIdentifier:passengerHeaderIdentify];
    
    if (headerView == nil) {
        headerView = [[PassengerHeaderCell alloc] initWithReuseIdentifier:passengerHeaderIdentify];
    }
    
    [headerView buildLayout];
    
    return headerView;
}


- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return [PassengerHeaderCell viewHeight];
}

- (void)pageClick{
    CLog(@"=====");
}


#pragma mark - segViewDelegate
- (void)customSegOneClick:(NSString *)title{
    //日周年切换
    
}
- (void)customSegTwoClick:(NSString *)title{
    //选择历史查看
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
