//
//  ReportViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/6.
//  Copyright © 2015年 Xummer. All rights reserved.
// 报表

#import "ReportViewController.h"
#import "SaleViewController.h"
#import "PassengerViewController.h"
#import "PassgerPriceViewController.h"

@interface ReportViewController ()<UIScrollViewDelegate>
@property (nonatomic,strong)UIScrollView *scrollView;
@property (nonatomic,assign)NSInteger currentPage;
@end

@implementation ReportViewController

- (instancetype)init{
    self = [super init];
    if (self) {
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(scrollToCurrent) name:@"ReportScrollToCurrent" object:nil];
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    //布局
    [self bulidLayout];
}

#pragma mark - 布局
- (void)bulidLayout{
    
    self.scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height - 49 - 64)];
    self.scrollView.delegate = self;
    self.scrollView.showsHorizontalScrollIndicator  = NO;
    self.scrollView.showsVerticalScrollIndicator = NO;
    self.scrollView.pagingEnabled = YES;
    [self.view addSubview:self.scrollView];
    
    
    SaleViewController *svc = [SaleViewController new];
    [self addChildViewController:svc];
    
    PassengerViewController *pvc = [PassengerViewController new];
    [self addChildViewController:pvc];
    
    PassgerPriceViewController *ppvc = [PassgerPriceViewController new];
    [self addChildViewController:ppvc];
    
    
    CGRect rect = CGRectMake(0, 0, ScreenSize.width, self.scrollView.height);
    svc.view.frame = rect;
    [self.scrollView addSubview:svc.view];
    
    rect = CGRectMake(self.scrollView.width,0 , ScreenSize.width, self.scrollView.height);
    pvc.view.frame = rect;
    [self.scrollView addSubview:pvc.view];
    
    rect = CGRectMake(self.scrollView.width*2, 0, ScreenSize.width, self.scrollView.height);
    ppvc.view.frame = rect;
    [self.scrollView addSubview:ppvc.view];
    
    self.scrollView.contentSize = CGSizeMake(self.scrollView.width * 3, self.scrollView.height);
    
}


- (void)scrollToCurrent{
    
}

- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView{
    CLog(@"%f",scrollView.contentOffset.x/scrollView.width);
    NSInteger currentPage = scrollView.contentOffset.x/scrollView.width;
    self.currentPage = currentPage;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

@end
