//
//  NewCostViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NewCostViewController.h"
#import "SurveyCell.h"
#import "HPGrowingTextView.h"
#import "ChooseCostViewController.h"
#define LeftMargin 15
#define BtnHeight 44
#define TableRowHeight 46
#define CornerRadius 5
#define BtnSize 19
#define TotalHeight 230
#define KeyboardHeight 258
typedef enum : NSUInteger {
    deleteTag = 10000,
    SaveTag,
} BtnTag;

@interface NewCostViewController ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    
    UILabel *_chooseCostLabel;
    UITextField *_actualmoneyField;
    UITextField *_paidmoneyField;
    UITextField *_leftmoneyField;
    HPGrowingTextView *_noteTextView;
}
@property (nonatomic,strong)NSString *selectStr;
@end

@implementation NewCostViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = self.navTitle;
    [self initData];
    [self createTableView];
    
}
- (void)initData{
    
    _dataArr = [NSMutableArray array];
    [_dataArr addObject:@"费用"];
    [_dataArr addObject:@"应付金额"];
    [_dataArr addObject:@"已付金额"];
    [_dataArr addObject:@"尾款"];
    [_dataArr addObject:@"备注"];
}

- (void)createTableView
{
    self.view.backgroundColor  = XXFBgColor;
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, LeftMargin,ScreenSize.width, ScreenSize.height - 64 - LeftMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 50)];
    
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 10, (ScreenSize.width - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:deleteTag image:nil title:@"删除" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:GXF_SAVE_COLOR];
    [footView addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(saveBtn.frame.origin.x + saveBtn.frame.size.width + LeftMargin, 10, (ScreenSize.width - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:GXF_COMMIT_COLOR];
    [footView addSubview:commitBtn];
    
    _tableView.tableFooterView = footView;
    [self.view addSubview:_tableView];
}

#pragma mark - 按钮点击事件
- (void)btnClick:(UIButton *)btn{
    switch (btn.tag) {
        case deleteTag://删除
        {
                if (self.indexPath) {
                  self.deleteTransportCost(self.accountDetail,self.indexPath);
                 [self PopViewControllerAnimated:YES];
                }else{
                    [self clearInfomation];
                }
        }
            break;
        case SaveTag:
        {
            if ([self checkCost]) {
                self.getTransportCost(self.accountDetail,self.indexPath);
                [self PopViewControllerAnimated:YES];
            }
        }
            break;
        default:
            break;
    }
}
- (void)clearInfomation{
    _chooseCostLabel.text = @"选择费用类型";
    _chooseCostLabel.textColor = GXF_PLACEHOLDER_COLOR;
    _actualmoneyField.text = @"";
    _paidmoneyField.text = @"";
    _leftmoneyField.text = @"0";
    _noteTextView.text = @"";
}
- (BOOL)checkCost{
    
    if (_chooseCostLabel.text.length == 0 || [_chooseCostLabel.text isEqualToString:@"选择费用类型"] ) {
        ShowMessage(@"费用类型不能为空");
        return NO;
    }
    if (_actualmoneyField.text.length == 0 ) {
        ShowMessage(@"应付金额不能为空");
        return NO;
    }
    if (_paidmoneyField.text.length == 0) {
        ShowMessage(@"已付金额不能为空");
        return NO;
    }
    if (_leftmoneyField.text.length == 0 ) {
        ShowMessage(@"尾款不能为空");
        return NO;
    }
    if ([_leftmoneyField.text floatValue] < 0) {
        ShowMessage(@"检查应付金额和已付金额是否正确");
        return NO;
    }
    if (!self.accountDetail) {
        self.accountDetail = [[FeeAcountDetail alloc]init];
    }
    self.accountDetail.accounttitle = _chooseCostLabel.text;
    self.accountDetail.accounttitlename = _chooseCostLabel.text;
    self.accountDetail.actualmoney = [NSNumber numberWithFloat:[_actualmoneyField.text floatValue]];
    self.accountDetail.paidmoney = [NSNumber numberWithFloat:[_paidmoneyField.text floatValue]];
    self.accountDetail.leftmoney = [NSNumber numberWithFloat:[_leftmoneyField.text floatValue]];
    self.accountDetail.note = _noteTextView.text;
    return YES;
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row == 0) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}

-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0) {
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableRowHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_PLACEHOLDER_COLOR;
        contentLabel.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:contentLabel];
        contentLabel.text = @"选择费用类型";
        _chooseCostLabel = contentLabel;
        
    }else if (indexPath.row == _dataArr.count -1){
        _noteTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableRowHeight)];
        _noteTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        _noteTextView.minNumberOfLines = 1;
        _noteTextView.maxNumberOfLines = 1;
        _noteTextView.isScrollable = YES;
        _noteTextView.font = GXF_FIFTEENTEN_SIZE;
        _noteTextView.textAlignment = NSTextAlignmentRight;
        _noteTextView.delegate = self;
        _noteTextView.returnKeyType = UIReturnKeyDone;
        _noteTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:_noteTextView];
    }else{
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-30, TableRowHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = GXF_CONTENT_COLOR;
        textField.font = GXF_FIFTEENTEN_SIZE;
        textField.returnKeyType = UIReturnKeyDone;
        textField.keyboardType = UIKeyboardTypeDecimalPad;
        textField.delegate = self;
        [cell.contentView addSubview:textField];
        
        UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(textField.frame)+ 5, 0, 20, TableRowHeight)];
        label.textColor = GXF_CONTENT_COLOR;
        label.font = GXF_FIFTEENTEN_SIZE;
        label.text = @"元";
        [cell.contentView addSubview:label];
        
        if (indexPath.row == 1) {
            textField.placeholder = @"输入应付金额";
            [textField addTarget:self action:@selector(textChange:) forControlEvents:UIControlEventAllEditingEvents];
            _actualmoneyField = textField;
        }else if(indexPath.row == 2){
            [textField addTarget:self action:@selector(textChange:) forControlEvents:UIControlEventAllEditingEvents];
            textField.placeholder = @"输入已付金额";
            _paidmoneyField = textField;
        }else{
            [textField setEnabled:NO];
            textField.text = @"0";
            textField.textColor = GXF_NAVIGAYION_COLOR;
            _leftmoneyField = textField;
        }
    }
    if (self.accountDetail) {
        [self prepareDataIncell];
    }
}
- (void)prepareDataIncell{
    _chooseCostLabel.text = self.accountDetail.accounttitle;
    _chooseCostLabel.textColor = GXF_CONTENT_COLOR;

    _actualmoneyField.text = [self.accountDetail.actualmoney stringValue];
    _paidmoneyField.text = [self.accountDetail.paidmoney stringValue];
    _leftmoneyField.text = [self.accountDetail.leftmoney stringValue];
    _noteTextView.text = self.accountDetail.note;
    
    self.selectStr = self.accountDetail.accounttitle;
    
}
- (void)textChange:(UITextField *)textField{
    if (_actualmoneyField.text.length > 0 && _paidmoneyField.text.length > 0   ) {
        _leftmoneyField.text = [NSString stringWithFormat:@"%.4f",[_actualmoneyField.text floatValue] - [_paidmoneyField.text floatValue]];
    }
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableRowHeight;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if(indexPath.row == 0){
        ChooseCostViewController *cvc = [ChooseCostViewController new];
        if (self.selectStr.length > 0) {
            cvc.selectStr = self.selectStr;
        }
        cvc.choseBaseInfo = ^(NSArray *costs){
            if (costs.count > 0) {
                Accounttitle *type = costs[0];
                _chooseCostLabel.text = type.name;
                _chooseCostLabel.textColor = GXF_CONTENT_COLOR;
                self.selectStr = type.name;
            }
        };
        [self PushViewController:cvc animated:YES];
    }
}
#pragma mark delegate
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [_noteTextView resignFirstResponder];
    return YES;
}

- (void)keyboardHidden{
    [_actualmoneyField resignFirstResponder];
    [_paidmoneyField resignFirstResponder];
    [_leftmoneyField resignFirstResponder];
    [_noteTextView resignFirstResponder];
}

- (void)viewWillDisappear:(BOOL)animated{
    [super viewWillDisappear:animated];
    
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
