//
//  PurchaseBoltView.m
//  XFFruit
//
//  Created by n22 on 15/8/26.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "PurchaseBoltView.h"
#import "MaskCell.h"
#define TableHeight 45
#define LeftMargin 80
#define TotalHeight 224
#define LeftHeight 44
#define BottomHeight 50
@interface PurchaseBoltView ()<UITextFieldDelegate>
{
    UIView *_leftView;
    UIButton *_currentBtn;
    NSIndexPath *_currentIndexPath;
    UIView *_billView;
    UIView *_noticeView;
    NSString *_state;
    NSString *_billNumber;
    NSString *_title;
    UIButton *_clearBtn;
}
@property (nonatomic,strong)NSString *state;
@property (nonatomic,strong)NSString *noticeNumber;
@property (nonatomic,strong)NSString *billNumber;

@end

@implementation PurchaseBoltView

- (instancetype)initWithFrame:(CGRect)frame state:(NSString *)state billNumber:(NSString *)billNumber noticeNumber:(NSString *)noticeNumber{
    self = [super initWithFrame:frame];
    if (self) {
        self.billNumber = billNumber;
        self.noticeNumber = noticeNumber;
        self.state = state;
        [self createView];
        [self createRightView];
        [self preferData];
    }
    return self;
}
- (void)preferData{
    //initial(未提交)submitted(已提交)rejected(已拒绝)approved(已审批)shipping(发运中)finished(已完成)
    if ([self.state isEqualToString:PURCHASE_STATE_INITIAL]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:0 inSection:0];
    }else if ([self.state isEqualToString:PURCHASE_STATE_SUBMITTED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:1 inSection:0];
    }else if ([self.state isEqualToString:PURCHASE_STATE_REJECTED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:2 inSection:0];
    }else if ([self.state isEqualToString:PURCHASE_STATE_APPROVED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:3 inSection:0];
    }else if ([self.state isEqualToString:PURCHASE_STATE_SHIPPING]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:4 inSection:0];
    }else if ([self.state isEqualToString:PURCHASE_STATE_FINISHED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:5 inSection:0];
    }
    _billView.hidden = YES;
    if(self.billNumber.length > 0){
        self.billFiled.text = self.billNumber;
    }
    _noticeView.hidden = YES;
    if (self.noticeNumber.length > 0) {
        self.noticeFiled.text = self.noticeNumber;
    }
}

#pragma mark - 创建视图
- (void)createView
{
    _leftView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, LeftMargin,self.frame.size.height- BottomHeight)];
    [self addSubview:_leftView];
    NSArray *arr = @[@"按状态",@"采购单号",@"通知单号"];
    for (NSInteger i = 0; i<arr.count; i++) {
        UIButton *button = [UIButton buttonWithType:UIButtonTypeSystem];
        button.frame = CGRectMake(0, LeftHeight * i ,  LeftMargin ,LeftHeight);
        [button setTitle:arr[i] forState:UIControlStateNormal];
        [button setTitleColor:GXF_DETAIL_COLOR forState:UIControlStateNormal];
        if (i == 0) {
            button.enabled = NO;
            _currentBtn = button;
        }
        [button setBackgroundImage:[UIImage imageNamed:@"maskEnable"] forState:UIControlStateDisabled];
        [button setBackgroundImage:[UIImage imageNamed:@"mask"] forState:UIControlStateNormal];
        button.tag = 1001+i;
        [button addTarget:self action:@selector(leftBtnClick:) forControlEvents:UIControlEventTouchUpInside];
        [_leftView addSubview:button];
    }
    _clearBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    _clearBtn.frame = CGRectMake(0, CGRectGetMaxY(_leftView.frame), self.frame.size.width, BottomHeight);
    [_clearBtn setTitle:@"清空选项" forState:UIControlStateNormal];
    [_clearBtn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
    _clearBtn.titleLabel.font = GXF_FIFTEENTEN_SIZE;
    [_clearBtn addTarget:self action:@selector(clearBolt) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:_clearBtn];
}
- (void)createRightView{
    
    _billView = [[UIView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight)];
    _billView.backgroundColor = [UIColor whiteColor];
    [self addSubview:_billView];
    UILabel *titleLabel = [[UILabel alloc]initWithFrame:CGRectMake(10, 20, (ScreenSize.width - LeftMargin - 10*2), 20)];
    titleLabel.font = GXF_FIFTEENTEN_SIZE;
    titleLabel.text = @"类似于：";
    [_billView addSubview:titleLabel];
    self.billFiled = [[UITextField alloc]initWithFrame:CGRectMake(10, CGRectGetMaxY(titleLabel.frame) + 10, (ScreenSize.width - LeftMargin - 10*2), 30)];
    self.billFiled.textAlignment = NSTextAlignmentLeft;
    self.billFiled.textColor = GXF_CONTENT_COLOR;
    self.billFiled.placeholder = @"输入类似采购单号";
    self.billFiled.borderStyle = UITextBorderStyleRoundedRect;
    self.billFiled.font = GXF_FIFTEENTEN_SIZE;
    self.billFiled.returnKeyType = UIReturnKeyDone;
    self.billFiled.delegate = self;
    [_billView addSubview:self.billFiled];
    
    
    _noticeView = [[UIView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight)];
    _noticeView.backgroundColor = [UIColor whiteColor];
    [self addSubview:_noticeView];
    UILabel *billLabel = [[UILabel alloc]initWithFrame:CGRectMake(10, 20, (ScreenSize.width - LeftMargin - 10*2), 20)];
    billLabel.font = GXF_FIFTEENTEN_SIZE;
    billLabel.text = @"类似于：";
    [_noticeView addSubview:billLabel];
    
    self.noticeFiled = [[UITextField alloc]initWithFrame:CGRectMake(10, CGRectGetMaxY(billLabel.frame) + 10, (ScreenSize.width - LeftMargin - 10*2), 30)];
    self.noticeFiled.textAlignment = NSTextAlignmentLeft;
    self.noticeFiled.textColor = GXF_CONTENT_COLOR;
    self.noticeFiled.placeholder = @"输入类似采购通知单号";
    self.noticeFiled.borderStyle = UITextBorderStyleRoundedRect;
    self.noticeFiled.font = GXF_FIFTEENTEN_SIZE;
    self.noticeFiled.returnKeyType = UIReturnKeyDone;
    self.noticeFiled.delegate = self;
    [_noticeView addSubview:self.noticeFiled];
    
    self.tableView = [[UITableView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self addSubview:self.tableView];
    
}


- (void)leftBtnClick:(UIButton *)btn{
    _currentBtn.enabled = YES;
    btn.enabled = NO;
    _currentBtn = btn;
    [self keyBoardHidden];
    switch (btn.tag) {
        case 1001://状态
        {
            self.tableView.hidden = NO;
            _billView.hidden = YES;
            _noticeView.hidden = YES;
        }
            break;
        case 1002://条件二
        {
            self.tableView.hidden = YES;
            _billView.hidden = NO;
            _noticeView.hidden = YES;
        }
            break;
        case 1003://条件三
        {
            self.tableView.hidden = YES;
            _billView.hidden = YES;
            _noticeView.hidden = NO;
        }
            break;
        default:
            break;
    }
}

- (void)clearBolt{
    if (_billFiled.text.length > 0) {
        _billFiled.text = @"";
    }
    if (_noticeFiled.text.length > 0) {
        _noticeFiled.text = @"";
    }
    if (_currentIndexPath) {
        _currentIndexPath = nil;
        [self.tableView reloadData];
    }
    if ([self.delegate respondsToSelector:@selector(clearBoltInformation)]) {
        [self.delegate clearBoltInformation];
    }
}

#pragma mark - 协议
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskID";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth: ScreenSize.width - 80 totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (_dataArr.count > 0) {
        cell.Commitbtn.hidden = YES;
        [cell setTitleStr:self.dataArr[indexPath.row]];
        
    }
    if (_currentIndexPath) {
        if (indexPath.row == _currentIndexPath.row) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    //获取选中的cell
    MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
    currentCell.Commitbtn.hidden = YES;
    MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
    cell.Commitbtn.hidden = NO;
    _currentIndexPath = indexPath;
    
    //initial(未提交)submitted(已提交)rejected(已拒绝)approved(已审批)shipping(发运中)finished(已完成)
    
    NSString *stateStr = @"";
    if (indexPath.row == 0) {
        stateStr = PURCHASE_STATE_INITIAL;
    }else if(indexPath.row == 1){
        stateStr = PURCHASE_STATE_SUBMITTED;
    }else if(indexPath.row == 2){
        stateStr = PURCHASE_STATE_REJECTED;
    }else if(indexPath.row == 3){
        stateStr = PURCHASE_STATE_APPROVED;
    }else if(indexPath.row == 4){
        stateStr = PURCHASE_STATE_SHIPPING;
    }else if(indexPath.row == 5){
        stateStr = PURCHASE_STATE_FINISHED;
    }
    [self.delegate getBoltValueSelectRow:stateStr];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self keyBoardHidden];
    return YES;
}
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event{
    [self keyBoardHidden];
}
- (void)keyBoardHidden{
    [self.billFiled resignFirstResponder];
    [self.noticeFiled resignFirstResponder];
}

- (void)textFieldDidEndEditing:(UITextField *)textField{
    if (textField == self.billFiled) {
        if (self.billFiled.text.length > 0) {
            [self.delegate getbillLike:self.billFiled.text];
        }
    }else if(textField == self.noticeFiled){
        if (self.noticeFiled.text.length > 0) {
            [self.delegate getnoticeLike:self.noticeFiled.text];
        }
    }
}


@end
