//
//  ICRLoginContentView.m
//  XFFruit
//
//  Created by Xummer on 3/30/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRLoginContentView.h"
#import "ICRCheckBox.h"

#define LOGIN_ICON_WIDTH        (156)
#ifdef Demonstrate
#define LOGIN_ICON_HEIGHT        (60)
#else
#define LOGIN_ICON_HEIGHT        (44)
#endif
#define LOGIN_INNER_GAP         (20)
#define LOGIN_INPUT_HEIGHT      (50)

#define LOGIN_LABEL_MARGIN      (10)

@interface ICRLoginContentView ()
{
    BOOL m_bShowCode;
}

@property (strong, nonatomic) UIImageView *m_iconView;
@property (strong, nonatomic) UILabel *m_titleLabel;
@property (strong, nonatomic) UIView *m_cCodeView;
@property (strong, nonatomic) UIView *m_userNameView;
@property (strong, nonatomic) UIView *m_passwordView;
@property (strong, nonatomic) UIView *m_checkBoxView;

@end

@implementation ICRLoginContentView

#pragma mark - Class Method
+ (UIView *)TextFWithLeftLabel:(NSString *)nsLeftLabel
                         textF:(UITextField * __autoreleasing *)textFPointer
{
    UIView *v = [[UIView alloc] init];
    v.backgroundColor = [UIColor clearColor];
    
    UIImageView *txtFBG = [[UIImageView alloc] initWithFrame:v.bounds];
    txtFBG.userInteractionEnabled = YES;
    txtFBG.image =
    [[UIImage imageNamed:@"LoginInputBG"] stretchableImageWithLeftCapWidth:10
                                                              topCapHeight:25];
    [txtFBG autoresizingWithStrechFullSize];
    [v addSubview:txtFBG];
    
    IBTUILabel *leftLabel = [[IBTUILabel alloc] init];
    leftLabel.font = [UIFont systemFontOfSize:16];
    leftLabel.text = nsLeftLabel;
    [leftLabel sizeToFit];
    leftLabel.x = LOGIN_LABEL_MARGIN;
    
    UIView *labelContainer = [[UIView alloc] init];
    labelContainer.backgroundColor = [UIColor clearColor];
    labelContainer.frame = (CGRect){
        .origin.x = 0,
        .origin.y = 0,
        .size.width = leftLabel.width + 2 * LOGIN_LABEL_MARGIN,
        .size.height = leftLabel.height
    };
    [labelContainer addSubview:leftLabel];
    
    UITextField *txtF = [[UITextField alloc] initWithFrame:txtFBG.bounds];
    txtF.leftViewMode = UITextFieldViewModeAlways;
    txtF.leftView = labelContainer;
    [txtF autoresizingWithStrechFullSize];
    [v addSubview:txtF];
    
    if (textFPointer) {
        *textFPointer = txtF;
    }
    
    return v;
}

+ (UIView *)p_textFWithLeftImgView:(NSString *)nsLeftImgName
                       palceHodler: (NSString *)placeHodler
                             textF:(UITextField * __autoreleasing *)textFPointer
{
    UIView *v = [[UIView alloc] init];
    v.backgroundColor = [UIColor clearColor];
    
    UIImageView *txtFBG = [[UIImageView alloc] initWithFrame:v.bounds];
    txtFBG.userInteractionEnabled = YES;
    txtFBG.image =
    [[UIImage imageNamed:@"LoginInputBG"] stretchableImageWithLeftCapWidth:10
                                                              topCapHeight:25];
    [txtFBG autoresizingWithStrechFullSize];
    [v addSubview:txtFBG];
    
    //    IBTUILabel *leftLabel = [[IBTUILabel alloc] init];
    //    leftLabel.font = [UIFont systemFontOfSize:16];
    //    leftLabel.text = nsLeftLabel;
    //    [leftLabel sizeToFit];
    //    leftLabel.x = LOGIN_LABEL_MARGIN;
    UIImageView *leftImgV = [[UIImageView alloc]initWithImage:[UIImage imageNamed:nsLeftImgName]];
    leftImgV.frame = CGRectMake(5, 0, 19, 22);
    
    
    UIView *labelContainer = [[UIView alloc] init];
    labelContainer.backgroundColor = [UIColor clearColor];
    labelContainer.frame = (CGRect){
        .origin.x = 0,
        .origin.y = 0,
        .size.width = leftImgV.width + 1 * LOGIN_LABEL_MARGIN,//leftLabel.width + 2 * LOGIN_LABEL_MARGIN,
        .size.height = leftImgV.height//leftLabel.height
    };
    [labelContainer addSubview:leftImgV];
    
    UITextField *txtF = [[UITextField alloc] initWithFrame:txtFBG.bounds];
    txtF.leftViewMode = UITextFieldViewModeAlways;
    txtF.leftView = labelContainer;
    txtF.placeholder = placeHodler;
    [txtF autoresizingWithStrechFullSize];
    [v addSubview:txtF];
    
    if (textFPointer) {
        *textFPointer = txtF;
    }
    
    return v;
}

#pragma mark - Life Cycle
- (instancetype)initWithFrame:(CGRect)frame
                    showCCode:(BOOL)bNeedShowCCode
{
    self = [self initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    m_bShowCode = bNeedShowCCode;
    
    return self;
}

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubviews];
    
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    self.m_iconView.frame = (CGRect){
        .origin.x = (self.width - LOGIN_ICON_WIDTH) * .5f,
        .origin.y = 0,
        .size.width = LOGIN_ICON_WIDTH,
        .size.height = LOGIN_ICON_HEIGHT//LOGIN_ICON_WIDTH
    };
    
    self.m_titleLabel.frame = (CGRect){
        .origin.x = 0,
        .origin.y = _m_iconView.bottom + 8,
        .size.width = self.width,
        .size.height = 25
    };
    
    self.m_cCodeView.frame = (CGRect){
        .origin.x = 0,
        .origin.y = _m_titleLabel.bottom + 26,
        .size.width = self.width,
        .size.height = LOGIN_INPUT_HEIGHT
    };
    
    self.m_userNameView.frame = (CGRect){
        .origin.x = 0,
        .origin.y = _m_cCodeView.bottom + LOGIN_INNER_GAP,
        .size.width = self.width,
        .size.height = LOGIN_INPUT_HEIGHT
    };
    
    self.m_passwordView.frame = (CGRect){
        .origin.x = 0,
        .origin.y = _m_userNameView.bottom + LOGIN_INNER_GAP,
        .size.width = self.width,
        .size.height = LOGIN_INPUT_HEIGHT
    };
    
    self.m_checkBoxView.frame = (CGRect){
        .origin.x = 0,
        .origin.y = _m_passwordView.bottom + LOGIN_INNER_GAP,
        .size.width = self.width,
        .size.height = LOGIN_INPUT_HEIGHT
    };
    
    self.m_loginBtn.frame = (CGRect){
        .origin.x = 0,
        .origin.y = _m_checkBoxView.bottom + LOGIN_INNER_GAP,
        .size.width = self.width,
        .size.height = LOGIN_INPUT_HEIGHT
    };
}

- (void)didMoveToWindow {
    [super didMoveToWindow];
    
    if (self.window) {
        [self checkLoginEnable];
    }
}

- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    [self endEditing:YES];
    [super touchesBegan:touches withEvent:event];
}

#pragma mark - Private Method
- (void)initSubviews {
    self.m_iconView = [[UIImageView alloc] init];
    self.m_iconView.contentMode = UIViewContentModeScaleAspectFill;
#ifdef Demonstrate
    _m_iconView.image = [UIImage imageNamed:@"demo_logo"];//[IBTCommon appIcon];
#else
    _m_iconView.image = [UIImage imageNamed:@"logo"];//[IBTCommon appIcon];
#endif
    [self addSubview:_m_iconView];
    
    self.m_titleLabel = [[IBTUILabel alloc] init];
    self.m_titleLabel.font = [UIFont systemFontOfSize:19.0f];
    self.m_titleLabel.textColor = [UIColor whiteColor];
    self.m_titleLabel.textAlignment = NSTextAlignmentCenter;
#ifdef Demonstrate
    self.m_titleLabel.text = @"生鲜采购管理平台";
#else
    self.m_titleLabel.text = @"移动管理平台";
#endif
    //[IBTCommon localizableString:@"XFFruit"];
    [self addSubview:_m_titleLabel];
    
    
    UITextField *txtF = nil;
    //    self.m_cCodeView =
    //    [[self class] TextFWithLeftLabel:[[IBTCommon localizableString:@"CompanyCode"] stringByAppendingString:@":"]
    //                               textF:&txtF];
    self.m_cCodeView =
    [[self class] p_textFWithLeftImgView:@"公司识别码"  palceHodler:@"请输入公司认证码" textF:&txtF];
    self.m_cCodeTextF = txtF;
    [self addSubview:_m_cCodeView];
    
    //    self.m_userNameView =
    //    [[self class] TextFWithLeftLabel:[[IBTCommon localizableString:@"User"] stringByAppendingString:@":"]
    //                               textF:&txtF];
    self.m_userNameView =
    [[self class] p_textFWithLeftImgView:@"profile" palceHodler:@"请输入用户名"textF:&txtF];
    
    self.m_userNameTextF = txtF;
    [self addSubview:_m_userNameView];
    
    //    self.m_passwordView =
    //    [[self class] TextFWithLeftLabel:[[IBTCommon localizableString:@"Password"] stringByAppendingString:@":"]
    //                               textF:&txtF];
    self.m_passwordView =
    [[self class] p_textFWithLeftImgView:@"password" palceHodler:@"请输入密码"textF:&txtF];
    
    self.m_passwordTextF = txtF;
    _m_passwordTextF.secureTextEntry = YES;
    [self addSubview:_m_passwordView];
    
    // check box
    [self initCheckBox];
    
    // button
    self.m_loginBtn = [IBTUIButton RoundCornerBtnWithTitle:[IBTCommon localizableString:@"Login"] bgColor:GXF_ORIGIN_COLOR];
    [self.m_loginBtn setTitle:[IBTCommon localizableString:@"Login"]
                     forState:UIControlStateNormal];
    [self addSubview:_m_loginBtn];
    
}

- (void)initCheckBox {
    self.m_checkBoxView = [[UIView alloc] init];
    self.m_checkBoxView.backgroundColor = [UIColor clearColor];
    
    self.m_autoLoginCheckBox = [[ICRCheckBox alloc] initWithFrame:(CGRect){
        .origin.x = 0,
        .origin.y = (_m_checkBoxView.height - CHECK_BOX_DEFAULT_WIDTH) * .5f,
        .size.width = CHECK_BOX_DEFAULT_WIDTH,
        .size.height = CHECK_BOX_DEFAULT_WIDTH
    }];
    _m_autoLoginCheckBox.autoresizingMask = UIViewAutoresizingFlexibleRightMargin | UIViewAutoresizingFlexibleTopMargin | UIViewAutoresizingFlexibleBottomMargin;
    _m_autoLoginCheckBox.isSelected = YES;
    [_m_checkBoxView addSubview:_m_autoLoginCheckBox];
    
    IBTUILabel *autoLoginLabel = [[IBTUILabel alloc] init];
    autoLoginLabel.textAlignment = NSTextAlignmentLeft;
    autoLoginLabel.textColor = [UIColor whiteColor];
    autoLoginLabel.font = [UIFont systemFontOfSize:14.0f];
    autoLoginLabel.text = [IBTCommon localizableString:@"AutoLogin"];
    
    [autoLoginLabel sizeToFit];
    CGFloat fDx = _m_autoLoginCheckBox.right + 10;
    autoLoginLabel.frame = (CGRect){
        .origin.x = fDx,
        .origin.y = 0,
        .size.width = autoLoginLabel.width,
        .size.height = _m_checkBoxView.height
    };
    autoLoginLabel.autoresizingMask =
    UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    [_m_checkBoxView addSubview:autoLoginLabel];
    
    IBTUIButton *autoLoginBtn = [[IBTUIButton alloc] initWithFrame:_m_checkBoxView.bounds];
    autoLoginBtn.backgroundColor = [UIColor clearColor];
    [autoLoginBtn autoresizingWithStrechFullSize];
    [autoLoginBtn addTarget:self
                     action:@selector(onAutoLoginTapped:)
           forControlEvents:UIControlEventTouchUpInside];
    [_m_checkBoxView addSubview:autoLoginBtn];
    
    [self addSubview:_m_checkBoxView];
}

#pragma mark - Action
- (void)onAutoLoginTapped:(__unused id)sender {
    self.m_autoLoginCheckBox.isSelected = !self.m_autoLoginCheckBox.isSelected;
}

#pragma mark - Public Method
- (void)checkLoginEnable {
    _m_cCodeTextF.text = [_m_cCodeTextF.text stringByReplacingOccurrencesOfString:@" " withString:@""];
    _m_userNameTextF.text = [_m_userNameTextF.text stringByReplacingOccurrencesOfString:@" " withString:@""];
    
    self.m_loginBtn.enabled = m_bShowCode ?
    ((_m_cCodeTextF.text.length > 0) && (_m_userNameTextF.text.length > 0) && (_m_passwordTextF.text.length > 0)) :
    ((_m_userNameTextF.text.length > 0) && (_m_passwordTextF.text.length > 0));
    
}

- (BOOL)isAutoLogin {
    return self.m_autoLoginCheckBox.isSelected;
}

@end
