//
//  IBTRefreshTableView.h
//  XFFruit
//
//  Created by Xummer on 4/11/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTTableView.h"
#import "IBTScrollViewRefreshDelegate.h"
#import "IBTScrollLoadMoreView.h"

@interface IBTRefreshTableView : IBTTableView

@property (assign, nonatomic) id <IBTScrollViewRefreshDelegate> refreshDelegate;
@property (strong, nonatomic) UIRefreshControl *refreshCtrl;
@property (strong, nonatomic) IBTScrollLoadMoreView *loadMoreView;

- (void)scrollToTopAnimated:(BOOL)animated;
- (void)scrollToBottomAnimated:(BOOL)animated;

- (void)addRefreshControlWithText:(NSString *)text;
- (void)removeRefreshControl;
- (void)endRefreshWithState:(RefreshState)state;

- (void)addLoadMoreFootWithText:(NSString *)text;
- (void)removeLoadMoreFoot;
- (void)endLoadMoreWithState:(LoadMoreState)state;
- (void)resetLoadMoreFoot;

// call |tableViewDidScroll:| in delegate Method |scrollViewDidScroll:|
- (void)tableViewDidScroll:(UIScrollView *)scrollView;

// call |tableviewDidEndDragging:| in delegate Method |scrollViewDidEndDragging:|
- (void)tableviewDidEndDragging:(UIScrollView *)scrollView;

@end
