//
//  IBTLoadingView.m
//  XFFruit
//
//  Created by Xummer on 3/30/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTLoadingView.h"

@implementation IBTLoadingView

#pragma mark - Class Methods
+ (void)showTips:(id)tips {
    if ([tips isKindOfClass:[NSError class]]) {
        [[self class] showHUDMessage:((NSError *)tips).localizedDescription];
    }
    else if ([tips isKindOfClass:[NSString class]]) {
        [[self class] showHUDMessage:tips];
    }
}

+ (void)showHUDMessage:(NSString *)message {
    [IBTCommon runOnMainThreadWithoutDeadlocking:^{
        [[self class] showTextOnly:message];
    }];
    
}

+ (IBTLoadingView *)showHUDWithText:(NSString *)text
                             inView:(UIView *)view {
    IBTLoadingView *hud = [IBTLoadingView showHUDAddedTo:view animated:YES];
    if ([text length] < 20) {
        hud.labelText = text;
    }
    else {
        hud.detailsLabelText = text;
    }
    
    hud.removeFromSuperViewOnHide = YES;
    return hud;
}

+ (void)showTextOnly:(NSString *)text inView:(UIView *)view {
    IBTLoadingView *hud = [[self class] showHUDWithText:text inView:view];
    hud.mode = MBProgressHUDModeText;
    hud.margin = 10.0f;
    //	hud.yOffset = 0.f;
    [hud hide:YES afterDelay:1];
}

+ (void)showTextOnly:(NSString *)text {
    IBTLoadingView *hud = [[self class] showHUDWithText:text inView:[[self class] hudShowWindow]];
    hud.mode = MBProgressHUDModeText;
    hud.margin = 10.0f;
    hud.yOffset = 60.0f;
    [hud hide:YES afterDelay:4];
}

+ (void)showProgressLabel:(NSString *)text  {
    IBTLoadingView *hud = [[self class] showHUDWithText:text inView:[[self class] hudShowWindow]];
    hud.mode = MBProgressHUDModeIndeterminate;
}

+ (void)hideHUDWithText:(NSString *)text {
    
    [[self class] hideHUDForView:[[self class] hudShowWindow] withText:text];
}

+ (void)showProgressLabel:(NSString *)text
                   inView:(UIView *)view {
    IBTLoadingView *hud = [[self class] showHUDWithText:text inView:view];
    hud.mode = MBProgressHUDModeIndeterminate;
}

+ (void)showCustomView:(UIView *)customview
                inView:(UIView *)view {
    IBTLoadingView *hud = [[IBTLoadingView alloc] initWithView:view];
    hud.customView = customview;
    
    // Set custom view mode
    hud.mode = MBProgressHUDModeCustomView;
    [hud show:YES];
}

+ (void)hideHUDForView:(UIView *)view {
    [IBTCommon runOnMainThreadWithoutDeadlocking:^{
        [IBTLoadingView hideHUDForView:view animated:YES];
    }];
}

+ (void)hideHUDForView:(UIView *)view
              withText:(NSString *)text {
    [IBTLoadingView hideHUDForView:view animated:YES];
    
    if ([text isKindOfClass:[NSString class]]) {
        if (text.length > 0) {
            [[self class] showTextOnly:text];
        }
    }
}

+ (UIWindow *)hudShowWindow {
    UIWindow *showWindow = nil;
    NSArray *windows = [[UIApplication sharedApplication] windows];
    if ([windows count] >= 2) {
        showWindow = [windows objectAtIndex:1];
    }
    else {
        showWindow = [[UIApplication sharedApplication] keyWindow];
    }
    return showWindow;
}

@end
