//
//  PurchaseReceiveProductViewController.m
//  XFFruit
//
//  Created by Javen on 2017/7/21.
//  Copyright © 2017年 Xummer. All rights reserved.
//

#import "PurchaseReceiveProductViewController.h"
#import "HeaderCell.h"
#import "PurchaseReceiveProductCell.h"
#import "PurchaseBillProduct.h"
#define TableHeight 44
#define ShowHeight  200
#define HeaderHeight 40
@interface PurchaseReceiveProductViewController ()<UITableViewDataSource,UITableViewDelegate,HeaderCellDelegate>
{
    CGRect _tableFrame;
    NSMutableArray *_selectRowArr;//记录当前选中的cell
}
//采购单号
@property (strong, nonatomic) NSMutableArray *arrBillNumber;
//按照采购单号区分之后的数据
@property (strong, nonatomic) NSMutableDictionary *dictData;
@end

@implementation PurchaseReceiveProductViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor  = XXFBgColor;
    [super viewDidLoad];
    [self initData];
    [self createView];
}
- (void)initData{
    _selectRowArr = [[NSMutableArray alloc]init];
    if (!self.productArr) {
        self.productArr = [NSMutableArray array];
    }
}

- (void)setProductArr:(NSMutableArray *)productArr {
    _productArr = productArr;
    [self convertData];
}

- (void)convertData {
    self.arrBillNumber = [NSMutableArray array];
    self.dictData = [NSMutableDictionary dictionary];
    for (TransferPdtDetail *pdt in self.productArr) {
        NSString *sourceBillNumber = pdt.sourcebillnumber ? pdt.sourcebillnumber : @" ";
        
        if (![self.arrBillNumber containsObject:sourceBillNumber]) {
            [self.arrBillNumber addObject:sourceBillNumber];
        }
        
        NSMutableArray *arrTemp = [self.dictData objectForKey:sourceBillNumber];
        if (!arrTemp) {
            arrTemp = [NSMutableArray array];
            [self.dictData setObject:arrTemp forKey:sourceBillNumber];
        }
        
        [arrTemp addObject:pdt];
    }
    CLog(@"%@", self.dictData);
}


- (void)setViewFrame:(CGRect)viewFrame{
    _tableFrame = viewFrame;
    _tableView.frame = viewFrame;
}
- (void)createView{
    self.tableView = [[UITableView alloc]initWithFrame:_tableFrame style:(UITableViewStylePlain)];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.view addSubview:self.tableView];
    self.tableView.contentInset = UIEdgeInsetsMake(0, 0, 100, 0);
    NSArray *arr = @[@"商品",@"待收包装数",@"已收包装数", @"已运包装数"];
    
    HeaderCell *headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) withArr:arr withHiddenEdit:self.isHiddenAdd];
    [self.view addSubview:headCell];
    headCell.delegate = self;
    self.tableView.tableHeaderView = headCell;
}

- (void)editClick:(UIButton *)btn{
    TransferPdtDetail *billProduct = self.productArr[btn.tag];
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_EditReceiveProduct object:nil userInfo:@{@"transferPdtDetail":billProduct,@"indexPath":@(btn.tag)}];
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return self.arrBillNumber.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
    NSString *sourceBillNumber = self.arrBillNumber[section];
    if (sourceBillNumber.length == 1) {
        return 0;
    }else{
        return HeaderHeight;
    }
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section {
    UIView *header = [[UIView alloc] initWithFrame:CGRectMake(0, 0, ScreenSize.width, HeaderHeight)];
    header.backgroundColor = [UIColor whiteColor];
    UILabel *transportBillNumber = [[UILabel alloc] initWithFrame:CGRectMake(16, 0, 250, HeaderHeight)];
    [header addSubview:transportBillNumber];
    transportBillNumber.text = [NSString stringWithFormat:@"[采购单：%@]",
                                self.arrBillNumber[section]];
    transportBillNumber.textColor = GXF_GREEN_COLOR;
    
    UIView *line = [[UIView alloc] initWithFrame:CGRectMake(0, HeaderHeight - 1, IBT_MAIN_SCREEN_WIDTH, 1)];
    line.backgroundColor = [UIColor colorWithWhite:0.835 alpha:1.000];
    [header addSubview:line];
    //删除按钮
    //    UIButton *btnDelete = [UIButton buttonWithType:UIButtonTypeCustom];
    //    btnDelete.frame = CGRectMake(IBT_MAIN_SCREEN_WIDTH - 16 - 30, (HeaderHeight - 30)/2, 30, 30);
    //    [btnDelete setImage:[UIImage imageNamed:@"xf_delete_pic"] forState:UIControlStateNormal];
    //    [header addSubview:btnDelete];
    //    btnDelete.tag = section;
    //    [btnDelete addTarget:self action:@selector(actionDeleteBillNumber:) forControlEvents:UIControlEventTouchUpInside];
    
    return header;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    NSMutableArray *arrSection = [self.dictData objectForKey:self.arrBillNumber[section]];
    return arrSection.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"ReceiveProductCell";
    PurchaseReceiveProductCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[PurchaseReceiveProductCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (self.isHiddenEdit) {
            cell.editBtn.hidden = YES;
        }
    }
    if ([self isHaveIndexPath:indexPath]) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = ShowHeight + TableHeight -1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = ShowHeight;
        cell.showView.frame = showfrmame;
        cell.backgroundColor = XXFBgColor;
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = TableHeight-1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = 0;
        cell.showView.frame = showfrmame;
        cell.backgroundColor = [UIColor whiteColor];
    }
    cell.editBtn.tag = indexPath.row;
    [cell.editBtn addTarget:self action:@selector(editClick:) forControlEvents:UIControlEventTouchUpInside];
    
    if (self.productArr.count > 0) {
        NSMutableArray *arrSection = [self.dictData objectForKey:self.arrBillNumber[indexPath.section]];
        TransferPdtDetail *billP = arrSection[indexPath.row];
        [cell setBillProduct:billP row:indexPath.row defaultState:self.defaultState[indexPath.row]];
    }
//    cell.backgroundColor = [UIColor redColor];
    return cell;
}
- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in _selectRowArr) {
        if (path == indexPath) {
            return YES;
        }
    }
    return NO;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    PurchaseReceiveProductCell *cell = (PurchaseReceiveProductCell *)[tableView cellForRowAtIndexPath:indexPath];
    CGRect Linefrmame = cell.lineLabel.frame;
    CGRect showfrmame = cell.showView.frame;
    if (Linefrmame.origin.y == TableHeight - 1) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
        
        Linefrmame.origin.y = ShowHeight + TableHeight - 1;
        showfrmame.size.height = ShowHeight;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr addObject:indexPath];
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        Linefrmame.origin.y = TableHeight -1;
        showfrmame.size.height = 0;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr removeObject:indexPath];
    }
    cell.lineLabel.frame = Linefrmame;
    cell.showView.frame = showfrmame;
    [self.tableView reloadData];
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if ([self isHaveIndexPath:indexPath]) {
        return ShowHeight + TableHeight;
    }
    return TableHeight;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
