//
//  FollowUpRecordViewController.m
//  XFFruit
//
//  Created by mac on 15/9/16.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "FollowUpRecordViewController.h"
#import "NotuceRecordCell.h"
#import "NoticeRecord.h"
#define TableHeight 130
@interface FollowUpRecordViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate>

@end

@implementation FollowUpRecordViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self bulidLayout];
    [self getDataFromServer];
}
- (void)bulidLayout{
    self.dataArr=[[NSMutableArray alloc]init];
    self.tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenHeight) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor clearColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.view addSubview:self.tableView];
}
- (void)getDataFromServer{
//    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
//        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message  = data[@"message"] ;
            if (success == 1) {
                NSArray *dataArr  = data[@"data"];
                for (NSDictionary *dataDict in dataArr) {
                    NoticeRecord *noticeRecord = [[NoticeRecord alloc]init];
                    [noticeRecord setValuesForKeysWithDictionary:dataDict];
                    [self.dataArr addObject:noticeRecord];
                }
                [self.tableView reloadData];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"     无记录     "];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    //5a7417014fdfc13a014fe5b890d8000e
    [[ICRHTTPController sharedController] getPurchaseNoticeRecodWithData:self.purchaseNotice.uuid success:succ failure:fail];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
   
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"NotuceRecordCell";
    NotuceRecordCell*notuceRecordCell = [tableView dequeueReusableCellWithIdentifier:cellID];
    
    if (notuceRecordCell == nil) {
        notuceRecordCell = [[NotuceRecordCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        notuceRecordCell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (self.dataArr.count > 0) {
        NoticeRecord *recode = self.dataArr[indexPath.row];
//        notuceRecordCell.noticeRecode = recode;
        [notuceRecordCell setNoticeRecode:recode withNumber:self.purchaseNotice.billnumber];
    }
    return notuceRecordCell;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
       return TableHeight;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
  }


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
