//
//  PurchaseNoticeViewController.m
//  XFFruit
//
//  Created by mac on 15/9/5.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "PurchaseNoticeViewController.h"
#import "SeePurchaseNoticeViewController.h"
#import "NewPurchaseNoticeViewController.h"
#import "QueryOrder.h"
#import "SortMaskView.h"
#import "NoticeBoltView.h"
#import "MJRefresh.h"
#import "PurchaseNoticeListCell.h"
#import "PurchaseNotice.h"
#import "SurveyUser.h"
#define TopMargin 44
#define TableHeight 120
#define LeftMargin 20
#define BtnWidth 60
#define BtnHeight 24
#define BtnSize 16

typedef enum : NSUInteger {
    SortTag = 3000,
    BoltTag
    
} BtnTag;
@interface PurchaseNoticeViewController ()<UITableViewDataSource,UITableViewDelegate,BoltMaskViewDelegate,SortMaskViewDelegate,UIGestureRecognizerDelegate>
{
    UIView *_maskView;
    UIButton *currentBtn;
    SortMaskView *_sortView;
    NoticeBoltView *_boltView;
    UIBarButtonItem  *_sureBtn;
    UIButton *_sortBtn;
    UIButton *_boltBtn;
    BOOL _isRefresh;
    BOOL _isLoadMore;
    NSInteger _currentPage;
}
@property (nonatomic,strong)NSMutableArray *dataArr;
@property (nonatomic,strong)UITableView *tableView;
@property (nonatomic,strong)NSString *titleLike;
@property (nonatomic,strong)NSString *state;
@property (nonatomic,strong)NSString *billLike;
@property (nonatomic,strong)NSString *orderDirection;//asc(升序)，desc(降序)
@end

@implementation PurchaseNoticeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initData];
    [self createTableView];
    [self createRefresh];
    [self getData];
    [self createBackBtn];
}

- (void)initData{
    self.view.backgroundColor  = XXFBgColor;
    self.dataArr = [NSMutableArray array];
}
- (void)getData{
    [ICRUserUtil sharedInstance].needFresh = NO;
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf fetchtPuchaseList:data];
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    //    ICRUserUtil *userUtil = [ICRUserUtil sharedInstance];
    
    NSMutableArray *orderArr =[NSMutableArray array];
    if (self.orderDirection.length > 0 && ![self.orderDirection isEqualToString:@"none"]) {
        QueryOrder *order = [QueryOrder new];
        order.field = @"created";
        order.direction = self.orderDirection;
        [orderArr addObject:[order dictForCommit]];
    }
    id billObject = [NSNull null];
    if (self.billLike.length > 0) {
        billObject = self.billLike;
    }
    id stateObject = [NSNull null];
    if (self.state.length > 0 && ![self.state isEqualToString:@"none"]) {
        stateObject = self.state;
    }
    id titleObject = [NSNull null];
    if (self.titleLike.length > 0) {
        titleObject = self.titleLike;
    }
    if (orderArr.count == 0) {
        QueryOrder *order = [QueryOrder new];
        order.field = @"created";
        order.direction = @"desc";
        [orderArr addObject:[order dictForCommit]];
        
    }
    NSDictionary *dict = @{
                           @"billNumberLike":billObject,
                           @"state":stateObject,
                           @"title":titleObject,
                           @"queryOrders":orderArr,
                           @"pageNumber":@(_currentPage),
                           @"pageSize":@(20)};
    [[ICRHTTPController sharedController] getPurchaseNoticeListWithData:dict success:succ failure:fail];
}
//刷新列表
- (void)fetchtPuchaseList:(id)data{
    if (data) {
        NSInteger success = [data[@"success"] integerValue];
        NSString *message  = data[@"message"] ;
        if (success == 1) {
            if (_currentPage == 0) {
                if (self.dataArr.count > 0) {
                    [self.dataArr removeAllObjects];
                }
            }
            NSArray *recodesArr = data[ @"data" ][ @"records" ];
            for (NSDictionary *purchaseBillDict in recodesArr) {
                PurchaseNotice *purchaseBill = [[PurchaseNotice alloc]init];
                [purchaseBill setValuesForKeysWithDictionary:purchaseBillDict];
                NSMutableArray *users = [NSMutableArray array];
                for (NSDictionary *userDict in purchaseBill.purchasers) {
                    SurveyUser *user = [SurveyUser new];
                    [user setValuesForKeysWithDictionary:userDict];
                    [users addObject:user];
                }
                purchaseBill.purchasers = users;
                [self.dataArr addObject:purchaseBill];
            }
            NSDictionary *pageDict = data[ @"data" ][ @"paging" ];
            NSInteger pageCount = [pageDict[@"pageCount"] integerValue];
            [self.tableView reloadData];
            [self endRefreshing];
            if (pageCount <= _currentPage) {
                [self.tableView.footer noticeNoMoreData];
            }
            if (_currentPage == 0 && self.dataArr.count > 0) {
                [self.tableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:0] atScrollPosition:UITableViewScrollPositionTop animated:YES];
            }
        }else{
            [IBTLoadingView showTips:message];
        }
    }else{
        [IBTLoadingView showTips:@"      无记录      "];
    }
    
    
}
- (void)createRefresh{
    self.tableView.header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        if (_isRefresh) {
            return ;
        }
        _isRefresh = YES;
        _currentPage = 0;
        [self getData];
    }];
    self.tableView.header.lastUpdatedTimeKey = PurchaseNoticeUpdateDate;
    
    self.tableView.footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        if (_isLoadMore) {
            return ;
        }
        _isLoadMore = YES;
        _currentPage ++;
        [self getData];
    } ];
}
#pragma mark - 结束刷新
- (void)endRefreshing{
    _isLoadMore = NO;
    _isRefresh = NO;
    [self.tableView.header endRefreshing];
    [self.tableView.footer endRefreshing];
}
- (void)createTableView
{
    _sureBtn = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    self.navigationItem.rightBarButtonItem = _sureBtn;
    
    _sortBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 10, BtnWidth, BtnHeight) target:self sel:@selector(sortClick:) tag:SortTag image:@"black_arrow_down_with_text" title:nil titleColor:GXF_DETAIL_COLOR isCorner:NO corner:0 bgColor:nil];
    _sortBtn.titleLabel.font = FontSize(BtnSize);
    [self.view addSubview:_sortBtn];
    
    _boltBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(ScreenSize.width-BtnWidth - LeftMargin,10,BtnWidth, BtnHeight) target:self sel:@selector(sortClick:) tag:BoltTag image:@"black_filter_with_text" title:nil titleColor:GXF_DETAIL_COLOR isCorner:NO corner:0 bgColor:nil];
    _boltBtn.titleLabel.font = FontSize(BtnSize);
    [self.view addSubview:_boltBtn];
    
    
    self.tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,ScreenSize.width, ScreenHeight - 64 - TopMargin)) style:(UITableViewStylePlain)];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.view addSubview:self.tableView];
    
    _maskView = [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, ScreenHeight - 64- TopMargin)];
    _maskView.backgroundColor = RGBA(0, 0, 0, 0.5);
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(hiddenMaskView)];
    [_maskView addGestureRecognizer:tap];
    tap.delegate = self;
    _maskView.hidden = YES;
    [self.view addSubview:_maskView];
}
#pragma mark - 手势代理方法
- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch
{
    // 输出点击的view的类名
    NSLog(@"%@", NSStringFromClass([touch.view class]));
    
    // 若为UITableViewCellContentView（即点击了tableViewCell），则不截获Touch事件
    if ([NSStringFromClass([touch.view class]) isEqualToString:@"UITableViewCellContentView"]) {
        return NO;
    }
    return  YES;
}
#pragma mark - 隐藏maskView
- (void)hiddenMaskView{
    if (_sortView) {
        [self hiddenSortMaskView:YES];
    }
    if (_boltView) {
        [self hiddenBoltMaskView:YES];
    }
}
#pragma mark -按钮事件
- (void)sortClick:(UIButton *)btn{
    _maskView.backgroundColor = RGBA(0, 0, 0, 0.5);
    _maskView.hidden = NO;
    if (btn.tag == SortTag) {
        if(_boltView){
            [self hiddenBoltMaskView:NO];
        }
        if (currentBtn == btn) {
            [btn setImage:[UIImage imageNamed:@"black_arrow_down_with_text"] forState:UIControlStateNormal];
            [self hiddenSortMaskView:YES];
            currentBtn = nil;
        }else{
            [btn setImage:[UIImage imageNamed:@"select_arrow_up_text"] forState:UIControlStateNormal];
            if (_sortView == nil) {
                _sortView = [[SortMaskView alloc]initWithFrame:CGRectMake(0, -105, ScreenSize.width, 150) withOrderDirection:self.orderDirection];
                _sortView.dataArr = [[NSMutableArray alloc]initWithObjects:@"按时间顺序",@"按时间逆序",@"默认排序",nil];
                _sortView.delegate = self;
                [_maskView addSubview:_sortView];
                [UIView animateWithDuration:0.25 animations:^{
                    CGRect sortFrame = _sortView.frame;
                    sortFrame.origin.y = 0;
                    _sortView.frame = sortFrame;
                }];
            }
            currentBtn = btn;
        }
    }else if(btn.tag == BoltTag){
        if (_sortView) {
            [self hiddenSortMaskView:NO];
        }
        if (currentBtn == btn) {
            [btn setImage:[UIImage imageNamed:@"black_filter_with_text"] forState:UIControlStateNormal];
            [self hiddenBoltMaskView:YES];
            currentBtn = nil;
            
        }else{
            [btn setImage:[UIImage imageNamed:@"selected-filter_with_text"] forState:UIControlStateNormal];
            if (_boltView == nil) {
                 _boltView = [[NoticeBoltView alloc]initWithFrame:CGRectMake(0, -105, ScreenSize.width, 274) state:self.state title:self.titleLike bill:self.billLike];
                _boltView.backgroundColor = XXFBgColor;
                _boltView.delegate = self;
                _boltView.dataArr = [[NSMutableArray alloc]initWithObjects:@"不限",@"未提交",@"未接受",@"发运中",@"已完成",nil];
                [_maskView addSubview:_boltView];
                [UIView animateWithDuration:0.25 animations:^{
                    CGRect sortFrame = _boltView.frame;
                    sortFrame.origin.y = 0;
                    _boltView.frame = sortFrame;
                }];
                currentBtn = btn;
            }
        }
    }
}

- (void)hiddenSortMaskView:(BOOL)isHide{
    currentBtn = nil;
    [self checkSortBtnColor];
    if (isHide == NO) {
        [_sortView removeFromSuperview];
        _sortView = nil;
    }else{
        [UIView animateWithDuration:0.25 animations:^{
            CGRect sortFrame = _sortView.frame;
            sortFrame.origin.y = -105;
            _sortView.frame = sortFrame;
            _maskView.backgroundColor = RGBA(0, 0, 0, 0);
        }completion:^(BOOL finished) {
            [_sortView removeFromSuperview];
            _sortView = nil;
            _maskView.hidden = YES;
        }];
    }
}
- (void)hiddenBoltMaskView:(BOOL)isHide{
    currentBtn = nil;
    [self checkBoltBtnColor];
    if (isHide == NO) {
        [_boltView removeFromSuperview];
        _boltView = nil;
    }else{
        [UIView animateWithDuration:0.25 animations:^{
            CGRect sortFrame = _boltView.frame;
            sortFrame.origin.y = -105;
            _boltView.frame = sortFrame;
            _maskView.backgroundColor = RGBA(0, 0, 0, 0);
        }completion:^(BOOL finished) {
            [_boltView removeFromSuperview];
            _boltView = nil;
            _maskView.hidden = YES;
        }];
    }
}

//检测排序的颜色
- (void)checkSortBtnColor{
    if (self.orderDirection.length > 0) {
        [_sortBtn setImage:[UIImage imageNamed:@"select_arrow_up_text"] forState:UIControlStateNormal];
    }else{
        [_sortBtn setImage:[UIImage imageNamed:@"black_arrow_down_with_text"] forState:UIControlStateNormal];
        
    }
}
- (void)checkBoltBtnColor{
    if (self.state.length > 0 || self.titleLike.length > 0 || self.billLike.length > 0) {
        [_boltBtn setImage:[UIImage imageNamed:@"selected-filter_with_text"] forState:UIControlStateNormal];
    }else{
        [_boltBtn setImage:[UIImage imageNamed:@"black_filter_with_text"] forState:UIControlStateNormal];
        
    }
}
#pragma mark - 确定
- (void)sureClick{
    
    [_boltView.titleFiled resignFirstResponder];
    [_boltView.billFiled resignFirstResponder];
    _currentPage = 0;
    
    //请求
    [self getData];
    //还原数据
    if (_sortView) {
        [self hiddenSortMaskView:YES];
    }
    if (_boltView) {
        [self hiddenBoltMaskView:YES];
    }
}

#pragma mark - sortDelegate
- (void)getSortValueSelectRow:(NSString *)state{
    if (state.length > 0) {
        self.orderDirection = state;
        CLog(@"%@",state);
    }
}
#pragma mark - boltDelegate
- (void)getBoltValueSelectRow:(NSString *)state{
    self.state = state;
    CLog(@"%@",state);
}
- (void)getBillNumber:(NSString *)billNumber{
    self.billLike = billNumber;
    CLog(@"%@",billNumber);
}
- (void)getTitleLike:(NSString *)titleLike{
    self.titleLike = titleLike;
    CLog(@"%@",titleLike);
}
- (void)clearBoltInformation{
    //清空所有条件
    if (self.billLike.length > 0) {
        self.billLike = @"";
    }
    if (self.titleLike.length > 0) {
        self.titleLike = @"";
    }
    if (self.state.length > 0) {
        self.state = @"";
    }
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"PurchaseNoticeListCell";
    PurchaseNoticeListCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[PurchaseNoticeListCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (self.dataArr.count > 0) {
        PurchaseNotice *bill = self.dataArr[indexPath.row];
        cell.purchaseNotice = bill;
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if (_dataArr.count > 0) {
        PurchaseNotice *purchaseNotice = _dataArr[indexPath.row];
        if ([purchaseNotice.state isEqualToString:PURCHASENOTICE_STATE_INITIAL]) {
            NewPurchaseNoticeViewController *nvc = [NewPurchaseNoticeViewController new];
            nvc.purchaseNotice = purchaseNotice;
            nvc.title = @"修改采购通知单";
            [self PushViewController:nvc animated:YES];
        }else{
            SeePurchaseNoticeViewController *pvc = [SeePurchaseNoticeViewController new];
            pvc.title = @"查看采购通知单";
            pvc.purchaseNotice = purchaseNotice;
            [self PushViewController:pvc animated:YES];
        }
    }
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}
- (void)viewWillAppear:(BOOL)animated{
    [super viewWillAppear:animated];
    if ([ICRUserUtil sharedInstance].needFresh && self.tableView != nil) {
        [self.tableView.header beginRefreshing];
    }
}

- (void)createBackBtn{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setImage:[UIImage imageNamed:@"back"] forState:UIControlStateNormal];
    btn.frame  = CGRectMake(0, 0, 12, 20);
    [btn addTarget:self action:@selector(backRV) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *back = [[UIBarButtonItem alloc]initWithCustomView:btn];
    self.navigationItem.leftBarButtonItem = back;
}
- (void)backRV{
    [self PopToRootViewControllerAnimated:YES];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}
/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */

@end
