//
//  NoticeProductViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NoticeProductViewController.h"
#import "SurveyCell.h"
#import "HPGrowingTextView.h"
#import "ChooseProductViewController.h"
#import "ChooseProductUnitViewController.h"
#define LeftMargin 15
#define BtnHeight 44
#define TableRowHeight 46
#define CornerRadius 5
#define BtnSize 19
#define TotalHeight 230
#define KeyboardHeight 258
typedef enum : NSUInteger {
    deleteTag = 10000,
    SaveTag,
} BtnTag;

@interface NoticeProductViewController ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate,UIAlertViewDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    
    UILabel *_chooseCostLabel;
    UILabel *_choosePackUnitLabel;
    UITextField *_qpcField;
    UITextField *_qpcQuantityField;
    UITextField *_quantityField;
    UILabel *_packCountLabel;
    UILabel *_qpcLabel;
    UILabel *_baseCountLabel;
    
    HPGrowingTextView *_noteTextView;
}
@property (nonatomic,strong)NSString *productNameStr;
@property (nonatomic,strong)NSString *productCodeStr;
@property (nonatomic,strong)NSString *productUuidStr;
@property (nonatomic,strong)NSString *productQpcStr;//商品规格描述
@property (nonatomic,strong)NSMutableArray *selectProducts;
@property (nonatomic,strong)NSString *selectUnit;

@end

@implementation NoticeProductViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = self.navTitle;
    [self initData];
    [self createTableView];
    
}
- (void)initData{
    
    _dataArr = [NSMutableArray array];
    self.selectProducts = [NSMutableArray array];
    [_dataArr addObject:@"商品"];
    [_dataArr addObject:@"包装单位"];
    [_dataArr addObject:@"包装规格"];
    [_dataArr addObject:@"包装数量[计划]"];
    [_dataArr addObject:@"基础数量[计划]"];
    [_dataArr addObject:@"备注"];
}

- (void)createTableView
{
    self.view.backgroundColor  = XXFBgColor;
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, LeftMargin,ScreenSize.width, ScreenHeight - 64 - LeftMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 50)];
    
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 10, (ScreenSize.width - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:deleteTag image:nil title:@"删除" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:GXF_SAVE_COLOR];
    [footView addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(saveBtn.frame.origin.x + saveBtn.frame.size.width + LeftMargin, 10, (ScreenSize.width - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:GXF_COMMIT_COLOR];
    [footView addSubview:commitBtn];
    
    _tableView.tableFooterView = footView;
    [self.view addSubview:_tableView];
}

#pragma mark - 按钮点击事件
- (void)btnClick:(UIButton *)btn{
    switch (btn.tag) {
        case deleteTag://删除
        {
            UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"请确认删除" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
            alertView.delegate = self;
            [alertView show];
        }
            break;
        case SaveTag:
        {
            if ([self checkCost]) {
                self.choseNoticeProduct(self.noticeProduct,self.indexPath);
                [self PopViewControllerAnimated:YES];
            }
        }
            break;
        default:
            break;
    }
}
- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
    if (buttonIndex == 1) {
        if (self.indexPath) {
            self.deleteNoticeProduct(self.noticeProduct,self.indexPath);
            [self PopViewControllerAnimated:YES];
        }else{
            [self clearInfomation];
        }
    }
}
- (void)clearInfomation{
    _chooseCostLabel.text = @"选择商品";
    _chooseCostLabel.textColor = GXF_PLACEHOLDER_COLOR;
    _choosePackUnitLabel.text = @"选择包装单位";
    _choosePackUnitLabel.textColor = GXF_PLACEHOLDER_COLOR;
    _qpcField.text = @"";
    _qpcQuantityField.text = @"";
    _quantityField.text = @"";
    _noteTextView.text = @"";
}
- (BOOL)checkCost{
    
    if (_chooseCostLabel.text.length == 0 || [_chooseCostLabel.text isEqualToString:@"选择商品"] ) {
        ShowMessage(@"商品不能为空");
        return NO;
    }
    if (_choosePackUnitLabel.text.length == 0 || [_choosePackUnitLabel.text isEqualToString:@"选择包装单位"] ) {
        ShowMessage(@"包装单位不能为空");
        return NO;
    }
    if (_qpcField.text.length == 0 ) {
        ShowMessage(@"包装规格不能为空");
        return NO;
    }
    if (_qpcQuantityField.text.length == 0) {
        ShowMessage(@"包装数量不能为空");
        return NO;
    }
    if (_quantityField.text.length == 0) {
        ShowMessage(@"基础数量不能为空");
        return NO;
    }
    
    if (!self.noticeProduct) {
        self.noticeProduct = [[NoticeProduct alloc]init];
    }
    self.noticeProduct.productCode = self.productCodeStr;
    self.noticeProduct.productName = self.productNameStr;
    self.noticeProduct.productUuid = self.productUuidStr;
    
    self.noticeProduct.baseUnit = _qpcLabel.text;//规格单位
    self.noticeProduct.packUnit = _choosePackUnitLabel.text;
    self.noticeProduct.qpc = [NSNumber numberWithFloat:[_qpcField.text floatValue]];
    self.noticeProduct.qpcQuantity = [NSNumber numberWithFloat:[_qpcQuantityField.text floatValue]];
    self.noticeProduct.quantity = [NSNumber numberWithFloat:[_quantityField.text floatValue]];
    self.noticeProduct.remark = _noteTextView.text;
    return YES;
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.titleLabel.width = 120;
        if (indexPath.row == 0 || indexPath.row == 1) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}

-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0 || indexPath.row == 1) {
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(cell.titleLabel.right, 0, ScreenSize.width - cell.titleLabel.width - LeftMargin*2-15, TableRowHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_PLACEHOLDER_COLOR;
        contentLabel.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:contentLabel];
        
        if (indexPath.row == 0) {
            contentLabel.text = @"选择商品";
            _chooseCostLabel = contentLabel;
        }else if(indexPath.row == 1) {
            contentLabel.text = @"选择包装单位";
            _choosePackUnitLabel = contentLabel;
        }
    }else if (indexPath.row == _dataArr.count -1){
        _noteTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(cell.titleLabel.right, 0, ScreenSize.width - cell.titleLabel.width - LeftMargin*2-15, TableRowHeight)];
        _noteTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        _noteTextView.minNumberOfLines = 1;
        _noteTextView.maxNumberOfLines = 4;
//        _noteTextView.isScrollable = YES;
        _noteTextView.font = GXF_FIFTEENTEN_SIZE;
        _noteTextView.textAlignment = NSTextAlignmentRight;
        _noteTextView.delegate = self;
        _noteTextView.returnKeyType = UIReturnKeyDone;
        _noteTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:_noteTextView];
        
        CGRect lineFrame =  cell.lineLabel.frame;
        lineFrame.origin.y = TableRowHeight*2-1;
        cell.lineLabel.frame = lineFrame;
    }else{
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake( cell.titleLabel.right, 0, ScreenSize.width -  cell.titleLabel.width - LeftMargin*2-30, TableRowHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = GXF_CONTENT_COLOR;
        textField.font = GXF_FIFTEENTEN_SIZE;
        textField.returnKeyType = UIReturnKeyDone;
        textField.keyboardType = UIKeyboardTypeDecimalPad;
        textField.delegate = self;
        [textField addTarget:self action:@selector(textEditClick:) forControlEvents:UIControlEventAllEditingEvents];
        [cell.contentView addSubview:textField];
        
        UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(textField.frame)+ 5, 0, 20, TableRowHeight)];
        label.textColor = GXF_CONTENT_COLOR;
        label.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:label];
        
        if (indexPath.row == 2) {
            _qpcLabel = label;
            UILabel *labelTwo = [[UILabel alloc]initWithFrame:CGRectMake(cell.titleLabel.right, 0, 50, TableRowHeight)];
            labelTwo.text = @"1*";
            labelTwo.textAlignment = NSTextAlignmentRight;
            [cell.contentView addSubview:labelTwo];
            textField.left = labelTwo.right;
            textField.width = textField.width - 50;
            label.left = textField.right+ 5;
            textField.placeholder = @"输入包装规格";
            _qpcField = textField;
        }else if(indexPath.row == 3){
            _packCountLabel = label;
            textField.placeholder = @"输入包装数量";
            _qpcQuantityField = textField;
        }else{
            _baseCountLabel = label;
            textField.placeholder = @"输入基础数量";
            _quantityField = textField;
        }
    }
    if (self.noticeProduct) {
        [self prepareDataIncell];
    }
}
//【基础数量】=包装规格*包装数量
- (void)textEditClick:(UITextField *)textField{
    if (textField == _qpcField) {//包装规格
        if (_qpcQuantityField.text.length > 0) {//包装数量
            //计算基础数量
            float baseCount = [_qpcField.text floatValue] * [_qpcQuantityField.text floatValue];
            _quantityField.text = [NSString stringWithFormat:@"%.2f",baseCount];
        }
    }else if (textField == _qpcQuantityField) {//包装数量
        if (_qpcField.text.length > 0) {//包装规格
            //计算基础数量
            float baseCount = [_qpcField.text floatValue] * [_qpcQuantityField.text floatValue];
            _quantityField.text = [NSString stringWithFormat:@"%.2f",baseCount];
        }
    }else if (textField == _quantityField) {//基础数量
        if (_qpcField.text.length > 0) {//包装规格
            //计算包装数量
            if ([_qpcField.text integerValue] > 0) {
                float packCount = [_quantityField.text floatValue] / [_qpcField.text floatValue];
                _qpcQuantityField.text = [NSString stringWithFormat:@"%.2f",packCount];
            }
        }
    }
}



- (void)prepareDataIncell{
    _chooseCostLabel.text = [NSString stringWithFormat:@"%@[%@]",self.noticeProduct.productName,self.noticeProduct.productCode];
    self.productUuidStr = self.noticeProduct.productUuid;
    self.productCodeStr = self.noticeProduct.productCode;
    self.productNameStr = self.noticeProduct.productName;
    [self.selectProducts addObject:self.noticeProduct.productUuid];
    
    _chooseCostLabel.textColor = GXF_CONTENT_COLOR;
    _choosePackUnitLabel.text = self.noticeProduct.packUnit;
    _choosePackUnitLabel.textColor = GXF_CONTENT_COLOR;
    
    _packCountLabel.text = self.noticeProduct.packUnit;
    _baseCountLabel.text = self.noticeProduct.baseUnit;
    _qpcLabel.text = self.noticeProduct.baseUnit;

    _qpcField.text = [self.noticeProduct.qpc stringValue];
    _qpcQuantityField.text = [self.noticeProduct.qpcQuantity stringValue];
    _quantityField.text = [self.noticeProduct.quantity stringValue];
    _noteTextView.text = self.noticeProduct.remark;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == _dataArr.count - 1) {
        return TableRowHeight *2;
    }
    return TableRowHeight;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if(indexPath.row == 0){
        ChooseProductViewController *cvc = [ChooseProductViewController new];
        if (self.selectProducts.count > 0) {
            cvc.selectArr = self.selectProducts;
        }
        cvc.choseBaseInfo = ^(NSArray  *products){
            Product *product=products [0];
            _chooseCostLabel.text = [NSString stringWithFormat:@"%@[%@]",product.name,product.code];
            _chooseCostLabel.textColor = GXF_CONTENT_COLOR;
            self.productNameStr = product.name;
            self.productUuidStr = product.uuid;
            self.productCodeStr = product.code;
            _qpcLabel.text = product.measureUnit;
            _baseCountLabel.text = _qpcLabel.text;
            if (self.selectProducts.count > 0) {
                [self.selectProducts removeAllObjects];
            }
            [self.selectProducts addObject:product.uuid];
        };
        cvc.isMoreChose = NO;
        [self PushViewController:cvc animated:YES];
    }else if(indexPath.row == 1){
        ChooseProductUnitViewController *cvc = [ChooseProductUnitViewController new];
        if (self.selectUnit.length > 0) {
            cvc.selectStr = self.selectUnit;
        }
        cvc.choseBaseInfo = ^(NSArray  *products){
            if (products.count > 0) {
                GXFProductUnit *productUnit=products [0];
                _choosePackUnitLabel.text = [NSString stringWithFormat:@"%@",productUnit.name];
                _choosePackUnitLabel.textColor = GXF_CONTENT_COLOR;
                _packCountLabel.text = productUnit.name;
                self.selectUnit = productUnit.name;
            }
        };
        cvc.isMoreChose = NO;
        [self PushViewController:cvc animated:YES];
    }
}
#pragma mark delegate
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [_noteTextView resignFirstResponder];
    return YES;
}

- (void)keyboardHidden{
    [_qpcField resignFirstResponder];
    [_qpcQuantityField resignFirstResponder];
    [_quantityField resignFirstResponder];
    [_noteTextView resignFirstResponder];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
