//
//  SearchReportViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/17.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "SearchReportViewController.h"
#import "RsearchCell.h"
#import "LowerOrgs.h"
#import "ReportDetailViewController.h"
#import "MJRefresh.h"
@interface SearchReportViewController ()<UITextFieldDelegate,UITableViewDataSource,UITableViewDelegate>
{
    NSInteger _currentPage;
    BOOL _isRefresh;
    BOOL _isLoadMore;

}
@property (nonatomic,strong)UITextField *selectTextFiled;
@property (nonatomic,strong)UITableView *tableView;
@property (nonatomic,strong)NSMutableArray *dataArr;
@property (nonatomic,strong)NSString *nameAndCode;

@end

@implementation SearchReportViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"搜索组织";
    _currentPage = 0;
    self.view.backgroundColor = [UIColor whiteColor];
    self.dataArr = [NSMutableArray array];
    //布局
    [self bulidLayout];
    [self createRefresh];
    //请求数据
    [self getOrgDataFromServer];
}
#pragma mark - 布局
- (void)bulidLayout{
    //布局
    self.selectTextFiled = [[UITextField alloc] initWithFrame:CGRectMake(20,5,ScreenSize.width - 100, 40)];
    self.selectTextFiled.textAlignment = NSTextAlignmentLeft;
    self.selectTextFiled.background = [UIImage imageNamed:@"textFiled"];
    self.selectTextFiled.delegate = self;
    self.selectTextFiled.placeholder = @"输入门店或者区域、代码查询";
    self.selectTextFiled.font = GXF_THREETEENTH_SIZE;
    [self.view addSubview:self.selectTextFiled];
    
    UIImageView *leftView = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, 35, 40)];
    leftView.image = [UIImage imageNamed:@"search"];
    self.selectTextFiled.leftView = leftView;
    self.selectTextFiled.leftViewMode = UITextFieldViewModeAlways;
    
    UIButton *rightView = [UIButton buttonWithType:UIButtonTypeCustom];
    [rightView setImage:[UIImage imageNamed:@"delete"] forState:UIControlStateNormal];
    rightView.frame = CGRectMake(0, 0, 35, 40);
    [rightView addTarget:self action:@selector(deleteTextFieldStr) forControlEvents:UIControlEventTouchUpInside];
    self.selectTextFiled.rightView = rightView;
    self.selectTextFiled.rightViewMode = UITextFieldViewModeAlways;
    
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame = CGRectMake(self.selectTextFiled.right + 5,7, 65, 35);
    [btn setTitle:@"开始查询" forState:UIControlStateNormal];
    btn.titleLabel.font = FontSize(13);
    btn.layer.cornerRadius = 5;
    btn.layer.masksToBounds = YES;
    btn.backgroundColor = ReportColor;
    [btn addTarget:self action:@selector(checkWithBillNumber) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn];
    
    CGRect rect = CGRectMake(0, 50, ScreenSize.width, ScreenHeight - 64 - 50);
    self.tableView = [[UITableView alloc]initWithFrame:rect style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.view addSubview:self.tableView];
}
- (void)deleteTextFieldStr{
    self.selectTextFiled.text = @"";
}
#pragma mark - 刷新
- (void)createRefresh{
    self.tableView.header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        if (_isRefresh) {
            return ;
        }
        _isRefresh = YES;
        _currentPage = 0;
        [self getOrgDataFromServer];
    }];
    self.tableView.header.lastUpdatedTimeKey = SearchReportViewDate;
    
    self.tableView.footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        if (_isLoadMore) {
            return ;
        }
        _isLoadMore = YES;
        _currentPage ++;
        [self getOrgDataFromServer];
    } ];
}
#pragma mark - 请求服务器
- (void)getOrgDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        //赋值
        [IBTLoadingView hideHUDWithText:nil];
        [strongSelf prepareDataInTable:data];
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
        
    };
    if (!self.nameAndCode) {
        self.nameAndCode = @"";
    }
    ICRUserUtil *userUtil = [ICRUserUtil sharedInstance];
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    NSDictionary *dict = @{
                           @"path":userUtil.belongOrgPath,
                           @"codeOrName":self.nameAndCode,
                           @"pageNumber":@(_currentPage),
                           @"pageSize":@20
                           };
    [[ICRHTTPController sharedController] queryLowerOrgsWith:dict success:succ failure:fail];
}
#pragma mark - 准备数据
- (void)prepareDataInTable:(id)data{
    if (data) {
        NSInteger success = [data[@"success"] integerValue];
        NSString *message  = data[@"message"] ;
        if (success == 1) {
            if (_currentPage == 0) {
                if (self.dataArr.count > 0) {
                    [self.dataArr removeAllObjects];
                }
            }
            NSArray *arr = data[ @"data" ][@"records"];
            if (arr.count > 0) {
                for (NSDictionary *comDict in arr) {
                    LowerOrgs *com = [[LowerOrgs alloc]init];
                    [com setValuesForKeysWithDictionary:comDict];
                    [self.dataArr addObject:com];
                }
            }
            NSDictionary *pageDict = data[ @"data" ][ @"paging" ];
            NSInteger pageCount = [pageDict[@"pageCount"] integerValue];
            [self.tableView reloadData];
            [self endRefreshing];
            if (pageCount <= _currentPage) {
                [self.tableView.footer noticeNoMoreData];
            }
            if (_currentPage == 0 && self.dataArr.count > 0) {
                [self.tableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:0] atScrollPosition:UITableViewScrollPositionTop animated:YES];
            }

        }else{
            [IBTLoadingView showTips:message];
        }
    }else{
        [IBTLoadingView showTips:@"      无记录      "];
    }
}
#pragma mark - 结束刷新
- (void)endRefreshing{
    _isLoadMore = NO;
    _isRefresh = NO;
    [self.tableView.header endRefreshing];
    [self.tableView.footer endRefreshing];
}
#pragma mark - tableViewDelegate
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    static NSString *cellID = @"SearchCell";
    
    RsearchCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if(cell == nil) {
        cell = [[RsearchCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
    }
    //没有选中风格
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    //取消分割线
    tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    if (self.dataArr.count > 0) {
        LowerOrgs *orgs = self.dataArr[indexPath.row];
        [cell setvalueWithLowerOrgs:orgs];
    }
    
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    LowerOrgs *orgs = self.dataArr[indexPath.row];
    ReportDetailViewController *rvc = [ReportDetailViewController new];
    Compass *com = [Compass new];
    com.orgUuid = orgs.uuid;
    com.orgName = orgs.name;
    com.orgCode = orgs.code;
    com.dataScope = [[NSDate date] localYMDString];
    com.dataScopeType = @"day";
    rvc.compass = com;
    [self PushViewController:rvc animated:YES];
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [RsearchCell cellHeight];
}
#pragma mark - 搜索门店
- (void)checkWithBillNumber{
    [self.selectTextFiled resignFirstResponder];
    if (self.selectTextFiled.text.length > 0) {
        self.nameAndCode = self.selectTextFiled.text;
    }else{
        self.nameAndCode = nil;
    }
    _currentPage = 0;
    [self getOrgDataFromServer];
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
