//
//  ChooseTransportViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/10/11.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChooseTransportViewController.h"
#import "TransportPurchaseCell.h"
#import "QueryOrder.h"
#import "TransportPdtDetail.h"
#import "MJRefresh.h"
#import "Transport.h"
#define TopMargin 50
#define TableHeight 50
@interface ChooseTransportViewController ()<UITextFieldDelegate,UITableViewDataSource,UITableViewDelegate>
{
    BOOL _isRefresh;
    BOOL _isLoadMore;
    NSInteger _currentPage;
    id billNumberObject;
}
@property (nonatomic,strong)NSMutableArray *indexArr;
@property (nonatomic,strong)NSMutableArray *dataArr;
@property (nonatomic,strong)UITableView *tableView;
@property (nonatomic,strong)UITextField *selectTextFiled;
@property (nonatomic,strong)NSString *contentStr;
@end

@implementation ChooseTransportViewController

- (instancetype)init{
    self = [super init];
    if (self) {
        
    }
    return self;
}
- (void)dealloc{
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"选择发运单";
    [self initData];
    [self bulidLayout];
    [self createRefresh];
    [self getData];
    NSLog(@"%@",@{@"AB":@"abc_123"});
}
- (void)initData{
    self.dataArr = [NSMutableArray array];
    self.indexArr = [NSMutableArray array];
}


- (void)getData{
    [ICRUserUtil sharedInstance].needFresh = NO;
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf fetchtPuchaseList:data];
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    ICRUserUtil *userUtil = [ICRUserUtil sharedInstance];
    
    NSMutableArray *orderArr =[NSMutableArray array];
    if (orderArr.count == 0) {
        QueryOrder *order = [QueryOrder new];
        order.field = @"billNumber";
        order.direction = @"desc";
        [orderArr addObject:[order dictForCommit]];
    }
    billNumberObject = [NSNull null];
    if (self.contentStr.length > 0) {
        billNumberObject = self.contentStr;
    }
    NSDictionary *dict = @{
                           @"state":TRANSPORT_STATE_RECEIVED,
                           @"userUuid":userUtil.userId,
                           @"billNumberProductLike":billNumberObject,
                           @"queryOrders":orderArr,
                           @"fetchParts":@"pdtDetails",
                           @"pageNumber":@(_currentPage),
                           @"pageSize":@(20)
                             };
    [[ICRHTTPController sharedController] queryTransPortWithData:dict success:succ failure:fail];
}
- (void)fetchtPuchaseList:(id)data{
    if (data) {
        NSInteger success = [data[@"success"] integerValue];
        NSString *message  = data[@"message"] ;
        if (success == 1) {
            if (_currentPage == 0) {
                if (self.dataArr.count > 0) {
                    [self.dataArr removeAllObjects];
                }
            }
            NSArray *recodesArr = data[ @"data" ][ @"records" ];
            for (NSDictionary *purchaseBillDict in recodesArr) {
                Transport *purchaseBill = [[Transport alloc]init];
                [purchaseBill setValuesForKeysWithDictionary:purchaseBillDict];
                NSMutableArray *pdtArr = [NSMutableArray array];
                for (NSDictionary *pdtDetailDict in purchaseBill.pdtDetails) {
                    TransportPdtDetail *tran = [TransportPdtDetail new];
                    [tran setValuesForKeysWithDictionary:pdtDetailDict];
                    tran.purchasebillnumber = purchaseBill.billnumber;
                    tran.carnumber = purchaseBill.carnumber;
                    tran.carphone = purchaseBill.carphone;
                    [pdtArr addObject:tran];
                }
                purchaseBill.pdtDetails = pdtArr;
                [self.dataArr addObject:purchaseBill];
            }
            
            NSDictionary *pageDict = data[ @"data" ][ @"paging" ];
            NSInteger pageCount = [pageDict[@"pageCount"] integerValue];
            [self.tableView reloadData];
            [self endRefreshing];
            if (pageCount <= _currentPage) {
                [self.tableView.footer noticeNoMoreData];
            }
            if (_currentPage == 0 && self.dataArr.count > 0) {
                [self.tableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:0] atScrollPosition:UITableViewScrollPositionTop animated:YES];
            }
        }else{
            [IBTLoadingView showTips:message];
        }
        
    }
    else{
        [IBTLoadingView showTips:@"      无记录      "];
    }
}
- (void)checkWithBillNumber{
    if (self.indexArr.count > 0) {
        [self.indexArr removeAllObjects];
    }
    [self.selectTextFiled resignFirstResponder];
    if (self.selectTextFiled.text.length > 0) {
        self.contentStr = self.selectTextFiled.text;
    }else{
        self.contentStr = @"";
    }
    [self getData];
    
}

#pragma mark - 布局
- (void)bulidLayout
{
    self.selectTextFiled = [[UITextField alloc] initWithFrame:CGRectMake(20,5,ScreenSize.width - 100,TopMargin -10)];
    self.selectTextFiled.textAlignment = NSTextAlignmentLeft;
    self.selectTextFiled.background = [UIImage imageNamed:@"textFiled"];
    self.selectTextFiled.delegate = self;
    self.selectTextFiled.placeholder = @"类似发运和商品单号";
    self.selectTextFiled.font = GXF_FIFTEENTEN_SIZE;
    [self.view addSubview:self.selectTextFiled];
    
    
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame = CGRectMake(self.selectTextFiled.right + 5, 10, 60, TopMargin - 20);
    [btn setTitle:@"开始查询" forState:UIControlStateNormal];
    btn.titleLabel.font = FontSize(13);
    btn.layer.cornerRadius = 5;
    btn.layer.masksToBounds = YES;
    btn.backgroundColor = GXF_NAVIGAYION_COLOR;
    [btn addTarget:self action:@selector(checkWithBillNumber) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn];
    
    
    UIImageView *leftView = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, 35, 40)];
    leftView.image = [UIImage imageNamed:@"search"];
    self.selectTextFiled.leftView = leftView;
    self.selectTextFiled.leftViewMode = UITextFieldViewModeAlways;
    
    UIButton *rightView = [UIButton buttonWithType:UIButtonTypeCustom];
    [rightView setImage:[UIImage imageNamed:@"delete"] forState:UIControlStateNormal];
    rightView.frame = CGRectMake(0, 0, 35, 40);
    [rightView addTarget:self action:@selector(deleteTextFieldStr) forControlEvents:UIControlEventTouchUpInside];
    self.selectTextFiled.rightView = rightView;
    self.selectTextFiled.rightViewMode = UITextFieldViewModeAlways;
    
    
    self.tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,ScreenSize.width, ScreenHeight - 64 - TopMargin)) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.view addSubview:self.tableView];
    
    
    UIBarButtonItem *rightItem = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    self.navigationItem.rightBarButtonItem = rightItem;
}
- (void)createRefresh{
    self.tableView.header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        if (_isRefresh) {
            return ;
        }
        _isRefresh = YES;
        _currentPage = 0;
        [self getData];
    }];
    self.tableView.header.lastUpdatedTimeKey = ChooseTransportUpdateDate;
    
    self.tableView.footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        if (_isLoadMore) {
            return ;
        }
        _isLoadMore = YES;
        _currentPage ++;
        [self getData];
    } ];
}
#pragma mark - 结束刷新
- (void)endRefreshing{
    _isLoadMore = NO;
    _isRefresh = NO;
    [self.tableView.header endRefreshing];
    [self.tableView.footer endRefreshing];
}
- (void)deleteTextFieldStr{
    self.selectTextFiled.text = @"";
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"TransPortPurchase";
    TransportPurchaseCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[TransportPurchaseCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if(self.dataArr.count > 0){
        Transport *bill = _dataArr[indexPath.row];
        [cell setTransPort:bill selectArr:self.indexArr];
    }
    return cell;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    //44+38+10 + count* 44
    Transport *bill = _dataArr[indexPath.row];
    return 102 + bill.pdtDetails.count * 44;
}
#pragma mark - 按钮确定
- (void)sureClick{
    [self PopViewControllerAnimated:YES];
    if (self.indexArr.count > 0) {
        NSMutableArray*arr = [NSMutableArray array];
        for (TransportPdtDetail *detail in self.indexArr) {
            detail.purchasePdtDetail = detail.uuid;
            detail.uuid = nil;
            [arr addObject:detail];
        }
        self.getTransferProduct(arr);
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
