//
//  TransportDetailViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransportDetailViewController.h"
#import "TransportProductViewController.h"
#import "Transport.h"
#import "TransportPdtDetail.h"
#import "FeeAcountDetail.h"
#import "BottomTransportView.h"
#import "TransferPdtDetail.h"
#import "ReceiveProductViewController.h"
#import "NewReceiveProductViewController.h"


#define BottomHeight                                50
#define LeftMargin                                  15
#define LeftWidth                                   130
#define LeftHeight                                  30
#define TopMargin                                   15
typedef enum : NSUInteger {
    AbortTag = 20000,
    EndTag,
    SubmitTag,
    ReceiveTag,//收货状态：收货
    SaveTag
} BtnTag;

@interface TransportDetailViewController ()
{
    UIScrollView *_scrollView;
    UIView *_transportView;
    UIView *_bottomView;
    UIButton *_firstBtn;
    UIButton *_secondBtn;
    BottomTransportView *_transView;
    ReceiveProductViewController *_pvc;
    UIView *_recieveBottomView;

}
@property (nonatomic,strong)UILabel *billNumberLabel;
@property (nonatomic,strong)UILabel *purchaseLabel;
@property (nonatomic,strong)UILabel *stateLabel;
@property (nonatomic,strong)UILabel *warehouseLabel;
@property (nonatomic,strong)UILabel *rwarehouseLabel;
@property (nonatomic,strong)UILabel *carnumberLabel;
@property (nonatomic,strong)UILabel *carhoneLabel;
@property (nonatomic,strong)UILabel *createOperLabel;
@property (nonatomic, strong) UILabel *lastModifierLabel;
@property (nonatomic,strong)UILabel *arriveDateLabel;
@property (nonatomic,strong)UILabel *noteLabel;

@property (nonatomic,strong)UILabel *leftBillNumberLabel;
@property (nonatomic,strong)UILabel *leftPurchaseLabel;
@property (nonatomic,strong)UILabel *leftStateLabel;
@property (nonatomic,strong)UILabel *leftWarehouseLabel;
@property (nonatomic,strong)UILabel *leftRwarehouseLabel;
@property (nonatomic,strong)UILabel *leftCarnumberLabel;
@property (nonatomic,strong)UILabel *leftCarhoneLabel;
@property (nonatomic,strong)UILabel *leftCreateOperLabel;
@property (nonatomic, strong) UILabel *leftLastModifierLabel;
@property (nonatomic,strong)UILabel *leftArriveDateLabel;
@property (nonatomic,strong)UILabel *leftNoteLabel;


/**
 *  创建时间
 */
@property (strong, nonatomic) UILabel *labelCreateTime;
/**
 *  审核人
 */
@property (strong, nonatomic) UILabel *labelInspector;
/**
 *  审核时间
 */
@property (strong, nonatomic) UILabel *labelInspectTime;
/**
 *  收货人
 */
@property (strong, nonatomic) UILabel *labelReciever;
/**
 *  收货时间
 */
@property (strong, nonatomic) UILabel *labelRecieveTime;
/**
 *  有效期
 */
@property (strong, nonatomic) UILabel *labelExpiredDate;

@property (strong, nonatomic) NSArray *leftArr;
@end

@implementation TransportDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"发运单详情";
    [self bulifLayout];
    [self getDataFromServer];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(editReceiveProduct:) name:KNOTIFICATION_EditReceiveProduct object:nil];
}

- (void)dealloc{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)getDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message  = data[@"message"] ;
            if (success == 1) {
                NSDictionary *dictData = data[@"data"];
                Transport *transport = [[Transport alloc]init];
                [transport setValuesForKeysWithDictionary:dictData];
                self.transport = transport;
                [strongSelf fetchtTransportDetail];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"     无记录     "];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getTransportResultWithTransportUuid:self.transport.uuid success:succ failure:fail];
}




- (void)fetchtTransportDetail{
    _pvc.isHiddenEdit = ![self.transport.state isEqualToString:TRANSPORT_STATE_UNRECEIVED];
    self.billNumberLabel.text = [IBTCommon checkString:self.transport.billnumber];
    if ([self.transport.state isEqualToString:TRANSPORT_STATE_UNRECEIVED]) {
        self.stateLabel.textColor = [UIColor redColor];
        self.stateLabel.text = @"待收货";
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_RECEIVED]) {
        self.stateLabel.textColor = [UIColor greenColor];
        self.stateLabel.text = @"已收货";
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_ABORTED]) {
        self.stateLabel.textColor = [UIColor grayColor];
        self.stateLabel.text = @"已作废";
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_PROCESS]) {
        self.stateLabel.textColor = [UIColor greenColor];
        self.stateLabel.text = @"提交系统处理";
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_PROCESSFAIL]) {
        self.stateLabel.textColor = [UIColor blackColor];
        self.stateLabel.text = @"系统处理失败";
    }
    self.purchaseLabel.text = [self getPurchaseWith:self.transport.pdtDetails];
    self.warehouseLabel.text = [IBTCommon checkString:self.transport.warehouseName];
    self.rwarehouseLabel.text = [IBTCommon checkString:self.transport.rwarehouseName];
    self.carnumberLabel.text = [IBTCommon checkString:self.transport.carnumber];
    self.carhoneLabel.text = [IBTCommon checkString:self.transport.carphone];
    self.noteLabel.text = [NSString stringWithFormat:@"%@",self.transport.note?self.transport.note:@"无"];
    self.createOperLabel.text = [IBTCommon checkString:self.transport.create_operName];
    self.labelCreateTime.text = [IBTCommon checkString:self.transport.create_time];
    self.labelCreateTime.text = [IBTCommon checkString:self.transport.create_time];
    self.labelReciever.text = [IBTCommon checkString:self.transport.receive_operName];
    self.labelRecieveTime.text = [IBTCommon checkString:self.transport.receive_time];
    self.labelExpiredDate.text = [IBTCommon checkString:self.transport.expiredDate];
    self.lastModifierLabel.text = [IBTCommon checkString:self.transport.lastModify_operName];
    self.arriveDateLabel.text = [NSString stringWithFormat:@"%@",self.transport.arriveDate?[[IBTCommon checkString:self.transport.arriveDate]substringToIndex:10]:@"无"];
    
    NSMutableArray *productArr = [NSMutableArray array];
    if (self.type == TransportTypeAfterSubmit) {
        for (NSDictionary *billDict in self.transport.pdtDetails) {
            TransferPdtDetail *billProbuct = [TransferPdtDetail new];
            [billProbuct setValuesForKeysWithDictionary:billDict];
            TransportPdtDetail *t = [TransportPdtDetail new];
            [t setValuesForKeysWithDictionary:billDict];
            billProbuct.transportPdt = t;
            
            if ([self.transport.state isEqualToString:TRANSPORT_STATE_UNRECEIVED] && billProbuct.rctQty.floatValue == 0) {
                
                if (self.isWms){
                    [billProbuct z_setRctQty:0];
                }else{
                    billProbuct.rctQty = nil;
                    billProbuct.rctBaseQty = nil;
                    billProbuct.rctTotal = nil;
                }
            }else{
                [billProbuct z_setRctQty:billProbuct.rctQty.floatValue];
            }
            
            [productArr addObject:billProbuct];
        }
        _pvc.productArr = productArr;
        [_pvc.tableView reloadData];
    }else{
        [_transView refreshTranProduct:self.transport.pdtDetails];
    }
    
    
        [_transView refreshCost:self.transport.accountDetails];
        [self setNoteHeight];
    
}
- (NSString *)getPurchaseWith:(NSArray *)purchases{
    NSString *purchseNumber = @"";
    
    NSInteger count = 0;

    for (NSDictionary *billDict in purchases) {
        if (![billDict[@"purchasebillnumber"] isEqual:[NSNull null]]) {
            count ++;
            if (purchseNumber.length == 0) {
                purchseNumber = [purchseNumber stringByAppendingFormat:@"%@",billDict[@"purchasebillnumber"]];
            }else{
                purchseNumber = [purchseNumber stringByAppendingFormat:@",%@" ,billDict[@"purchasebillnumber"]];
            }
        }
    }
    if (count == 0) {
        purchseNumber = @"无";
    }
    return purchseNumber;
}
- (void)setNoteHeight
{
    CGFloat purchaseHeight = [self.purchaseLabel calculateHeight];
    if (purchaseHeight < LeftHeight) {
        purchaseHeight = LeftHeight;
    }

    CGFloat height =  [self.noteLabel calculateHeight];
    if (height < LeftHeight) {
        height = LeftHeight;
    }

    self.noteLabel.height = height;
    
    CGFloat totalHeight = height  - LeftHeight + LeftHeight*self.leftArr.count;
    
    CGRect purchaseFrame = _transportView.frame;
    purchaseFrame.size.height = totalHeight + LeftMargin;
    _transportView.frame = purchaseFrame;
    
        CGRect bottomFrame = _bottomView.frame;
        bottomFrame.origin.y = CGRectGetMaxY(_transportView.frame) + TopMargin;
        _bottomView.frame = bottomFrame;
        
        _scrollView.contentSize = CGSizeMake(ScreenSize.width, totalHeight + CGRectGetHeight(_bottomView.frame) + TopMargin*2);
    CGRect frame = _transView.productVC.viewFrame;
    _recieveBottomView.frame = frame;
    _pvc.viewFrame = CGRectMake(frame.origin.x, frame.origin.y, frame.size.width, frame.size.height - 10);
    
}

- (void)btnClick:(UIButton *)btn{
    CLog(@"%ld",(long)btn.tag);
    switch (btn.tag) {
        case AbortTag:
        {
            CLog(@"作废");
            UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"请确认作废" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
            alertView.delegate = self;
            alertView.tag = AbortTag;
            [alertView show];
        }
            break;
        case EndTag:
        {
            CLog(@"结束");
            UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"请确认结束" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
            alertView.delegate = self;
            alertView.tag = EndTag;
            [alertView show];
        }
            break;
        case SubmitTag:
        {
            CLog(@"提交");
            UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"请确认提交" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
            alertView.delegate = self;
            alertView.tag = SubmitTag;
            [alertView show];
        }
            break;
        
            case SaveTag:
        {
            if ([self checkReceive]) {
                [self httpSave];
            }
        }
            break;
        case ReceiveTag:{
            if ([self checkReceive]) {
                UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"收货后不能重复收货，请确认是否要收货？" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
                alertView.delegate = self;
                alertView.tag = ReceiveTag;
                [alertView show];
            }
        }break;
        default:
            break;
    }
}
- (void)dealByAction:(NSString *)action{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                [ICRUserUtil sharedInstance].needFresh = YES;
                [self PopViewControllerAnimated:YES];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"操作异常"];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    if ([action isEqualToString:TRANSPORT_STATE_ABORTED]) {
        [[ICRHTTPController sharedController] abortTransportWithTransportUuid:self.transport.uuid version:self.transport.version success:succ failure:fail];
    }else{
        [[ICRHTTPController sharedController] endTransportWithTransportUuid:self.transport.uuid version:self.transport.version success:succ failure:fail];
    }
}
- (void)hiddenAllBtn{
    CGRect scrollViewFrame = _scrollView.frame;
    scrollViewFrame.size.height = ScreenHeight - 64;
    _scrollView.frame = scrollViewFrame;
}

- (void)createBtnWithArr:(NSArray *)arr{
    CGFloat btnWidth = (ScreenSize.width - LeftMargin * (arr.count+1))/arr.count;
    for (NSInteger i = 0; i < arr.count; i++) {
        NSInteger btnTag = 0;
        if ([arr[i] isEqualToString:@"结束"]) {
            btnTag = EndTag;
        }else if ([arr[i] isEqualToString:@"作废"]) {
            btnTag = AbortTag;
        }else if ([arr[i] isEqualToString:@"提交"]) {
            btnTag = SubmitTag;
        }else if([arr[i] isEqualToString:@"收货"]){
            btnTag = ReceiveTag;
        }else if ([arr[i] isEqualToString:@"保存"]){
            btnTag = SaveTag;
        }
        CGRect btnFrame = CGRectMake(LeftMargin + (LeftMargin + btnWidth)*i,  ScreenHeight  - 64 - BottomHeight +5, btnWidth, 40);
        UIButton *perBtn = [IBTCustomButtom creatButtonWithFrame:btnFrame target:self sel:@selector(btnClick:) tag:btnTag image:nil title:arr[i] titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_COMMIT_COLOR];
        [self.view addSubview:perBtn];
    }
}


#pragma mark - 视图初始化
- (void)bulifLayout{
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenHeight - 64 - BottomHeight)];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.backgroundColor = XXFBgColor;
    [self.view addSubview:_scrollView];

    
    if ([self.transport.state isEqualToString:TRANSPORT_STATE_ABORTED]) {
        [self hiddenAllBtn];
    }else if([self.transport.state isEqualToString:TRANSPORT_STATE_FINISHED]){
        if ([IBTCommon checkIsPermission:TRANSPORT_ACTION_ABORT]) {
            NSArray *arr = @[@"作废"];
            [self createBtnWithArr:arr];
        }else{
            [self hiddenAllBtn];
        }
    }else if([self.transport.state isEqualToString:TRANSPORT_STATE_RECEIVED]){
        NSMutableArray *arr = [NSMutableArray array];
        if ([IBTCommon checkIsPermission:TRANSPORT_ACTION_ABORT]) {
            [arr addObject:@"作废"];
        }
//        if([IBTCommon checkIsPermission:TRANSPORT_ACTION_FINISH])
//        {
//            [arr addObject:@"结束"];
//        }
        if (arr.count == 0) {
            [self hiddenAllBtn];
        }else{
            [self createBtnWithArr:arr];
        }
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_PROCESSFAIL]){
        NSMutableArray *arr = [NSMutableArray array];
        if ([IBTCommon checkIsPermission:TRANSPORT_ACTION_ABORT]) {
            [arr addObject:@"作废"];
        }if ([IBTCommon checkIsPermission:TRANSPORT_ACTION_NEW]) {
            [arr addObject:@"提交"];
        }
        if (arr.count == 0) {
            [self hiddenAllBtn];
        }else{
            [self createBtnWithArr:arr];
        }
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_UNRECEIVED] && !self.isWms){
        NSMutableArray *arr = [NSMutableArray array];
        if ([IBTCommon checkIsPermission:TRANSPORT_ACTION_RECEIVE]) {//如果有收货权，则显示收货按钮
            [arr addObjectsFromArray:@[@"保存",@"收货"]];
        }
        //这里作废不受权限控制
        [arr addObject:@"作废"];
        [self createBtnWithArr:arr];
        
    }else{
        [self hiddenAllBtn];
    }
    NSArray *leftArr = @[@"单号:",@"采购单:",@"状态:",@"发货仓库:",@"收货仓库:",@"车辆:",@"司机电话:",@"创建人:",@"创建时间:",@"收货人:",@"收货时间:",@"有效期:",@"最后修改人:", @"预计到货时间:",@"备注:"];
    self.leftArr = leftArr;
    CGFloat height = LeftHeight * leftArr.count +LeftMargin;
    _transportView= [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, height)];
    _transportView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_transportView];
    
    
    for (NSInteger i = 0 ; i < leftArr.count; i++) {
        NSString *title = leftArr[i];
        UILabel *leftLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin, 10 + LeftHeight *i, LeftWidth, LeftHeight)];
        leftLabel.font = GXF_SEVENTEENTH_SIZE;
        leftLabel.text = title;
        leftLabel.textColor = GXF_DETAIL_COLOR;
        [_transportView addSubview:leftLabel];
        
        UILabel *rightLabel = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(leftLabel.frame), 10 + LeftHeight *i, _transportView.frame.size.width - LeftMargin - LeftWidth, LeftHeight)];
        rightLabel.font = GXF_SEVENTEENTH_SIZE;
        rightLabel.textColor = GXF_DETAIL_COLOR;
        
        
        
        if ([title isEqualToString:@"单号:"]) {
            self.billNumberLabel = rightLabel;
            self.leftBillNumberLabel = leftLabel;
        }else if ([title isEqualToString:@"采购单:"]){
            self.purchaseLabel = rightLabel;
            self.purchaseLabel.numberOfLines = 0;
            self.leftPurchaseLabel = leftLabel;
        }else if ([title isEqualToString:@"状态:"]){
            self.stateLabel = rightLabel;
            self.leftStateLabel = leftLabel;
        }else if ([title isEqualToString:@"发货仓库:"]){
            self.warehouseLabel = rightLabel;
            self.leftWarehouseLabel = leftLabel;
        }else if ([title isEqualToString:@"收货仓库:"]){
            self.rwarehouseLabel = rightLabel;
            self.leftRwarehouseLabel = leftLabel;
        }else if ([title isEqualToString:@"车辆:"]){
            self.carnumberLabel = rightLabel;
            self.leftCarnumberLabel = leftLabel;
        }else if ([title isEqualToString:@"司机电话:"]){
            self.carhoneLabel = rightLabel;
            self.leftCarhoneLabel = leftLabel;
        }else if ([title isEqualToString:@"创建人:"]){
            self.createOperLabel = rightLabel;
            self.leftCreateOperLabel = leftLabel;
        }
        else if ([title isEqualToString:@"最后修改人:"]){
            self.lastModifierLabel = rightLabel;
            self.leftLastModifierLabel = leftLabel;
        }
        else if ([title isEqualToString:@"预计到货时间:"]){
//            leftLabel.width = LeftWidth + 10;
//            rightLabel.left = leftLabel.right;
//            rightLabel.width = ScreenSize.width - leftLabel.width - LeftMargin;
            self.arriveDateLabel = rightLabel;
            self.leftArriveDateLabel = leftLabel;
        }else if ([title isEqualToString:@"备注:"]){
            rightLabel.numberOfLines = 0;
            self.noteLabel = rightLabel;
            self.leftNoteLabel = leftLabel;
        }else if ([title isEqualToString:@"创建时间:"]){
            self.labelCreateTime = rightLabel;
        }else if ([title isEqualToString:@"审核人:"]){
            self.labelInspector = rightLabel;
        }else if ([title isEqualToString:@"审核时间:"]){
            self.labelInspectTime = rightLabel;
        }else if ([title isEqualToString:@"收货人:"]){
            self.labelReciever = rightLabel;
        }else if ([title isEqualToString:@"收货时间:"]){
            self.labelRecieveTime = rightLabel;
        }else if ([title isEqualToString:@"有效期:"]){
            self.labelExpiredDate = rightLabel;
        }
        [_transportView addSubview:rightLabel];
    }
    [self createBottomView];
}

- (void)createBottomView{
    _bottomView= [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_transportView.frame) + TopMargin, ScreenSize.width, 300)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
    _transView = [[BottomTransportView alloc]initWithFrame:_bottomView.bounds withHidden:YES];
    [_bottomView addSubview:_transView];
    
    if (self.type == TransportTypeAfterSubmit) {
        _recieveBottomView= [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_transportView.frame) + TopMargin, ScreenSize.width, 300)];
        _recieveBottomView.backgroundColor = [UIColor redColor];
        [_scrollView addSubview:_recieveBottomView];
        
        _pvc = [[ReceiveProductViewController alloc]init];
        _pvc.viewFrame = _recieveBottomView.bounds;
        _pvc.isHiddenAdd = YES;
        [_recieveBottomView addSubview:_pvc.view];
    }
    
    CGRect frame = _transView.productVC.viewFrame;
    _recieveBottomView.frame = frame;
    _pvc.viewFrame = frame;
    [_transView.productVC.view addSubview:_recieveBottomView];
    
    
}

- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
    if (alertView.tag == AbortTag) {
        if (buttonIndex == 1) {
            if (self.isWms) {
                ShowMessage(@"wms仓不允许作废！");
                return;
            }
            [self dealByAction:TRANSPORT_STATE_ABORTED];//作废
        }
    }else if (alertView.tag == EndTag){
        if (buttonIndex == 1) {
            [self dealByAction:TRANSPORT_STATE_RECEIVED];//结束
        }
    }else if (alertView.tag == SubmitTag){
        if (buttonIndex == 1) {
            [self getDataFromServer:TRANSPORT_STATE_RECEIVED msg:@"正在提交..."];
        }
    }else if(alertView.tag == ReceiveTag){
        if (buttonIndex == 1) {
                [self httpRecieve];
        }
    }else if (alertView.tag == SaveTag){
        if (buttonIndex == 1) {
            [self httpSave];
        }
    }

}

#pragma mark - 提交
- (void)getDataFromServer:(NSString *)state msg:(NSString *)msg{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                [ICRUserUtil sharedInstance].needFresh = YES;
                [self PopViewControllerAnimated:YES];
            }else{
                [IBTLoadingView showTips:message];
            }
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    NSDictionary *dict = @{@"uuid":self.transport.uuid,
                           @"version":self.transport.version,
                           @"billnumber":self.transport.billnumber,
                           @"enterprise":[ICRUserUtil sharedInstance].orgId,
                           @"state":TRANSPORT_STATE_RECEIVED,
                           @"warehouseUuid":[IBTCommon checkString:self.transport.warehouseUuid],
                           @"warehouseCode":[IBTCommon checkString:self.transport.warehouseCode],
                           @"warehouseName":[IBTCommon checkString:self.transport.warehouseName],
                           @"rwarehouseUuid":[IBTCommon checkString:self.transport.rwarehouseUuid],
                           @"rwarehouseCode":[IBTCommon checkString:self.transport.rwarehouseCode],
                           @"rwarehouseName":[IBTCommon checkString:self.transport.rwarehouseName],
                           @"carnumber":[IBTCommon checkString:self.transport.carnumber],
                           @"type":[IBTCommon checkString:self.transport.type],
                           @"carphone":[IBTCommon checkString:self.transport.carphone],
                           @"arriveDate":[IBTCommon checkString:self.transport.arriveDate],
                           @"note":[IBTCommon checkString:self.transport.note],
                           @"pdtDetails":self.transport.pdtDetails,
                           @"accountDetails":self.transport.accountDetails};
    [IBTLoadingView showProgressLabel:msg];
    [[ICRHTTPController sharedController] saveAndSubmitTransportWithData:dict success:succ failure:fail];
    
}

- (void)editReceiveProduct:(NSNotification *)fination{
    NewReceiveProductViewController *nvc = [NewReceiveProductViewController new];
    NSInteger indexTag = [[[fination userInfo] objectForKey:@"indexPath"] integerValue];
    TransferPdtDetail *transferPdtDetail = [[fination userInfo] objectForKey:@"transferPdtDetail"];
    if (transferPdtDetail) {
        nvc.navTitle = @"商品明细";
        nvc.indexTag = indexTag;
        nvc.noticeProduct = transferPdtDetail;
    }
    nvc.editReceiveProduct = ^(TransferPdtDetail *transferPdtDetail,NSInteger indexTag){
        if (transferPdtDetail) {
            [_pvc.productArr replaceObjectAtIndex:indexTag withObject:transferPdtDetail];
            [_pvc.defaultState replaceObjectAtIndex:indexTag withObject:@"YES"];
            [_pvc.tableView reloadData];
        }
    };
    [self PushViewController:nvc animated:YES];
}

- (void)httpRecieve{
    NSString *receiveTime = [[NSDate date] httpParameterString];
    self.transport.receive_time = receiveTime;
    self.transport.receive_id = [ICRUserUtil sharedInstance].userId;
    self.transport.receive_operName = [ICRUserUtil sharedInstance].userName;
    
    NSMutableDictionary *param = [self.transport dictForCommit].mutableCopy;
    NSMutableArray *arrProduct = [NSMutableArray array];
    for (TransferPdtDetail *pdt in _pvc.productArr) {
        TransportPdtDetail *pPdt = [pdt changeToTransportPdt];
        NSDictionary *dict = [pPdt dictForCommit];
        [arrProduct addObject:dict];
    }
    
    [param setObject:arrProduct forKey:@"pdtDetails"];
    
    
    
    [param setObject:self.transport.accountDetails forKey:@"accountDetails"];
    
    IBTLoadingView *hud = [IBTLoadingView showHUDAddedTo:self.view animated:YES];
    __weak UIViewController *weakSelf = self;
    [HTTP recieveTransport:param success:^(id succ) {
        [hud hide:YES];
        if ([succ[@"success"] boolValue]) {
            [ICRUserUtil sharedInstance].needFresh = YES;
            [IBTLoadingView showTips:@"   收货成功！   "];
            [weakSelf.navigationController popViewControllerAnimated:YES];
        }else{
            [IBTLoadingView showTips:succ[@"message"]];
        }
    } failure:^(id fail) {
        [IBTLoadingView showTips:fail];
    }];
    
}


- (void)httpSave {
    
    for (TransferPdtDetail *detail in _pvc.productArr) {
        if (detail.rctQty == nil) {
            ShowMessage(@"请选择商品实收数量后再保存！");
            return;
            
        }
    }
    NSMutableDictionary *param = [self.transport dictForCommit].mutableCopy;
    NSMutableArray *arrProduct = [NSMutableArray array];
    for (TransferPdtDetail *pdt in _pvc.productArr) {
        TransportPdtDetail *pPdt = [pdt changeToTransportPdt];
        NSDictionary *dict = [pPdt dictForCommit];
        [arrProduct addObject:dict];
    }
    
    [param setObject:arrProduct forKey:@"pdtDetails"];
    [param setObject:self.transport.accountDetails forKey:@"accountDetails"];
    
    
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                //成功
                [IBTLoadingView showTips:@"   保存成功！   "];
                [self PopViewControllerAnimated:YES];
            }else{
                [IBTLoadingView showTips:message];
            }
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };

    

    [[ICRHTTPController sharedController] saveTransportWithData:param success:succ failure:fail];
    
}
- (BOOL)checkReceive{
    for (NSString *isEdit in _pvc.defaultState) {
        if ([isEdit isEqualToString:@"NO"]) {
            ShowMessage(@"有商品行没有编辑过收货数量，请先编辑再收货");
            return NO;
        }
    }
    
    if (_pvc.productArr.count == 0) {
        ShowMessage(@"商品不能为空");
        return NO;
    }
    
    for (TransferPdtDetail *pdt in _pvc.productArr) {
        if (pdt.rctQty == nil) {
            ShowMessage(@"有商品未填写收货数量！");
            return NO;
        }
    }
    
    return YES;
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */

@end
