//
//  ICRHomeViewController.m
//  XFFruit
//
//  Created by Xummer on 3/24/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#define M_HEAD_IMG_VIEW_HEIGHT               (190)
#define M_HEAD_VIEW_TITLE_LABEL_HEIGHT       (30)
#define M_HEAD_IMG_HEIGHT_WIDTH_PROPORTION   190.0f/320.0f

#import "ICRHomeViewController.h"

#import "ICRTaskListViewController.h"
#import "ICRPatrolPlanViewController.h"
#import "ICRStoreListViewController.h"
#import "ICRStoreDetailViewController.h"
#import "ICRAnnouncementViewController.h"

#import "ICRFunctionBaseView.h"
#import "ICRFunctionEntity.h"
#import "ICRFunctionBaseView.h"

#import "NewSurveyViewController.h"
#import "SurveyViewController.h"


@interface ICRHomeViewController ()
<
    ICRFunctionBaseViewDelegate,
    ICRStoreListViewDelegate
>

@property (strong, nonatomic) UIImageView *m_headImageView;
@property (strong, nonatomic) UILabel     *m_headViewTextLabel;

@end

@implementation ICRHomeViewController

#pragma mark - Life Cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self setupSubviews];
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method
- (void)setupSubviews {
    
    self.m_headImageView = [[UIImageView alloc] initWithFrame:(CGRect){
        .origin.x = 0,
        .origin.y = 0,
        .size.width = self.view.width,
        .size.height = self.view.width * M_HEAD_IMG_HEIGHT_WIDTH_PROPORTION
    }];
    _m_headImageView.image = [UIImage imageNamed:@"HomeDisplayImage"];
    
    self.m_headViewTextLabel = [[UILabel alloc] initWithFrame:(CGRect){
        .origin.x = 0,
        .origin.y = CGRectGetHeight(self.m_headImageView.frame) - M_HEAD_VIEW_TITLE_LABEL_HEIGHT,
        .size.width = CGRectGetWidth(self.m_headImageView.frame),
        .size.height = M_HEAD_VIEW_TITLE_LABEL_HEIGHT
    }];
    _m_headViewTextLabel.backgroundColor = [UIColor colorWithRed:0.310f green:0.345f blue:0.392f alpha:0.5f];
    _m_headViewTextLabel.textColor = [UIColor whiteColor];
    _m_headViewTextLabel.font = [UIFont systemFontOfSize:13];
    _m_headViewTextLabel.textAlignment = NSTextAlignmentCenter;
//    _m_headViewTextLabel.text = @"我是文字我是文字我是文字我是文字";
    
    [_m_headImageView addSubview:_m_headViewTextLabel];
    [self.view addSubview:_m_headImageView];
    
    NSMutableArray *arrFunctionEntities = [NSMutableArray array];
    
    NSArray *functionImageNames = @[ @"AnnouncementIcon",@"TaskManageIcon",@"PatrolPlanIcon",@"MyStoreIcon",@"MyStoreIcon",@"MyStoreIcon"];
    NSArray *fuctionNames = @[ [IBTCommon localizableString:@"Announcement"],
                              [IBTCommon localizableString:@"TaskManage"],
                              [IBTCommon localizableString:@"PatrolPlan"],
                              [IBTCommon localizableString:@"MyStore"],
                               [IBTCommon localizableString:@"Survey"],[IBTCommon localizableString:@"AddSurvey"]];
    NSArray *functionTags = @[ @(kFunctionAnnouncement),
                               @(kFunctionTaskManagement),
                               @(kFunctionPatrolPlan),
                               @(kFunctionMyShop),
                               @(kFunctionNavigation),
                               @(kFunctionComeShopReg)];

    int i = 0;
    for (NSString *functionName in fuctionNames) {
        ICRFunctionEntity *funtionEntity = [[ICRFunctionEntity alloc] init];
        funtionEntity.functionName = functionName;
        funtionEntity.iconName = [functionImageNames objectAtIndex:i];
        funtionEntity.functionItemTag = [[functionTags objectAtIndex:i] integerValue];
        [arrFunctionEntities addObject:funtionEntity];
        i ++;
    }
    
    ICRFunctionBaseView *baseView = [ICRFunctionBaseView initWithFunctionData:arrFunctionEntities];
    
    baseView.frame = (CGRect){
        .origin.x = 0,
        .origin.y = CGRectGetMaxY(_m_headImageView.frame),
        .size.width = CGRectGetWidth(self.view.frame),
        .size.height = CGRectGetHeight(self.view.frame) - CGRectGetHeight(_m_headImageView.frame)
    };
    baseView.backgroundColor = [UIColor clearColor];
    baseView.m_delegate = self;
    [self.view addSubview:baseView];
}

#pragma mark - ICRFunctionBaseViewDelegate
- (void)ICRFunctionBaseView:(ICRFunctionItemControl *)imageView {
    /*
     kFunctionAnnouncement = 0,
     kFunctionTaskManagement,
     kFunctionPatrolPlan,
     kFunctionMyShop,
     */
    switch (imageView.tag) {
        case kFunctionAnnouncement:
        {
            ICRAnnouncementViewController *aVC = [[ICRAnnouncementViewController alloc] init];
            [self PushViewController:aVC animated:YES];
        }
            break;
        case kFunctionTaskManagement:
        {
            ICRTaskListViewController *tVC = [[ICRTaskListViewController alloc] init];
            [self PushViewController:tVC animated:YES];
        }
            break;
        case kFunctionPatrolPlan:
        {
            ICRPatrolPlanViewController *pVC = [[ICRPatrolPlanViewController alloc] initWithStore:nil isHomeShow:YES];
            [self PushViewController:pVC animated:YES];
        }
            break;
        case kFunctionMyShop:
        {
            ICRStoreListViewController *sVC = [[ICRStoreListViewController alloc] initWithBHaveToChooseOne:NO];
            sVC.title = [IBTCommon localizableString:@"MyStore"];
            sVC.m_delegate = self;
            [self PushViewController:sVC animated:YES];
        }
            break;
        case kFunctionNavigation:
        {
            SurveyViewController *svc = [[SurveyViewController alloc] init];
            svc.title = [IBTCommon localizableString:@"Survey"];
            [self PushViewController:svc animated:YES];
        }
            break;
        case kFunctionComeShopReg:
        {
            NewSurveyViewController *svc = [[NewSurveyViewController alloc] init];
            svc.title = [IBTCommon localizableString:@"AddSurvey"];
            [self PushViewController:svc animated:YES];
        }
            break;
        default:
            break;
    }
}

#pragma mark - ICRStoreListViewDelegate
- (void)storeListViewCtrl:(ICRStoreListViewController *)vCtrl didSelectedStore:(ICRStore *)store {
    ICRStoreDetailViewController *dVC = [[ICRStoreDetailViewController alloc] initWithStoreData:store];
    [vCtrl PushViewController:dVC animated:YES];
}

@end
