//
//  BoltMaskView.m
//  XFFurit
//
//  Created by 陈俊俊 on 15/8/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "BoltMaskView.h"
#import "MaskCell.h"
#define TableHeight 35
#define LeftMargin 80
#define TotalHeight 176
#define LeftHeight 44
@interface BoltMaskView ()
{
    UIView *_leftView;
    UIButton *_currentBtn;
    NSIndexPath *_currentIndexPath;
}
@end

@implementation BoltMaskView
- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        [self createView];
    }
    return self;
}

#pragma mark - 创建视图
- (void)createView
{
    _leftView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, LeftMargin,self.frame.size.height)];
    [self addSubview:_leftView];
    NSArray *arr = @[@"按状态",@"条件一",@"条件二",@"条件三"];
    for (NSInteger i = 0; i<arr.count; i++) {
        UIButton *button = [UIButton buttonWithType:UIButtonTypeSystem];
        button.frame = CGRectMake(0, LeftHeight * i ,  LeftMargin ,LeftHeight);
        [button setTitle:arr[i] forState:UIControlStateNormal];
        [button setTitleColor:HexColor(@"888888") forState:UIControlStateNormal];
        if (i == 0) {
            button.enabled = NO;
            _currentBtn = button;
        }
        [button setBackgroundImage:[UIImage imageNamed:@"maskEnable"] forState:UIControlStateDisabled];
        [button setBackgroundImage:[UIImage imageNamed:@"mask"] forState:UIControlStateNormal];
        button.tag = 1001+i;
        [button addTarget:self action:@selector(leftBtnClick:) forControlEvents:UIControlEventTouchUpInside];
        [_leftView addSubview:button];
    }
    
    self.tableView = [[UITableView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self addSubview:self.tableView];
}

- (void)leftBtnClick:(UIButton *)btn{
    _currentBtn.enabled = YES;
    btn.enabled = NO;
    _currentBtn = btn;

}
#pragma mark - 协议
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskID";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth: ScreenSize.width - 80 totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (_dataArr.count > 0) {
        cell.Commitbtn.hidden = YES;
        [cell setTitleStr:self.dataArr[indexPath.row]];
        
    }
    if (_currentIndexPath) {
        if (indexPath.row == _currentIndexPath.row) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    //获取选中的cell
    MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
    currentCell.Commitbtn.hidden = YES;
    MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
    cell.Commitbtn.hidden = NO;
    _currentIndexPath = indexPath;
    
    [self.delegate getBoltValueSelectRow:@"tt"];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}

@end
