//
//  MaskCell.m
//  XFFurit
//
//  Created by 陈俊俊 on 15/8/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "MaskCell.h"
#define TitleSize 14
#define LeftMargin 20
#define TableHeight 35
#define BtnSize 14
@implementation MaskCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier totalWidth:(CGFloat)totalWidth totalHeight:(CGFloat)totalHeight{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        self.totalWidth = totalWidth;
        self.totalHeight = totalHeight;
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, 0, 100, self.totalHeight))];
    self.titleLabel.textAlignment= NSTextAlignmentLeft;
    self.titleLabel.textColor = HexColor(@"666666");
    self.titleLabel.font = FontSize(TitleSize);
    
    self.Commitbtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(self.totalWidth- LeftMargin - BtnSize, 10, BtnSize, BtnSize) target:nil sel:nil tag:0 image:@"selected" title:nil titleColor:nil isCorner:NO corner:0 bgColor:nil];
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, self.totalHeight-1, self.totalWidth - LeftMargin * 2, 1))];
    self.lineLabel.backgroundColor = HexColor(@"e5e5e5");
    self.lineLabel.font = FontSize(TitleSize);
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.lineLabel];
    [self.contentView addSubview:self.Commitbtn];
}
- (void)setTitleStr:(NSString *)str
{
    self.titleLabel.text = str;
}
- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
